/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config.transformer.name;

import hudson.Util;
import java.util.Collections;
import java.util.Set;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class PrefixRemover {
    private final Set<String> prefixes;

    private PrefixRemover(Set<String> prefixes) {
        this.prefixes = prefixes;
    }

    public static PrefixRemover removePrefixes(Set<String> prefixes) {
        return new PrefixRemover(prefixes);
    }

    public static PrefixRemover removePrefix(String prefix) {
        Set<String> prefixes = Collections.singleton(prefix);
        return new PrefixRemover(prefixes);
    }

    public String from(String str) {
        if (this.prefixes == null) {
            return str;
        }
        int longestMatchingPrefix = PrefixRemover.longestMatchingPrefix(str, this.prefixes);
        return str.substring(longestMatchingPrefix);
    }

    private static int longestMatchingPrefix(String str, Set<String> prefixes) {
        int longestMatch = 0;
        for (String prefix : prefixes) {
            int prefixLength;
            String canonicalPrefix = PrefixRemover.fixNullAndTrim(prefix);
            if (!str.startsWith(canonicalPrefix) || (prefixLength = canonicalPrefix.length()) <= longestMatch) continue;
            longestMatch = prefixLength;
        }
        return longestMatch;
    }

    private static String fixNullAndTrim(String s) {
        return Util.fixNull((String)s).trim();
    }
}

