/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.http.client.utils.URIBuilder;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

public class ClientConfiguration
extends AbstractDescribableImpl<ClientConfiguration>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nonProxyHosts;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private Secret proxyPassword;

    @DataBoundConstructor
    public ClientConfiguration(String nonProxyHosts, String proxyHost, Integer proxyPort, String proxyUsername, Secret proxyPassword) {
        this.nonProxyHosts = nonProxyHosts;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @DataBoundSetter
    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    @DataBoundSetter
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @DataBoundSetter
    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @DataBoundSetter
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public Secret getProxyPassword() {
        return this.proxyPassword;
    }

    @DataBoundSetter
    public void setProxyPassword(Secret proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConfiguration that = (ClientConfiguration)o;
        return Objects.equals(this.proxyPort, that.proxyPort) && Objects.equals(this.nonProxyHosts, that.nonProxyHosts) && Objects.equals(this.proxyHost, that.proxyHost) && Objects.equals(this.proxyUsername, that.proxyUsername) && Objects.equals(this.proxyPassword, that.proxyPassword);
    }

    public int hashCode() {
        return Objects.hash(this.nonProxyHosts, this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword);
    }

    public SdkHttpClient build() {
        return ApacheHttpClient.builder().proxyConfiguration(this.buildProxyConfiguration()).build();
    }

    private ProxyConfiguration buildProxyConfiguration() {
        URI proxyEndpoint = this.buildProxyEndpoint();
        return (ProxyConfiguration)ProxyConfiguration.builder().nonProxyHosts(Collections.singleton(this.nonProxyHosts)).endpoint(proxyEndpoint).username(this.proxyUsername).password(Secret.toString((Secret)this.proxyPassword)).build();
    }

    private URI buildProxyEndpoint() {
        URIBuilder proxyEndpointBuilder = new URIBuilder().setHost(this.proxyHost);
        if (this.proxyPort != null) {
            proxyEndpointBuilder.setPort(this.proxyPort.intValue());
        }
        try {
            return proxyEndpointBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Extension
    @Symbol(value={"clientConfiguration"})
    public static class DescriptorImpl
    extends Descriptor<ClientConfiguration> {
        @Nonnull
        public String getDisplayName() {
            return Messages.clientConfiguration();
        }
    }
}

