/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.time.Duration;
import java.util.function.Supplier;

final class CustomSuppliers {
    private CustomSuppliers() {
    }

    public static <T> Supplier<T> memoizeWithExpiration(Supplier<T> delegate, Supplier<Duration> duration) {
        return new ExpiringMemoizingSupplier<T>(delegate, duration);
    }

    static class ExpiringMemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        final Supplier<Duration> duration;
        volatile transient T value;
        volatile transient long expirationNanos;
        private static final long serialVersionUID = 0L;

        ExpiringMemoizingSupplier(Supplier<T> delegate, Supplier<Duration> duration) {
            this.delegate = (Supplier)Preconditions.checkNotNull(delegate);
            this.duration = duration;
        }

        private long getDurationNanos() {
            Duration d = this.duration.get();
            Preconditions.checkArgument((!d.isNegative() && !d.isZero() ? 1 : 0) != 0);
            return d.toNanos();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            long nanos = this.expirationNanos;
            long now = System.nanoTime();
            if (nanos == 0L || now - nanos >= 0L) {
                ExpiringMemoizingSupplier expiringMemoizingSupplier = this;
                synchronized (expiringMemoizingSupplier) {
                    if (nanos == this.expirationNanos) {
                        T t = this.delegate.get();
                        this.value = t;
                        nanos = now + this.getDurationNanos();
                        this.expirationNanos = nanos == 0L ? 1L : nanos;
                        return t;
                    }
                }
            }
            return this.value;
        }
    }
}

