/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import io.jenkins.plugins.credentials.secretsmanager.config.ClientConfiguration;
import io.jenkins.plugins.credentials.secretsmanager.config.EndpointConfiguration;
import io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider.CredentialsProvider;
import io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider.DefaultAWSCredentialsProviderChain;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class Client
extends AbstractDescribableImpl<Client>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ClientConfiguration clientConfiguration;
    private CredentialsProvider credentialsProvider;
    private EndpointConfiguration endpointConfiguration;
    private String region;

    @DataBoundConstructor
    public Client(ClientConfiguration clientConfiguration, CredentialsProvider credentialsProvider, EndpointConfiguration endpointConfiguration, String region) {
        this.clientConfiguration = clientConfiguration;
        this.credentialsProvider = credentialsProvider;
        this.endpointConfiguration = endpointConfiguration;
        this.region = region;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    @DataBoundSetter
    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    @DataBoundSetter
    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @DataBoundSetter
    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public String getRegion() {
        return this.region;
    }

    @DataBoundSetter
    public void setRegion(String region) {
        this.region = Util.fixEmptyAndTrim((String)region);
    }

    private static Optional<ProxyConfiguration> getProxyConfiguration() {
        Optional<Jenkins> maybeJenkins = Optional.ofNullable(Jenkins.getInstanceOrNull());
        return maybeJenkins.flatMap(j -> Optional.ofNullable(j.getProxy()));
    }

    static com.amazonaws.ClientConfiguration toClientConfiguration(ProxyConfiguration proxyConfiguration) {
        com.amazonaws.ClientConfiguration configuration = new com.amazonaws.ClientConfiguration();
        configuration.setProxyHost(proxyConfiguration.getName());
        configuration.setProxyPort(proxyConfiguration.getPort());
        configuration.setProxyUsername(proxyConfiguration.getUserName());
        configuration.setProxyPassword(Secret.toString((Secret)proxyConfiguration.getSecretPassword()));
        configuration.setNonProxyHosts(proxyConfiguration.getNoProxyHost());
        return configuration;
    }

    public AWSSecretsManager build() {
        AWSSecretsManagerClientBuilder builder = AWSSecretsManagerClientBuilder.standard();
        if (this.clientConfiguration != null) {
            builder.setClientConfiguration(this.clientConfiguration.build());
        } else {
            Optional<ProxyConfiguration> proxyConfiguration = Client.getProxyConfiguration();
            proxyConfiguration.ifPresent(p -> {
                com.amazonaws.ClientConfiguration proxyClientConfiguration = Client.toClientConfiguration(p);
                builder.setClientConfiguration(proxyClientConfiguration);
            });
        }
        if (this.credentialsProvider != null) {
            builder.setCredentials(this.credentialsProvider.build());
        }
        if (this.endpointConfiguration != null) {
            builder.setEndpointConfiguration(this.endpointConfiguration.build());
        }
        if (this.region != null && !this.region.isEmpty()) {
            builder.setRegion(this.region);
        }
        return (AWSSecretsManager)builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client)o;
        return Objects.equals(this.clientConfiguration, client.clientConfiguration) && Objects.equals(this.credentialsProvider, client.credentialsProvider) && Objects.equals(this.endpointConfiguration, client.endpointConfiguration) && Objects.equals(this.region, client.region);
    }

    public int hashCode() {
        return Objects.hash(this.clientConfiguration, this.credentialsProvider, this.endpointConfiguration, this.region);
    }

    @Extension
    @Symbol(value={"client"})
    public static class DescriptorImpl
    extends Descriptor<Client> {
        public CredentialsProvider getDefaultCredentialsProvider() {
            return new DefaultAWSCredentialsProviderChain();
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.client();
        }

        public ListBoxModel doFillRegionItems() {
            ListBoxModel regions = new ListBoxModel();
            regions.add("", "");
            for (Regions s : Regions.values()) {
                regions.add(s.getDescription(), s.getName());
            }
            return regions;
        }
    }
}

