/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.Permission;
import io.jenkins.plugins.credentials.secretsmanager.AwsCredentialsProvider;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.stapler.export.ExportedBean;

public class AwsCredentialsStore
extends CredentialsStore {
    private final AwsCredentialsProvider provider;
    private final AwsCredentialsStoreAction action = new AwsCredentialsStoreAction(this);

    public AwsCredentialsStore(AwsCredentialsProvider provider) {
        super(AwsCredentialsProvider.class);
        this.provider = provider;
    }

    @Nonnull
    public ModelObject getContext() {
        return Jenkins.get();
    }

    public boolean hasPermission(@NonNull Authentication authentication, @NonNull Permission permission) {
        return CredentialsProvider.VIEW.equals((Object)permission) && Jenkins.get().getACL().hasPermission(authentication, permission);
    }

    @Nonnull
    public List<Credentials> getCredentials(@NonNull Domain domain) {
        if (Domain.global().equals((Object)domain) && Jenkins.get().hasPermission(CredentialsProvider.VIEW)) {
            return this.provider.getCredentials(Credentials.class, (ItemGroup)Jenkins.get(), ACL.SYSTEM);
        }
        return Collections.emptyList();
    }

    public boolean addCredentials(@Nonnull Domain domain, @Nonnull Credentials credentials) {
        throw new UnsupportedOperationException("Jenkins may not add credentials to AWS Secrets Manager");
    }

    public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException("Jenkins may not remove credentials from AWS Secrets Manager");
    }

    public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) {
        throw new UnsupportedOperationException("Jenkins may not update credentials in AWS Secrets Manager");
    }

    @Nullable
    public CredentialsStoreAction getStoreAction() {
        return this.action;
    }

    @ExportedBean
    public static class AwsCredentialsStoreAction
    extends CredentialsStoreAction {
        private static final String ICON_CLASS = "icon-aws-secrets-manager-credentials-store";
        private final AwsCredentialsStore store;

        private AwsCredentialsStoreAction(AwsCredentialsStore store) {
            this.store = store;
            this.addIcons();
        }

        private void addIcons() {
            IconSet.icons.addIcon(new Icon("icon-aws-secrets-manager-credentials-store icon-sm", "aws-secrets-manager-credentials-provider/images/16x16/icon.png", "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-aws-secrets-manager-credentials-store icon-md", "aws-secrets-manager-credentials-provider/images/24x24/icon.png", "width: 24px; height: 24px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-aws-secrets-manager-credentials-store icon-lg", "aws-secrets-manager-credentials-provider/images/32x32/icon.png", "width: 32px; height: 32px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-aws-secrets-manager-credentials-store icon-xlg", "aws-secrets-manager-credentials-provider/images/48x48/icon.png", "width: 48px; height: 48px;", IconType.PLUGIN));
        }

        @NonNull
        public CredentialsStore getStore() {
            return this.store;
        }

        public String getIconFileName() {
            return this.isVisible() ? "/plugin/aws-secrets-manager-credentials-provider/images/32x32/icon.png" : null;
        }

        public String getIconClassName() {
            return this.isVisible() ? ICON_CLASS : null;
        }

        public String getDisplayName() {
            return Messages.awsSecretsManager();
        }
    }
}

