package com.amazon.inspector.jenkins.amazoninspectorbuildstep.models.sbom.Components;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
@Builder
public class Vulnerability {
    private String bomRef;
    private String id;
    private Source source;
    private List<Reference> references;
    private List<Rating> ratings;
    private List<Integer> cwes;
    private String description;
    private List<Advisory> advisories;
    private String created;
    private String modified;
    private String updated;
    private List<Affect> affects;
    private List<Property> properties;

    public Double getEpssScore() {
        if (ratings == null) {
            return null;
        }
        for (Rating rating : ratings) {
            if (rating.getSource() != null && "EPSS".equalsIgnoreCase(rating.getSource().getName())) {
                return rating.getScore();
            }
        }
        return null;
    }
}
