/*
 * Decompiled with CFR 0.152.
 */
package com.sap.prd.jenkins.plugins.agent_maintenance;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceHelper;
import com.sap.prd.jenkins.plugins.agent_maintenance.MaintenanceWindow;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.security.ACL;
import hudson.util.FormValidation;
import java.io.ObjectStreamException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class RecurringMaintenanceWindow
extends AbstractDescribableImpl<RecurringMaintenanceWindow> {
    private static final CronDefinition cronDefinition = CronDefinitionBuilder.defineCron().withMinutes().withValidRange(0, 59).withStrictRange().and().withHours().withValidRange(0, 23).withStrictRange().and().withDayOfMonth().withValidRange(1, 31).supportsL().supportsW().supportsLW().supportsQuestionMark().and().withMonth().withValidRange(1, 12).withStrictRange().and().withDayOfWeek().withValidRange(0, 7).withMondayDoWValue(1).withIntMapping(7, 0).supportsHash().supportsL().supportsQuestionMark().withStrictRange().and().instance();
    private static final CronParser parser = new CronParser(cronDefinition);
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int CHECK_INTERVAL_MINUTES = Integer.getInteger(RecurringMaintenanceWindow.class.getName() + ".CHECK_INTERVAL_MINUTES", 15);
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int LEAD_TIME_DAYS = Integer.getInteger(RecurringMaintenanceWindow.class.getName() + ".LEAD_TIME_DAYS", 7);
    private static final Logger LOGGER = Logger.getLogger(RecurringMaintenanceWindow.class.getName());
    private final String reason;
    private final boolean takeOnline;
    private final boolean keepUpWhenActive;
    private final String maxWaitMinutes;
    private final String userid;
    private String id;
    private final String startTimeSpec;
    private final int duration;
    private long nextCheck = 0L;
    private transient Cron cron;

    @DataBoundConstructor
    public RecurringMaintenanceWindow(String startTimeSpec, String reason, boolean takeOnline, boolean keepUpWhenActive, String maxWaitMinutes, String duration, String userid, String id, long nextCheck) {
        this.startTimeSpec = startTimeSpec;
        this.cron = parser.parse(startTimeSpec);
        this.reason = reason;
        this.takeOnline = takeOnline;
        this.maxWaitMinutes = maxWaitMinutes;
        this.keepUpWhenActive = keepUpWhenActive;
        this.duration = MaintenanceHelper.parseDurationString(duration);
        this.nextCheck = nextCheck;
        if (Util.fixEmptyAndTrim((String)userid) == null) {
            Authentication auth = Jenkins.getAuthentication2();
            userid = "System";
            if (auth != ACL.SYSTEM2) {
                userid = auth.getName();
            }
        }
        this.userid = userid;
        if (Util.fixEmptyAndTrim((String)id) == null) {
            id = UUID.randomUUID().toString();
        }
        this.id = id;
    }

    protected synchronized Object readResolve() throws ObjectStreamException {
        this.cron = parser.parse(this.startTimeSpec);
        return this;
    }

    public String getStartTimeSpec() {
        return this.startTimeSpec;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isTakeOnline() {
        return this.takeOnline;
    }

    public boolean isKeepUpWhenActive() {
        return this.keepUpWhenActive;
    }

    public String getMaxWaitMinutes() {
        return this.maxWaitMinutes;
    }

    public String getUserid() {
        return this.userid;
    }

    @Restricted(value={NoExternalUse.class})
    public long getNextCheck() {
        return this.nextCheck;
    }

    @Restricted(value={NoExternalUse.class})
    public String getId() {
        return this.id;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public synchronized Set<MaintenanceWindow> getFutureMaintenanceWindows() {
        LOGGER.log(Level.FINER, "Checking for future maintenance Windows.");
        ZonedDateTime now = ZonedDateTime.now().truncatedTo(ChronoUnit.MINUTES);
        ZoneId zoneId = now.getZone();
        TreeSet<MaintenanceWindow> futureMaintenanceWindows = new TreeSet<MaintenanceWindow>();
        if (now.toEpochSecond() > this.nextCheck) {
            Instant instant = Instant.ofEpochSecond(this.nextCheck);
            ZonedDateTime time = ZonedDateTime.ofInstant(instant, zoneId).truncatedTo(ChronoUnit.MINUTES);
            ZonedDateTime endCheckTime = time.plusMinutes(CHECK_INTERVAL_MINUTES);
            if (endCheckTime.isBefore(now)) {
                endCheckTime = now.plusMinutes(CHECK_INTERVAL_MINUTES);
            }
            ZonedDateTime nextCheckTime = endCheckTime;
            if ((time = time.plusHours((long)LEAD_TIME_DAYS * 24L)).isBefore(now)) {
                time = now;
            }
            endCheckTime = endCheckTime.plusHours((long)LEAD_TIME_DAYS * 24L);
            endCheckTime = endCheckTime.minusMinutes(1L);
            LOGGER.log(Level.FINE, "Check for maintenance window starts between: {0} and {1}", new Object[]{time.toString(), endCheckTime.toString()});
            while (endCheckTime.isAfter(time)) {
                if (ExecutionTime.forCron((Cron)this.cron).isMatch(time)) {
                    LOGGER.log(Level.FINER, "Time matched: {0}", time.toString());
                    futureMaintenanceWindows.add(this.getMaintenanceWindow(time));
                }
                time = time.plusMinutes(1L);
            }
            this.nextCheck = nextCheckTime.toEpochSecond();
            LOGGER.log(Level.FINER, "Setting next Check time to: {0}", nextCheckTime.toString());
        }
        return futureMaintenanceWindows;
    }

    private MaintenanceWindow getMaintenanceWindow(ZonedDateTime time) {
        LocalDateTime startTime = LocalDateTime.ofInstant(time.toInstant(), time.getZone());
        LocalDateTime endTime = startTime.plusMinutes(this.duration);
        return new MaintenanceWindow(startTime, endTime, this.reason, this.takeOnline, this.keepUpWhenActive, this.maxWaitMinutes, this.userid, "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.duration;
        result = 31 * result + (this.keepUpWhenActive ? 1231 : 1237);
        result = 31 * result + (this.maxWaitMinutes == null ? 0 : this.maxWaitMinutes.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.startTimeSpec == null ? 0 : this.startTimeSpec.hashCode());
        result = 31 * result + (this.takeOnline ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RecurringMaintenanceWindow other = (RecurringMaintenanceWindow)((Object)obj);
        if (this.startTimeSpec == null ? other.startTimeSpec != null : !this.startTimeSpec.equals(other.startTimeSpec)) {
            return false;
        }
        if (this.keepUpWhenActive != other.keepUpWhenActive) {
            return false;
        }
        if (!this.maxWaitMinutes.equals(other.maxWaitMinutes)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        return this.takeOnline == other.takeOnline;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RecurringMaintenanceWindow> {
        @NonNull
        public String getDisplayName() {
            return "";
        }

        @POST
        public FormValidation doCheckStartTimeSpec(@QueryParameter String value) {
            try {
                Cron cron = parser.parse(value);
                ExecutionTime et = ExecutionTime.forCron((Cron)cron);
                ZonedDateTime last = et.lastExecution(ZonedDateTime.now()).orElse(null);
                ZonedDateTime next = et.nextExecution(ZonedDateTime.now()).orElse(null);
                if (next != null && last != null) {
                    String msg = "Would have last run at " + String.valueOf(last) + "; would next run at " + String.valueOf(next);
                    return FormValidation.warning((String)msg);
                }
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

