package gg.jte.generated.precompiled;
import io.jenkins.tools.pluginmodernizer.core.model.Plugin;
import io.jenkins.tools.pluginmodernizer.core.model.Recipe;
@SuppressWarnings("unchecked")
public final class JteprbodyUpgradeNextMajorParentVersionGenerated {
	public static final String JTE_NAME = "pr-body-UpgradeNextMajorParentVersion.jte";
	public static final int[] JTE_LINE_INFO = {0,0,1,2,2,2,2,4,4,4,4,7,7,7,7,8,8,8,9,9,9,10,10,10,54,54,54,2,3,3,3,3};
	public static void render(gg.jte.html.HtmlTemplateOutput jteOutput, gg.jte.html.HtmlInterceptor jteHtmlInterceptor, Plugin plugin, Recipe recipe) {
		jteOutput.writeContent("Hello `");
		jteOutput.setContext("html", null);
		jteOutput.writeUserContent(plugin.getName());
		jteOutput.writeContent("` developers! :wave:\n\nThis is an automated pull request created by the [Jenkins Plugin Modernizer](https://github.com/jenkins-infra/plugin-modernizer-tool) tool. The tool has applied the following recipes to modernize the plugin:\n<details aria-label=\"Recipe details for ");
		jteOutput.setContext("details", "aria-label");
		jteOutput.writeUserContent(recipe.getDisplayName());
		jteOutput.setContext("details", null);
		jteOutput.writeContent("\">\n    <summary>");
		jteOutput.setContext("summary", null);
		jteOutput.writeUserContent(recipe.getDisplayName());
		jteOutput.writeContent("</summary>\n    <p><em>");
		jteOutput.setContext("em", null);
		jteOutput.writeUserContent(recipe.getName());
		jteOutput.writeContent("</em></p>\n    <blockquote>");
		jteOutput.setContext("blockquote", null);
		jteOutput.writeUserContent(recipe.getDescription());
		jteOutput.writeContent("</blockquote>\n</details>\n\n#### Why Upgrade to Java 17 and Jenkins 2.516.x?\n\n- **Embrace Java 17 LTS Stability:** Benefit from long-term support with modern language features that improve development practice and plugin performance.\n\n- **Harness Jenkins 2.516.x Innovations:** Stay aligned with the latest features and stability improvements, ensuring smooth integration and future-proofing.\n\n- **Enhance Security:** Protect your plugin with up-to-date security fixes from both Java 17 and Jenkins core improvements.\n\n- **Align with the Community:** Keep pace with ecosystem shifts towards Java 17, ensuring compatibility and expanding your plugin's user base.\n\n- **Enjoy a Better Developer Experience:** Make the most of advanced tooling support and simplified dependency management with Java 17's enhancements.\n\n#### Removing `developers` Tag from `pom.xml`\n\nJenkins no longer requires the `developers` tag in `pom.xml`, as the `developers` section was traditionally used to list individuals responsible for the plugin.\nInstead, Jenkins now uses the Repository Permission Updater (RPU) to manage permissions and developer information.\n\n##### Benefits of Removing `developers` Tag:\n\n- **Simplification:** Removes unnecessary metadata from the `pom.xml`, resulting in a cleaner and more maintainable file.\n- **Consistency:** Centralizes developer information management through the RPU, minimizing discrepancies.\n- **Security:** Utilizes the RPU's controlled permission management, enhancing the security of artifact deployments.\n\nRemoving the `developers` tag aligns with modern Jenkins infrastructure standards and prevents outdated or redundant developer information from being included in plugin metadata.\n\n#### JEP-227: Replace Acegi Security with Spring Security\n\nMigrating Jenkins plugin code from Acegi Security to Spring Security is important for several reasons:\n- **Security updates**: Spring Security is the modern, actively maintained [successor to Acegi Security](https://github.com/jenkinsci/jep/blob/master/jep/227/README.adoc), providing up-to-date security features and patches.\n- **Compatibility**: Jenkins core version 2.266 and later have replaced Acegi Security with Spring Security, so plugins need to be updated to remain compatible with newer Jenkins versions.\n- **Eliminating false positives**: Security scanners often flag the outdated Acegi Security library as vulnerable, causing unnecessary concerns and exemption requests in security-conscious organizations.\n- **Reducing technical debt**: The Acegi Security code in Jenkins was written over 13 years ago and has barely been touched since, making it difficult to maintain and understand.\n- **Access to modern features**: Spring Security offers more current security implementations and features that weren't available in Acegi Security.\n- **Community support**: With the Jenkins ecosystem moving to Spring Security, plugins using the newer library will benefit from better community support and compatibility with other plugins.\n- **Simplified API**: The migration offers an opportunity to introduce a new simplified security API in Jenkins, potentially making it easier for plugin developers to work with security-related functions.\n\nBy migrating to Spring Security, plugin developers ensure their code remains compatible with current Jenkins versions, benefit from modern security features, and contribute to a more secure and maintainable Jenkins ecosystem.\n\n#### Summary\n\nBy upgrading, you'll be positioning your plugin at the forefront of performance, security, and user satisfaction. We encourage you to explore these updates and provide feedback. Let's continue to build a robust Jenkins ecosystem together!\n");
	}
	public static void renderMap(gg.jte.html.HtmlTemplateOutput jteOutput, gg.jte.html.HtmlInterceptor jteHtmlInterceptor, java.util.Map<String, Object> params) {
		Plugin plugin = (Plugin)params.get("plugin");
		Recipe recipe = (Recipe)params.get("recipe");
		render(jteOutput, jteHtmlInterceptor, plugin, recipe);
	}
}
