/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner.bootstrap.util;

public class OptionalClassLoader
extends ClassLoader {
    private final ClassLoader parent;
    private ClassLoader optional;

    public OptionalClassLoader(ClassLoader parent) {
        this.parent = parent;
    }

    public void set(ClassLoader optional) {
        this.optional = optional;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.parent.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            ClassNotFoundException parentException = ex;
            ClassLoader _opt = this.optional;
            if (_opt != null) {
                try {
                    return _opt.loadClass(name);
                }
                catch (ClassNotFoundException ex2) {
                    ex2.addSuppressed(parentException);
                    throw ex2;
                }
            }
            throw parentException;
        }
    }
}

