/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner.bootstrap.commands;

import io.jenkins.jenkinsfile.runner.bootstrap.commands.JenkinsfileCommand;
import io.jenkins.jenkinsfile.runner.bootstrap.commands.PipelineRunOptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Runs Jenkinsfile"}, mixinStandardHelpOptions=true)
public class RunJenkinsfileCommand
extends JenkinsfileCommand {
    @CommandLine.Mixin
    public PipelineRunOptions pipelineRunOptions;
    private static final String WORKSPACES_DIR_SYSTEM_PROPERTY = "jenkins.model.Jenkins.workspacesDir";

    @Override
    public String getAppClassName() {
        return "io.jenkins.jenkinsfile.runner.App";
    }

    public PipelineRunOptions getPipelineRunOptions() {
        return this.pipelineRunOptions;
    }

    @Override
    public void postConstruct() throws IOException {
        this.validateJenkinsfileInput(this.pipelineRunOptions);
        if (this.pipelineRunOptions.runWorkspace != null) {
            if (System.getProperty(WORKSPACES_DIR_SYSTEM_PROPERTY) != null) {
                System.out.println("Ignoring the --runWorkspace argument, because an explicit System property is set (-Djenkins.model.Jenkins.workspacesDir)");
            } else {
                System.setProperty(WORKSPACES_DIR_SYSTEM_PROPERTY, this.pipelineRunOptions.runWorkspace.getAbsolutePath());
            }
        }
        if (this.pipelineRunOptions.workflowParameters == null) {
            this.pipelineRunOptions.workflowParameters = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> workflowParameter : this.pipelineRunOptions.workflowParameters.entrySet()) {
            if (workflowParameter.getValue() != null) continue;
            workflowParameter.setValue("");
        }
        if (this.pipelineRunOptions.cause != null) {
            this.pipelineRunOptions.cause = this.pipelineRunOptions.cause.trim();
            if (this.pipelineRunOptions.cause.isEmpty()) {
                this.pipelineRunOptions.cause = null;
            }
        }
        if (this.pipelineRunOptions.jobName.isEmpty()) {
            this.pipelineRunOptions.jobName = "job";
        }
        if (this.pipelineRunOptions.keepUndefinedParameters) {
            System.setProperty("hudson.model.ParametersAction.keepUndefinedParameters", "true");
        }
        super.postConstruct();
    }
}

