/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner.bootstrap.commands;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.jenkinsfile.runner.bootstrap.ClassLoaderBuilder;
import io.jenkins.jenkinsfile.runner.bootstrap.IApp;
import io.jenkins.jenkinsfile.runner.bootstrap.SideClassLoader;
import io.jenkins.jenkinsfile.runner.bootstrap.Util;
import io.jenkins.jenkinsfile.runner.bootstrap.commands.JenkinsLauncherOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import picocli.CommandLine;

public abstract class JenkinsLauncherCommand
implements Callable<Integer> {
    public static final long CACHE_EXPIRE = System.currentTimeMillis() - 86400000L;
    private static final Collection<Integer> REDIRECT_STATUSES = Arrays.asList(301, 302, 303, 307, 308);
    @CommandLine.Mixin
    public JenkinsLauncherOptions launcherOptions;
    private File cache = new File(System.getProperty("user.home") + "/.jenkinsfile-runner/");

    public JenkinsLauncherOptions getLauncherOptions() {
        return this.launcherOptions;
    }

    @NonNull
    public abstract String getAppClassName();

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"})
    public Integer call() throws IllegalStateException {
        try {
            this.postConstruct();
            return this.runJenkinsfileRunnerApp();
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unhandled exception", ex);
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    public void postConstruct() throws IOException {
        String warPath;
        JenkinsLauncherOptions settings = this.getLauncherOptions();
        if (settings.version != null && settings.warDir != null) {
            System.err.print("Error: --jenkins-war and --jenkins-version are mutually exclusive options");
            System.exit(-1);
        }
        if (settings.version != null && !Util.isJenkinsVersionSupported(settings.version)) {
            System.err.printf("Jenkins version [%s] not supported by this jenkinsfile-runner version (requires %s). %n", settings.version, Util.getMininumJenkinsVersion());
            System.exit(-1);
        }
        if (settings.warDir == null) {
            settings.warDir = this.getJenkinsWar(settings.version);
        }
        if (FilenameUtils.getExtension((String)(warPath = settings.warDir.getAbsolutePath())).equals("war") && new File(warPath).isFile()) {
            System.out.println("Exploding " + warPath + ", this might take some time.");
            settings.warDir = Util.explodeWar(warPath);
        }
        if (settings.pluginsDir == null) {
            settings.pluginsDir = new File("plugins.txt");
        } else if (!settings.pluginsDir.exists()) {
            System.err.println("invalid plugins file.");
            System.exit(-1);
        }
        if (settings.pluginsDir.isFile()) {
            File plugins_txt = settings.pluginsDir;
            settings.pluginsDir = Files.createTempDirectory("plugins", new FileAttribute[0]).toFile();
            Iterator iterator = FileUtils.readLines((File)plugins_txt, (Charset)StandardCharsets.UTF_8).iterator();
            while (iterator.hasNext()) {
                String line;
                String shortname = line = (String)iterator.next();
                String version = "latest";
                int i = line.indexOf(58);
                if (i != -1) {
                    shortname = line.substring(0, i);
                    version = line.substring(i + 1);
                }
                this.installPlugin(settings.pluginsDir, shortname, version);
            }
        }
    }

    private void copyURLToFile(URL url, File file) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(true);
        int status = connection.getResponseCode();
        if (REDIRECT_STATUSES.contains(status)) {
            String newUrl = connection.getHeaderField("Location");
            System.out.println("Following redirect...");
            connection = (HttpURLConnection)new URL(newUrl).openConnection();
        }
        try (InputStream stream = connection.getInputStream();){
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
        }
    }

    private File getJenkinsWar(@CheckForNull String requiredVersion) throws IOException {
        String versionToUse;
        if (requiredVersion == null) {
            System.out.println("No explicit version has been selected, using latest LTS");
            File latestCore = new File(this.cache, "war/latest.txt");
            latestCore.getParentFile().mkdirs();
            if (!latestCore.exists() || latestCore.lastModified() < CACHE_EXPIRE) {
                this.copyURLToFile(URI.create("http://updates.jenkins.io/stable/latestCore.txt").toURL(), latestCore);
            }
            versionToUse = FileUtils.readFileToString((File)latestCore, (Charset)StandardCharsets.US_ASCII);
        } else {
            versionToUse = requiredVersion;
        }
        System.out.printf("Running pipeline on jenkins %s%n", versionToUse);
        File war = new File(this.cache, String.format("war/%s/jenkins-war-%s.war", versionToUse, versionToUse));
        if (!war.exists()) {
            war.getParentFile().mkdirs();
            URL url = new URL(this.getLauncherOptions().getMirrorURL(String.format("http://updates.jenkins.io/download/war/%s/jenkins.war", versionToUse)));
            System.out.printf("Downloading jenkins %s...%n", versionToUse);
            this.copyURLToFile(url, war);
        }
        return war;
    }

    private void installPlugin(File pluginsDir, String shortname, String version) throws IOException {
        File install = new File(pluginsDir, shortname + ".jpi");
        File plugin = new File(this.cache, String.format("plugins/%s/%s-%s.hpi", shortname, shortname, version));
        if (!plugin.exists() || "latest".equals(version) && plugin.lastModified() < CACHE_EXPIRE) {
            plugin.getParentFile().mkdirs();
            URL url = new URL(this.getLauncherOptions().getMirrorURL(String.format("https://updates.jenkins.io/download/plugins/%s/%s/%s.hpi", shortname, version, shortname)));
            System.out.printf("Downloading jenkins plugin %s (%s)...%n", shortname, version);
            FileUtils.copyURLToFile((URL)url, (File)plugin);
        }
        Files.createSymbolicLink(install.toPath(), plugin.toPath(), new FileAttribute[0]);
    }

    public ClassLoader createJenkinsWarClassLoader() throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> new ClassLoaderBuilder(new SideClassLoader(this.getPlatformClassloader())).collectJars(new File(this.getLauncherOptions().warDir, "WEB-INF/lib")).collectJars(new File(this.getLauncherOptions().warDir, "executable/winstone.jar")).collectJars(new File(this.getAppRepo(), "javax/servlet")).make());
    }

    public ClassLoader createSetupClassLoader(ClassLoader jenkins) throws IOException {
        return new ClassLoaderBuilder(jenkins).collectJars(this.getAppRepo()).collectJars(this.getSetupJarDir()).excludeJars(new File(this.getAppRepo(), "io/jenkins/jenkinsfile-runner/payload")).make();
    }

    public int runJenkinsfileRunnerApp() throws Throwable {
        String appClassName = this.getAppClassName();
        if (this.hasClass(appClassName)) {
            Class<?> c = Class.forName(appClassName);
            return ((IApp)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).run(this);
        }
        ClassLoader jenkins = this.createJenkinsWarClassLoader();
        ClassLoader setup = this.createSetupClassLoader(jenkins);
        Thread.currentThread().setContextClassLoader(setup);
        try {
            Class<?> c = setup.loadClass(appClassName);
            return ((IApp)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).run(this);
        }
        catch (ClassNotFoundException e) {
            if (setup instanceof URLClassLoader) {
                throw new ClassNotFoundException(e.getMessage() + " not found in " + this.getAppRepo() + "," + new File(this.getLauncherOptions().warDir, "WEB-INF/lib") + " " + Arrays.toString(((URLClassLoader)setup).getURLs()), e);
            }
            throw e;
        }
    }

    private ClassLoader getPlatformClassloader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (JenkinsLauncherCommand.isPostJava8()) {
            return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        return null;
    }

    private static boolean isPostJava8() {
        String javaVersion = System.getProperty("java.version");
        return !javaVersion.startsWith("1.");
    }

    public boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public File getAppRepo() {
        return new File(System.getProperty("app.repo"));
    }

    public File getLibDirectory() {
        if (this.launcherOptions.libPath != null) {
            return this.launcherOptions.libPath;
        }
        return new File(System.getProperty("app.repo"), "../lib");
    }

    public File getSetupJarDir() throws IOException {
        File setupJar = new File(this.getLibDirectory(), "setup/");
        if (!setupJar.exists()) {
            throw new IOException("Setup JAR is missing: " + setupJar);
        }
        return setupJar;
    }

    public File getPayloadJarDir() throws IOException {
        File payloadJar = new File(this.getLibDirectory(), "payload/");
        if (!payloadJar.exists()) {
            throw new IOException("Payload JAR is missing: " + payloadJar);
        }
        return payloadJar;
    }
}

