/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner.bootstrap;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.VersionNumber;
import io.jenkins.jenkinsfile.runner.bootstrap.Bootstrap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import picocli.CommandLine;

public class Util {
    @CheckForNull
    private static Properties JFR_PROPERTIES = null;

    public static String getJenkinsfileRunnerVersion() throws IOException {
        return Util.readJenkinsPomProperty("jfr.version");
    }

    public static String getMininumJenkinsVersion() throws IOException {
        return Util.readJenkinsPomProperty("minimum.jenkins.version");
    }

    public static boolean isJenkinsVersionSupported(String version) throws IOException {
        return new VersionNumber(version).isNewerThanOrEqualTo(new VersionNumber(Util.getMininumJenkinsVersion()));
    }

    public static String readJenkinsPomProperty(String key) throws IOException {
        if (JFR_PROPERTIES != null) {
            return JFR_PROPERTIES.getProperty(key);
        }
        try (InputStream pomProperties = Bootstrap.class.getResourceAsStream("/jfr.properties");){
            if (pomProperties == null) {
                throw new IOException("Cannot find the Jenkinsfile Runner version properties file: /jfr.properties");
            }
            Properties props = new Properties();
            props.load(pomProperties);
            JFR_PROPERTIES = props;
            String string = props.getProperty(key);
            return string;
        }
    }

    public static File explodeWar(String warPath) throws IOException {
        return Util.explodeWar(new File(warPath));
    }

    public static File explodeWar(File warFile) throws IOException {
        try (JarFile jarfile = new JarFile(warFile);){
            Enumeration<JarEntry> enu = jarfile.entries();
            Path currentPath = FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath();
            Path path = Files.createTempDirectory(currentPath.toAbsolutePath(), "jenkinsfile-runner", new FileAttribute[0]);
            File destDir = path.toFile();
            while (enu.hasMoreElements()) {
                JarEntry je = enu.nextElement();
                File file = new File(destDir, je.getName());
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file = new File(destDir, je.getName());
                }
                if (je.isDirectory()) continue;
                InputStream is = jarfile.getInputStream(je);
                try (FileOutputStream fo = new FileOutputStream(file);){
                    while (is.available() > 0) {
                        fo.write(is.read());
                    }
                    fo.close();
                    is.close();
                }
            }
            File file = destDir;
            return file;
        }
    }

    public static class VersionProviderImpl
    implements CommandLine.IVersionProvider {
        public String[] getVersion() throws Exception {
            return new String[]{Util.getJenkinsfileRunnerVersion()};
        }
    }
}

