/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.HashSet;

public class ClassLoaderBuilder {
    private final ClassLoader parent;
    private final HashSet<URL> jars = new HashSet(48);

    public ClassLoaderBuilder(ClassLoader parent) {
        this.parent = parent;
    }

    public ClassLoaderBuilder processJars(File dirOrFile, FileFilter filter, JarHandler handler) throws IOException {
        if (dirOrFile.isFile() && dirOrFile.getName().endsWith(".jar") && filter.accept(dirOrFile)) {
            handler.accept(dirOrFile);
            return this;
        }
        File[] children = dirOrFile.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    this.processJars(child, filter, handler);
                    continue;
                }
                if (!child.getName().endsWith(".jar") || !filter.accept(child)) continue;
                handler.accept(child);
            }
        }
        return this;
    }

    public ClassLoaderBuilder collectJars(File dir) throws IOException {
        return this.processJars(dir, File2 -> true, jar -> this.jars.add(jar.toURI().toURL()));
    }

    public ClassLoaderBuilder excludeJars(File dir) throws IOException {
        return this.processJars(dir, File2 -> true, jar -> this.jars.remove(jar.toURI().toURL()));
    }

    public ClassLoader make() {
        return AccessController.doPrivileged(() -> new URLClassLoader(this.jars.toArray(new URL[this.jars.size()]), this.parent));
    }

    public static interface JarHandler {
        public void accept(File var1) throws MalformedURLException;
    }
}

