/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.jenkinsfile.runner.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderBuilder {
    private final ClassLoader parent;
    private final List<URL> jars = new ArrayList<URL>();

    public ClassLoaderBuilder(ClassLoader parent) {
        this.parent = parent;
    }

    public ClassLoaderBuilder collectJars(File dir, FileFilter filter) throws IOException {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    this.collectJars(child, filter);
                    continue;
                }
                if (!child.getName().endsWith(".jar") || !filter.accept(child)) continue;
                this.jars.add(child.toURI().toURL());
            }
        }
        return this;
    }

    public ClassLoaderBuilder collectJars(File dir) throws IOException {
        return this.collectJars(dir, File2 -> true);
    }

    public ClassLoader make() {
        return new URLClassLoader(this.jars.toArray(new URL[this.jars.size()]), this.parent);
    }
}

