/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.credential;

import hudson.Extension;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.OmniSearch;
import io.jenkins.blueocean.rest.Query;
import io.jenkins.blueocean.rest.factory.OrganizationResolver;
import io.jenkins.blueocean.rest.impl.pipeline.credential.CredentialApi;
import io.jenkins.blueocean.rest.impl.pipeline.credential.CredentialContainer;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.pageable.Pageable;
import io.jenkins.blueocean.rest.pageable.Pageables;
import java.util.ArrayList;
import java.util.Iterator;

@Extension
public class CredentialSearch
extends OmniSearch<CredentialApi.Credential> {
    public String getType() {
        return "credential";
    }

    public Pageable<CredentialApi.Credential> search(Query q) {
        ArrayList<CredentialApi.Credential> credentials = new ArrayList<CredentialApi.Credential>();
        String domain = q.param("domain");
        String store = q.param("store");
        BlueOrganization organization = this.getOrganization(q);
        CredentialContainer credentialContainer = new CredentialContainer(organization.getLink());
        Iterator<CredentialApi> iterator = credentialContainer.iterator();
        while (iterator.hasNext()) {
            CredentialApi api = iterator.next();
            if (store != null && !store.equals(api.getStore())) continue;
            if (domain != null) {
                CredentialApi.CredentialDomain d = (CredentialApi.CredentialDomain)((Object)api.getDomains().get(domain));
                if (d == null) {
                    throw new ServiceException.BadRequestExpception("Credential domain " + domain + " not found");
                }
                Iterator<CredentialApi.Credential> iterator2 = d.getCredentials().iterator();
                while (iterator2.hasNext()) {
                    CredentialApi.Credential c = iterator2.next();
                    credentials.add(c);
                }
                continue;
            }
            for (CredentialApi.CredentialDomain d : api.getDomains()) {
                Iterator<CredentialApi.Credential> iterator3 = d.getCredentials().iterator();
                while (iterator3.hasNext()) {
                    CredentialApi.Credential c = iterator3.next();
                    credentials.add(c);
                }
            }
        }
        return Pageables.wrap(credentials);
    }

    private BlueOrganization getOrganization(Query q) {
        String org = q.param("organization");
        if (org == null) {
            throw new ServiceException.BadRequestExpception("Credentials search query parameter 'organization' is required");
        }
        BlueOrganization organization = OrganizationResolver.getInstance().get(org);
        if (organization == null) {
            throw new ServiceException.BadRequestExpception(String.format("Organization %s not found. Query parameter 'organization' value: %s is invalid. ", org, org));
        }
        return organization;
    }
}

