/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.credential;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.User;
import io.jenkins.blueocean.rest.OrganizationRoute;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.OrganizationResolver;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.credential.CredentialApi;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.Container;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.ExportedBean;

@Extension
@ExportedBean
public class CredentialContainer
extends Container<CredentialApi>
implements OrganizationRoute {
    private final Link self;

    public CredentialContainer() {
        BlueOrganization organization = OrganizationResolver.getInstance().getContainingOrg((ItemGroup)Jenkins.getInstance());
        this.self = organization != null ? organization.getLink().rel("credentials") : null;
    }

    public CredentialContainer(@Nonnull Link parent) {
        this.self = parent.rel("credentials");
    }

    public String getUrlName() {
        return "credentials";
    }

    public Link getLink() {
        return this.self;
    }

    public CredentialApi get(String name) {
        Iterator<CredentialApi> iterator = this.iterator();
        while (iterator.hasNext()) {
            CredentialApi api = iterator.next();
            if (!api.getStore().equals(name)) continue;
            return api;
        }
        return null;
    }

    public Iterator<CredentialApi> iterator() {
        ArrayList<CredentialApi> apis = new ArrayList<CredentialApi>();
        User user = User.current();
        if (user != null) {
            for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)user)) {
                if (store.getStoreAction() == null) continue;
                apis.add(new CredentialApi(store.getStoreAction(), (Reachable)this));
            }
        } else {
            for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance())) {
                if (store.getStoreAction() == null) continue;
                apis.add(new CredentialApi(store.getStoreAction(), (Reachable)this));
            }
        }
        return apis.iterator();
    }
}

