/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.base.Predicate;
import hudson.model.Action;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeLogResource;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepContainerImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueInputStep;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;

public class PipelineNodeImpl
extends BluePipelineNode {
    private final FlowNodeWrapper node;
    private final List<BluePipelineNode.Edge> edges;
    private final Long durationInMillis;
    private final NodeRunStatus status;
    private final Link self;
    private final WorkflowRun run;

    public PipelineNodeImpl(FlowNodeWrapper node, Link parentLink, WorkflowRun run) {
        this.node = node;
        this.run = run;
        this.edges = this.buildEdges(node.edges);
        this.status = node.getStatus();
        this.durationInMillis = node.getTiming().getTotalDurationMillis();
        this.self = parentLink.rel(node.getId());
    }

    public String getId() {
        return this.node.getId();
    }

    public String getDisplayName() {
        return PipelineNodeUtil.getDisplayName(this.node.getNode());
    }

    public BlueRun.BlueRunResult getResult() {
        return this.status.getResult();
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.status.getState();
    }

    public Date getStartTime() {
        long nodeTime = this.node.getTiming().getStartTimeMillis();
        if (nodeTime == 0L) {
            return null;
        }
        return new Date(nodeTime);
    }

    public List<BluePipelineNode.Edge> getEdges() {
        return this.edges;
    }

    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public Object getLog() {
        return new NodeLogResource(this);
    }

    public String getCauseOfBlockage() {
        return this.node.getCauseOfFailure();
    }

    public BluePipelineStepContainer getSteps() {
        return new PipelineStepContainerImpl(this.node, this.self, this.run);
    }

    public Link getLink() {
        return this.self;
    }

    public Collection<BlueActionProxy> getActions() {
        return ActionProxiesImpl.getActionProxies((List)this.node.getNode().getActions(), (Predicate)new Predicate<Action>(){

            public boolean apply(@Nullable Action input) {
                return input instanceof LogAction;
            }
        }, (Reachable)this);
    }

    public BlueInputStep getInputStep() {
        return null;
    }

    public HttpResponse submitInputStep(StaplerRequest request) {
        return null;
    }

    private List<BluePipelineNode.Edge> buildEdges(List<String> nodes) {
        ArrayList<BluePipelineNode.Edge> edges = new ArrayList<BluePipelineNode.Edge>();
        if (!nodes.isEmpty()) {
            for (String id : nodes) {
                edges.add(new EdgeImpl(id));
            }
        }
        return edges;
    }

    FlowNodeWrapper getFlowNodeWrapper() {
        return this.node;
    }

    public static class EdgeImpl
    extends BluePipelineNode.Edge {
        private final String id;

        public EdgeImpl(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

