/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.Utils;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BlueFavoriteResolver;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.OrganizationResolver;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.impl.pipeline.BranchContainerImpl;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import io.jenkins.blueocean.rest.impl.pipeline.MultiBranchPipelineQueueContainer;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineJobFilters;
import io.jenkins.blueocean.rest.impl.pipeline.PrimaryBranch;
import io.jenkins.blueocean.rest.impl.pipeline.ScmResourceImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueIcon;
import io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.FavoriteImpl;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jenkins.branch.MultiBranchProject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.json.JsonBody;

@Capability(value={"jenkins.branch.MultiBranchProject"})
public class MultiBranchPipelineImpl
extends BlueMultiBranchPipeline {
    final MultiBranchProject mbp;
    private static final int MAX_MBP_RUNS_ROWS = Integer.getInteger("MAX_MBP_RUNS_ROWS", 250);
    private final Link self;
    private final BlueOrganization org;

    public MultiBranchPipelineImpl(MultiBranchProject mbp) {
        this.mbp = mbp;
        this.org = OrganizationResolver.getInstance().getContainingOrg((ItemGroup)mbp);
        this.self = this.org.getLink().rel("pipelines").rel(PipelineImpl.getRecursivePathFromFullName((BluePipeline)this));
    }

    public String getOrganization() {
        return this.org.getName();
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        if (favoriteAction == null) {
            throw new ServiceException.BadRequestExpception("Must provide pipeline name");
        }
        Job job = PrimaryBranch.resolve((AbstractFolder)this.mbp);
        if (job == null) {
            throw new ServiceException.BadRequestExpception("no default branch to favorite");
        }
        FavoriteUtil.toggle((BlueFavoriteAction)favoriteAction, (Item)job);
        return new FavoriteImpl((Object)new BranchImpl(job, this.getLink().rel("branches")), this.getLink().rel("favorite"));
    }

    public Map<String, Boolean> getPermissions() {
        return AbstractPipelineImpl.getPermissions((AbstractItem)this.mbp);
    }

    @Navigable
    public BluePipelineScm getScm() {
        return new ScmResourceImpl((Item)this.mbp, (Reachable)this);
    }

    public String getName() {
        return this.mbp.getName();
    }

    public String getDisplayName() {
        return this.mbp.getDisplayName();
    }

    public String getFullName() {
        return this.mbp.getFullName();
    }

    public String getFullDisplayName() {
        return AbstractPipelineImpl.getFullDisplayName((ItemGroup)this.mbp, null);
    }

    public int getTotalNumberOfBranches() {
        return this.countJobs(false);
    }

    public int getNumberOfFailingBranches() {
        return this.countRunStatus(Result.FAILURE, false);
    }

    public int getNumberOfSuccessfulBranches() {
        return this.countRunStatus(Result.SUCCESS, false);
    }

    public int getTotalNumberOfPullRequests() {
        return this.countJobs(true);
    }

    public int getNumberOfFailingPullRequests() {
        return this.countRunStatus(Result.FAILURE, true);
    }

    public int getNumberOfSuccessfulPullRequests() {
        return this.countRunStatus(Result.SUCCESS, true);
    }

    public BluePipelineContainer getPipelines() {
        return new BranchContainerImpl(this, this.getLink().rel("pipelines"));
    }

    public Integer getNumberOfFolders() {
        return 0;
    }

    public Integer getNumberOfPipelines() {
        return this.getTotalNumberOfBranches();
    }

    public Integer getWeatherScore() {
        Job j = PrimaryBranch.resolve((AbstractFolder)this.mbp);
        return j == null ? 100 : j.getBuildHealth().getScore();
    }

    public BlueRun getLatestRun() {
        return null;
    }

    public Long getEstimatedDurationInMillis() {
        return this.mbp.getEstimatedDuration();
    }

    @Navigable
    public BluePipelineContainer getBranches() {
        return new BranchContainerImpl(this, this.getLink().rel("branches"));
    }

    public Collection<String> getBranchNames() {
        return Collections2.transform((Collection)ImmutableList.copyOf((Iterator)this.getBranches().iterator()), (Function)new Function<BluePipeline, String>(){

            public String apply(BluePipeline input) {
                return input.getName();
            }
        });
    }

    private int countRunStatus(Result result, boolean pullRequests) {
        Collection jobs = this.mbp.getAllJobs();
        int count = 0;
        for (Job j : jobs) {
            if ((!pullRequests || !PipelineJobFilters.isPullRequest((Item)j)) && (pullRequests || PipelineJobFilters.isPullRequest((Item)j))) continue;
            j.getBuildStatusUrl();
            Run run = j.getLastBuild();
            if (run == null || run.getResult() != result) continue;
            ++count;
        }
        return count;
    }

    private int countJobs(boolean pullRequests) {
        Collection jobs = this.mbp.getAllJobs();
        int counter = 0;
        for (Job job : jobs) {
            if ((!pullRequests || !PipelineJobFilters.isPullRequest((Item)job)) && (pullRequests || PipelineJobFilters.isPullRequest((Item)job))) continue;
            ++counter;
        }
        return counter;
    }

    public BlueRunContainer getRuns() {
        return new BlueRunContainer(){

            public Link getLink() {
                return MultiBranchPipelineImpl.this.getLink().rel("runs");
            }

            public BlueRun get(String name) {
                return null;
            }

            public Iterator<BlueRun> iterator() {
                throw new ServiceException.NotImplementedException("Not implemented");
            }

            public Iterator<BlueRun> iterator(int start, int limit) {
                List<Object> branches;
                ArrayList c = new ArrayList();
                StaplerRequest req = Stapler.getCurrentRequest();
                String branchFilter = null;
                if (req != null) {
                    branchFilter = req.getParameter("branch");
                }
                if (!StringUtils.isEmpty(branchFilter)) {
                    BluePipeline pipeline = (BluePipeline)MultiBranchPipelineImpl.this.getBranches().get(branchFilter);
                    branches = pipeline != null ? Collections.singletonList(pipeline) : Collections.emptyList();
                } else {
                    branches = Lists.newArrayList((Iterable)MultiBranchPipelineImpl.this.getBranches().list());
                    MultiBranchPipelineImpl.sortBranchesByLatestRun(branches);
                }
                for (BluePipeline b : branches) {
                    Iterator it = b.getRuns().iterator(0, MAX_MBP_RUNS_ROWS);
                    int count = 0;
                    Utils.skip((Iterator)it, (int)start);
                    while (it.hasNext() && count++ < limit) {
                        c.add(it.next());
                    }
                }
                Collections.sort(c, new Comparator<BlueRun>(){

                    @Override
                    public int compare(BlueRun o1, BlueRun o2) {
                        return o2.getStartTime().compareTo(o1.getStartTime());
                    }
                });
                return c.iterator();
            }

            private boolean retry(boolean[] retries) {
                for (boolean r : retries) {
                    if (!r) continue;
                    return true;
                }
                return false;
            }

            private int computeLimit(boolean[] retries, int limit) {
                int count = 0;
                for (boolean r : retries) {
                    if (!r) continue;
                    ++count;
                }
                if (count == 0) {
                    return 0;
                }
                return limit / count > 0 ? limit / count : 1;
            }

            private int collectRuns(List<BluePipeline> branches, List<BlueRun> runs, boolean[] retries, int remainingCount, int[] startIndexes, int[] limits) {
                int count = 0;
                for (int i = 0; i < branches.size(); ++i) {
                    BluePipeline b = branches.get(i);
                    if (!retries[i]) continue;
                    Iterator it = b.getRuns().iterator(startIndexes[i], limits[i]);
                    int lcount = 0;
                    while (it.hasNext() && count < remainingCount) {
                        ++lcount;
                        ++count;
                        runs.add((BlueRun)it.next());
                    }
                    if (lcount < limits[i]) {
                        retries[i] = false;
                        continue;
                    }
                    startIndexes[i] = startIndexes[i] + lcount;
                }
                return count;
            }

            public BlueRun create(StaplerRequest request) {
                throw new ServiceException.NotImplementedException("This action is not supported");
            }
        };
    }

    static void sortBranchesByLatestRun(List<BluePipeline> branches) {
        Collections.sort(branches, new Comparator<BluePipeline>(){

            @Override
            public int compare(BluePipeline o1, BluePipeline o2) {
                Long t1 = o1.getLatestRun() != null ? o1.getLatestRun().getStartTime().getTime() : 0L;
                Long t2 = o2.getLatestRun() != null ? o2.getLatestRun().getStartTime().getTime() : 0L;
                return t2.compareTo(t1);
            }
        });
    }

    public Collection<BlueActionProxy> getActions() {
        return ActionProxiesImpl.getActionProxies((List)this.mbp.getAllActions(), (Reachable)this);
    }

    public BlueQueueContainer getQueue() {
        return new MultiBranchPipelineQueueContainer(this);
    }

    public Link getLink() {
        return this.self;
    }

    public List<Object> getParameters() {
        return null;
    }

    public BlueIcon getIcon() {
        return null;
    }

    @Extension(ordinal=1.0)
    public static class FavoriteResolverImpl
    extends BlueFavoriteResolver {
        public BlueFavorite resolve(Item item, Reachable parent) {
            MultiBranchProject project;
            Job job;
            if (item instanceof MultiBranchProject && (job = PrimaryBranch.resolve((AbstractFolder)(project = (MultiBranchProject)item))) != null) {
                Resource resource = BluePipelineFactory.resolve((Item)job);
                Link l = LinkResolver.resolveLink((Object)project);
                if (l != null) {
                    return new FavoriteImpl((Object)resource, l.rel("favorite"));
                }
            }
            return null;
        }
    }

    @Extension(ordinal=2.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public MultiBranchPipelineImpl getPipeline(Item item, Reachable parent) {
            if (item instanceof MultiBranchProject) {
                return new MultiBranchPipelineImpl((MultiBranchProject)item);
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target) {
            if (context instanceof MultiBranchProject) {
                if (context == target) {
                    return this.getPipeline(context, parent);
                }
                if (context == target.getParent()) {
                    return (Resource)this.getPipeline(context, parent).getBranches().get(target.getName());
                }
            }
            return null;
        }
    }
}

