/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.blueocean.TryBlueOceanURLs;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.OrganizationResolver;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import io.jenkins.blueocean.rest.model.BlueMultiBranchPipeline;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Restricted(value={NoExternalUse.class})
public class BlueOceanWebURLBuilder {
    private BlueOceanWebURLBuilder() {
    }

    @Nonnull
    public static TryBlueOceanURLs getTryBlueOceanURLs() {
        StaplerRequest staplerRequest = Stapler.getCurrentRequest();
        List list = staplerRequest.getAncestors();
        for (int i = list.size() - 1; i >= 0; --i) {
            Ancestor ancestor = (Ancestor)list.get(i);
            Object object = ancestor.getObject();
            if (!(object instanceof ModelObject)) continue;
            String blueUrl = BlueOceanWebURLBuilder.toBlueOceanURL((ModelObject)object);
            if (blueUrl != null) {
                if (object instanceof Item) {
                    return new TryBlueOceanURLs(blueUrl, ((Item)object).getUrl());
                }
                if (object instanceof Run) {
                    return new TryBlueOceanURLs(blueUrl, ((Run)object).getUrl());
                }
                return new TryBlueOceanURLs(blueUrl);
            }
            if (!(object instanceof Item)) continue;
            return new TryBlueOceanURLs(BlueOceanWebURLBuilder.getBlueHome(), ((Item)object).getUrl());
        }
        return new TryBlueOceanURLs(BlueOceanWebURLBuilder.getBlueHome());
    }

    @CheckForNull
    public static String toBlueOceanURL(@Nonnull ModelObject classicModelObject) {
        Item item;
        Resource blueResource;
        if (classicModelObject instanceof Job) {
            BlueOceanModelMapping pipelineModelMapping = BlueOceanWebURLBuilder.getPipelineModelMapping((Job)classicModelObject);
            if (pipelineModelMapping.blueModelObject instanceof BlueMultiBranchPipeline) {
                return pipelineModelMapping.blueUiUrl + "/branches";
            }
            return pipelineModelMapping.blueUiUrl;
        }
        if (classicModelObject instanceof Run) {
            Run run = (Run)classicModelObject;
            Job job = run.getParent();
            BlueOceanModelMapping pipelineModelMapping = BlueOceanWebURLBuilder.getPipelineModelMapping(job);
            return pipelineModelMapping.blueUiUrl + "/detail/" + BlueOceanWebURLBuilder.encodeURIComponent(BlueOceanWebURLBuilder.decodeURIComponent(job.getName())) + "/" + BlueOceanWebURLBuilder.encodeURIComponent(run.getId());
        }
        if (classicModelObject instanceof Item && (blueResource = BluePipelineFactory.resolve((Item)(item = (Item)classicModelObject))) instanceof BlueMultiBranchPipeline) {
            return BlueOceanWebURLBuilder.getOrgPrefix(item) + "/" + BlueOceanWebURLBuilder.encodeURIComponent(((BluePipeline)blueResource).getFullName()) + "/branches";
        }
        return null;
    }

    private static String getOrgPrefix(Item i) {
        return BlueOceanWebURLBuilder.getBlueHome() + "/organizations/" + OrganizationResolver.getInstance().getContainingOrg(i).getName();
    }

    private static String getOrgPrefix(ItemGroup i) {
        return BlueOceanWebURLBuilder.getBlueHome() + "/organizations/" + OrganizationResolver.getInstance().getContainingOrg(i).getName();
    }

    private static String getBlueHome() {
        return "blue";
    }

    private static BlueOceanModelMapping getPipelineModelMapping(Job job) {
        BluePipeline blueResource = (BluePipeline)BluePipelineFactory.resolve((Item)job);
        if (blueResource instanceof BranchImpl) {
            ItemGroup multibranchJob = job.getParent();
            BluePipeline multibranchJobResource = (BluePipeline)BluePipelineFactory.resolve((Item)((Item)multibranchJob));
            return new BlueOceanModelMapping(multibranchJob, (Resource)multibranchJobResource, BlueOceanWebURLBuilder.getOrgPrefix(multibranchJob) + "/" + BlueOceanWebURLBuilder.encodeURIComponent(multibranchJobResource.getFullName()));
        }
        return new BlueOceanModelMapping(job, (Resource)blueResource, BlueOceanWebURLBuilder.getOrgPrefix((Item)job) + "/" + BlueOceanWebURLBuilder.encodeURIComponent(blueResource.getFullName()));
    }

    static String decodeURIComponent(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected UTF-8 encoding error.", e);
        }
    }

    static String encodeURIComponent(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected UTF-8 encoding error.", e);
        }
    }

    private static class BlueOceanModelMapping {
        private Object classJenkinsModelObject;
        private Resource blueModelObject;
        private String blueUiUrl;

        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="Reference to Jenkins job, probably kept for future use")
        public BlueOceanModelMapping(Object classJenkinsModelObject, Resource blueModelObject, String blueUiUrl) {
            this.classJenkinsModelObject = classJenkinsModelObject;
            this.blueModelObject = blueModelObject;
            this.blueUiUrl = blueUiUrl;
        }
    }
}

