/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import hudson.EnvVars;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.security.ACL;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.acegisecurity.Authentication;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.trilead.SmartCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GitUtils {
    private static final Logger logger = LoggerFactory.getLogger(GitUtils.class);
    private static final Pattern SSH_URL_PATTERN = Pattern.compile("(\\Qssh://\\E.*|[^@:]+@.*)");

    GitUtils() {
    }

    static List<ErrorMessage.Error> validateCredentials(@Nonnull String uri, @Nullable StandardCredentials credentials) throws GitException {
        ArrayList<ErrorMessage.Error> errors = new ArrayList<ErrorMessage.Error>();
        org.jenkinsci.plugins.gitclient.Git git = new org.jenkinsci.plugins.gitclient.Git(TaskListener.NULL, new EnvVars());
        try {
            GitClient gitClient = git.getClient();
            if (credentials != null) {
                gitClient.addCredentials(uri, credentials);
            }
            gitClient.getRemoteReferences(uri, null, true, false);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error running git remote-ls: " + e.getMessage(), (Throwable)e);
            throw new ServiceException.UnexpectedErrorException("Failed to create pipeline due to unexpected error: " + e.getMessage(), (Throwable)e);
        }
        catch (GitException | IllegalStateException e) {
            logger.error("Error running git remote-ls: " + e.getMessage(), e);
            if (credentials != null) {
                if (e instanceof IllegalStateException || e.getMessage().endsWith("not authorized")) {
                    errors.add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.INVALID.toString(), "Invalid credentialId: " + credentials.getId()));
                } else {
                    errors.add(new ErrorMessage.Error("scmConfig.uri", ErrorMessage.Error.ErrorCodes.INVALID.toString(), e.getMessage()));
                }
            }
            if (e.getMessage().contains("Authentication is required") || e.getMessage().contains("connection is not authenticated")) {
                errors.add(new ErrorMessage.Error("scmConfig.credentialId", ErrorMessage.Error.ErrorCodes.INVALID.toString(), e.getMessage()));
            }
            errors.add(new ErrorMessage.Error("scmConfig.uri", ErrorMessage.Error.ErrorCodes.INVALID.toString(), e.getMessage()));
        }
        return errors;
    }

    public static void validatePushAccess(@Nonnull Repository repo, @Nonnull String remoteUrl, @Nullable StandardCredentials credential) throws GitException {
        try (Git git = new Git(repo);){
            String pushSpec = ":this-branch-is-only-to-test-if-jenkins-has-push-access";
            PushCommand pushCommand = git.push();
            GitUtils.addCredential(repo, (TransportCommand)pushCommand, credential);
            Iterable resultIterable = pushCommand.setRefSpecs(new RefSpec[]{new RefSpec(pushSpec)}).setRemote(remoteUrl).setDryRun(true).call();
            PushResult result = (PushResult)resultIterable.iterator().next();
            if (result.getRemoteUpdates().isEmpty()) {
                System.out.println("No remote updates occurred");
            } else {
                for (RemoteRefUpdate update : result.getRemoteUpdates()) {
                    if (RemoteRefUpdate.Status.NON_EXISTING.equals((Object)update.getStatus()) || RemoteRefUpdate.Status.OK.equals((Object)update.getStatus())) continue;
                    throw new ServiceException.UnexpectedErrorException("Expected non-existent ref but got: " + update.getStatus().name() + ": " + update.getMessage());
                }
            }
        }
        catch (GitAPIException e) {
            if (e.getMessage().toLowerCase().contains("auth")) {
                throw new ServiceException.UnauthorizedException(e.getMessage(), (Throwable)e);
            }
            throw new ServiceException.UnexpectedErrorException("Unable to access and push to: " + remoteUrl + " - " + e.getMessage(), (Throwable)e);
        }
    }

    static boolean isSshUrl(@Nullable String remote) {
        return remote != null && SSH_URL_PATTERN.matcher(remote).matches();
    }

    static boolean isLocalUnixFileUrl(@Nullable String remote) {
        return remote != null && remote.startsWith("/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSshUrl(Repository repo) {
        try (Git git = new Git(repo);){
            boolean bl = GitUtils.isSshUrl(((URIish)((RemoteConfig)git.remoteList().call().get(0)).getURIs().get(0)).toString());
            return bl;
        }
        catch (IndexOutOfBoundsException | GitAPIException e) {
            return false;
        }
    }

    static StandardCredentials getCredentials(ItemGroup owner, String uri, String credentialId) {
        StandardCredentials standardCredentials = (StandardCredentials)CredentialsUtils.findCredential((String)credentialId, StandardCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        if (standardCredentials == null) {
            standardCredentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)owner, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)uri).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialId), GitClient.CREDENTIALS_MATCHER}));
        }
        return standardCredentials;
    }

    private static TransportConfigCallback getSSHKeyTransport(final BasicSSHUserPrivateKey privateKey) {
        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host hc, Session session) {
                session.setConfig("StrictHostKeyChecking", "no");
            }

            protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
                JSch jsch = new JSch();
                this.configureJSch(jsch);
                try {
                    KeyPair pair = KeyPair.load((JSch)jsch, (byte[])privateKey.getPrivateKey().getBytes("utf-8"), null);
                    byte[] passphrase = new byte[]{};
                    jsch.addIdentity(privateKey.getUsername(), pair.forSSHAgent(), null, passphrase);
                    return jsch;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return new TransportConfigCallback((SshSessionFactory)sshSessionFactory){
            final /* synthetic */ SshSessionFactory val$sshSessionFactory;
            {
                this.val$sshSessionFactory = sshSessionFactory;
            }

            public void configure(Transport transport) {
                if (transport instanceof SshTransport) {
                    SshTransport sshTransport = (SshTransport)transport;
                    sshTransport.setSshSessionFactory(this.val$sshSessionFactory);
                }
            }
        };
    }

    public static void fetch(Repository repo, StandardCredentials credential) {
        try (Git git = new Git(repo);){
            FetchCommand fetchCommand = git.fetch();
            GitUtils.addCredential(repo, (TransportCommand)fetchCommand, credential);
            fetchCommand.setRemote("origin").setRemoveDeletedRefs(true).setRefSpecs(new RefSpec[]{new RefSpec("+refs/heads/*:refs/remotes/origin/*")}).call();
        }
        catch (GitAPIException ex) {
            if (ex.getMessage().contains("Auth fail")) {
                throw new ServiceException.UnauthorizedException("Not authorized", (Throwable)ex);
            }
            throw new RuntimeException(ex);
        }
    }

    private static void addCredential(Repository repo, TransportCommand command, StandardCredentials credential) {
        if (GitUtils.isSshUrl(repo) && credential instanceof BasicSSHUserPrivateKey) {
            command.setTransportConfigCallback(GitUtils.getSSHKeyTransport((BasicSSHUserPrivateKey)credential));
        } else if (credential != null) {
            SmartCredentialsProvider credentialsProvider = new SmartCredentialsProvider(null);
            credentialsProvider.addDefaultCredentials(credential);
            command.setCredentialsProvider((org.eclipse.jgit.transport.CredentialsProvider)credentialsProvider);
        }
    }

    public static void merge(Repository repo, String localRef, String remoteRef) {
        try (Git git = new Git(repo);){
            CheckoutCommand checkoutCommand = git.checkout();
            checkoutCommand.setCreateBranch(false);
            checkoutCommand.setName(localRef);
            checkoutCommand.call();
            Ref mergeBranchRef = repo.exactRef(remoteRef);
            MergeResult merge = git.merge().include(mergeBranchRef).setFastForward(MergeCommand.FastForwardMode.FF_ONLY).call();
            if (merge.getConflicts() != null) {
                throw new RuntimeException("Merge has conflicts");
            }
        }
        catch (Exception e) {
            throw new ServiceException.UnexpectedErrorException("Unable to merge: " + remoteRef + " to: " + localRef, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void commit(Repository repo, String refName, String path, byte[] contents, String name, String email, String message, TimeZone timeZone, Date when) {
        PersonIdent author = GitUtils.buildPersonIdent(repo, name, email, timeZone, when);
        try (ObjectInserter odi = repo.newObjectInserter();){
            ObjectId headId = repo.resolve(refName + "^{commit}");
            DirCache index = GitUtils.createTemporaryIndex(repo, headId, path, contents);
            ObjectId indexTreeId = index.writeTree(odi);
            CommitBuilder commit = new CommitBuilder();
            commit.setAuthor(author);
            commit.setCommitter(author);
            commit.setEncoding("UTF-8");
            commit.setMessage(message);
            if (headId != null) {
                commit.setParentId((AnyObjectId)headId);
            }
            commit.setTreeId((AnyObjectId)indexTreeId);
            ObjectId commitId = odi.insert(commit);
            odi.flush();
            try (RevWalk revWalk = new RevWalk(repo);){
                RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
                RefUpdate ru = repo.updateRef(refName);
                if (headId == null) {
                    ru.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
                } else {
                    ru.setExpectedOldObjectId((AnyObjectId)headId);
                }
                ru.setNewObjectId((AnyObjectId)commitId);
                ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                RefUpdate.Result rc = ru.forceUpdate();
                switch (rc) {
                    case NEW: 
                    case FORCED: 
                    case FAST_FORWARD: {
                        return;
                    }
                    case REJECTED: 
                    case LOCK_FAILURE: {
                        throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                    }
                    default: {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", commitId.toString(), rc));
                    }
                }
            }
        }
        catch (IOException | ConcurrentRefUpdateException | JGitInternalException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static PersonIdent buildPersonIdent(Repository repo, String name, String email, TimeZone timeZone, Date when) {
        TimeZone tz;
        TimeZone timeZone2 = tz = timeZone == null ? TimeZone.getDefault() : timeZone;
        if (name != null) {
            if (when != null) {
                return new PersonIdent(name, email, when, tz);
            }
            return new PersonIdent(name, email);
        }
        return new PersonIdent(repo);
    }

    private static DirCache createTemporaryIndex(Repository repo, ObjectId headId, String path, byte[] contents) {
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder dcBuilder = inCoreIndex.builder();
        try (ObjectInserter inserter = repo.newObjectInserter();){
            long lastModified = System.currentTimeMillis();
            try {
                if (contents != null) {
                    DirCacheEntry dcEntry = new DirCacheEntry(path);
                    dcEntry.setLength(contents.length);
                    dcEntry.setLastModified(lastModified);
                    dcEntry.setFileMode(FileMode.REGULAR_FILE);
                    try (ByteArrayInputStream inputStream = new ByteArrayInputStream(contents);){
                        dcEntry.setObjectId((AnyObjectId)inserter.insert(3, (long)contents.length, (InputStream)inputStream));
                    }
                    dcBuilder.add(dcEntry);
                }
                if (headId != null) {
                    TreeWalk treeWalk = new TreeWalk(repo);
                    int hIdx = treeWalk.addTree((AnyObjectId)new RevWalk(repo).parseTree((AnyObjectId)headId));
                    treeWalk.setRecursive(true);
                    while (treeWalk.next()) {
                        String walkPath = treeWalk.getPathString();
                        CanonicalTreeParser hTree = (CanonicalTreeParser)treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                        if (walkPath.equals(path)) continue;
                        DirCacheEntry dcEntry = new DirCacheEntry(walkPath);
                        dcEntry.setObjectId((AnyObjectId)hTree.getEntryObjectId());
                        dcEntry.setFileMode(hTree.getEntryFileMode());
                        dcBuilder.add(dcEntry);
                    }
                }
                dcBuilder.finish();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (contents == null) {
            DirCacheEditor editor = inCoreIndex.editor();
            editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(path));
            editor.finish();
        }
        return inCoreIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] readFile(Repository repository, String ref, String filePath) {
        try (ObjectReader reader = repository.newObjectReader();){
            ObjectId branchRef = repository.resolve(ref);
            if (branchRef == null) return null;
            RevWalk revWalk = new RevWalk(repository);
            RevCommit commit = revWalk.parseCommit((AnyObjectId)branchRef);
            RevTree tree = commit.getTree();
            TreeWalk treewalk = TreeWalk.forPath((ObjectReader)reader, (String)filePath, (AnyObjectId[])new AnyObjectId[]{tree});
            if (treewalk == null) return null;
            byte[] byArray = reader.open((AnyObjectId)treewalk.getObjectId(0)).getBytes();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void push(String remoteUrl, Repository repo, StandardCredentials credential, String localBranchRef, String remoteBranchRef) {
        try (Git git = new Git(repo);){
            String pushSpec = "+" + localBranchRef + ":" + remoteBranchRef;
            PushCommand pushCommand = git.push();
            GitUtils.addCredential(repo, (TransportCommand)pushCommand, credential);
            Iterable resultIterable = pushCommand.setRefSpecs(new RefSpec[]{new RefSpec(pushSpec)}).setRemote(remoteUrl).call();
            PushResult result = (PushResult)resultIterable.iterator().next();
            if (result.getRemoteUpdates().isEmpty()) {
                throw new RuntimeException("No remote updates occurred");
            }
            for (RemoteRefUpdate update : result.getRemoteUpdates()) {
                if (RemoteRefUpdate.Status.OK.equals((Object)update.getStatus())) continue;
                throw new ServiceException.UnexpectedErrorException("Remote update failed: " + update.getStatus().name() + ": " + update.getMessage());
            }
        }
        catch (GitAPIException e) {
            if (e.getMessage().toLowerCase().contains("auth")) {
                throw new ServiceException.UnauthorizedException(e.getMessage(), (Throwable)e);
            }
            throw new ServiceException.UnexpectedErrorException("Unable to save and push to: " + remoteUrl + " - " + e.getMessage(), (Throwable)e);
        }
    }
}

