/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.User;
import hudson.util.HttpResponses;
import io.jenkins.blueocean.blueocean_git_pipeline.GitBareRepoReadSaveRequest;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainSpecification;
import io.jenkins.blueocean.rest.impl.pipeline.scm.AbstractScm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFactory;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmOrganization;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpointContainer;
import io.jenkins.blueocean.rest.model.Container;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.scm.api.SCMSourceOwner;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.json.JsonBody;

public class GitScm
extends AbstractScm {
    public static final String ID = "git";
    static final String CREDENTIAL_DOMAIN_NAME = "blueocean-git-domain";
    static final String CREDENTIAL_DESCRIPTION_PW = "Git username/password";
    protected final Reachable parent;

    public GitScm(Reachable parent) {
        this.parent = parent;
    }

    public static String makeCredentialId(String repositoryUrl) {
        String normalizedUrl = GitScm.normalizeServerUrl(repositoryUrl);
        try {
            URI uri = new URI(normalizedUrl);
            String host = uri.getHost();
            if (host == null || host.length() == 0) {
                return null;
            }
            String scheme = uri.getScheme();
            if (scheme != null && scheme.startsWith("http")) {
                return String.format("%s:%s", ID, DigestUtils.sha256Hex((String)normalizedUrl));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static String normalizeServerUrl(String repositoryUrl) {
        if (repositoryUrl == null) {
            return "";
        }
        try {
            URI uri = new URI(repositoryUrl).normalize();
            String scheme = uri.getScheme();
            String host = uri.getHost() == null ? null : uri.getHost().toLowerCase(Locale.ENGLISH);
            int port = uri.getPort();
            if ("http".equals(scheme) && port == 80) {
                port = -1;
            } else if ("https".equals(scheme) && port == 443) {
                port = -1;
            } else if ("ssh".equals(scheme) && port == 22) {
                port = -1;
            } else if (ID.equals(scheme) && port == 9418) {
                port = -1;
            }
            return new URI(scheme, uri.getUserInfo(), host, port, null, null, null).toASCIIString().replaceAll("/$", "");
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    public Link getLink() {
        return this.parent.getLink().rel(ID);
    }

    @Nonnull
    public String getId() {
        return ID;
    }

    @Nonnull
    public String getUri() {
        return "";
    }

    protected StaplerRequest getStaplerRequest() {
        StaplerRequest request = Stapler.getCurrentRequest();
        Preconditions.checkNotNull((Object)request, (Object)"Must be called in HTTP request context");
        return request;
    }

    public String getCredentialId() {
        StandardCredentials credential = this.getCredentialForCurrentRequest();
        if (credential != null) {
            return credential.getId();
        }
        return null;
    }

    protected StandardCredentials getCredentialForCurrentRequest() {
        StaplerRequest request = this.getStaplerRequest();
        String credentialId = null;
        if (request.hasParameter("credentialId")) {
            credentialId = request.getParameter("credentialId");
        } else {
            if (!request.hasParameter("repositoryUrl")) {
                return null;
            }
            String repositoryUrl = request.getParameter("repositoryUrl");
            credentialId = GitScm.makeCredentialId(repositoryUrl);
        }
        if (credentialId == null) {
            return null;
        }
        return (StandardCredentials)CredentialsUtils.findCredential((String)credentialId, StandardCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
    }

    public Container<ScmOrganization> getOrganizations() {
        return null;
    }

    public ScmServerEndpointContainer getServers() {
        return null;
    }

    public HttpResponse validateAndCreate(@JsonBody JSONObject request) {
        StandardCredentials creds;
        String repositoryUrl;
        AbstractGitSCMSource scmSource;
        boolean requirePush = request.has("requirePush");
        if (request.has("repositoryUrl")) {
            scmSource = null;
            repositoryUrl = request.getString("repositoryUrl");
        } else {
            try {
                String fullName = request.getJSONObject("pipeline").getString("fullName");
                SCMSourceOwner item = (SCMSourceOwner)Jenkins.getInstance().getItemByFullName(fullName, SCMSourceOwner.class);
                if (item == null) {
                    return HttpResponses.errorJSON((String)("No repository found for: " + fullName));
                }
                scmSource = (AbstractGitSCMSource)item.getSCMSources().iterator().next();
                repositoryUrl = scmSource.getRemote();
            }
            catch (JSONException e) {
                return HttpResponses.errorJSON((String)"No repositoryUrl or pipeline.fullName specified in request.");
            }
            catch (RuntimeException e) {
                return HttpResponses.errorWithoutStack((int)500, (String)e.getMessage());
            }
        }
        User user = User.current();
        if (user == null) {
            throw new ServiceException.UnauthorizedException("Not authenticated");
        }
        String credentialId = null;
        if (request.has("credentialId")) {
            credentialId = request.getString("credentialId");
        }
        if (credentialId == null) {
            credentialId = GitScm.makeCredentialId(repositoryUrl);
        }
        if (credentialId == null) {
            throw new ServiceException.BadRequestException("Invalid URL \"" + repositoryUrl + "\"");
        }
        if (request.has("userName") || request.has("password")) {
            this.createPWCredentials(credentialId, user, request, repositoryUrl);
        }
        if ((creds = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)Jenkins.getAuthentication(), (List)null), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialId)}))) == null) {
            throw new ServiceException.NotFoundException("No credentials found for: " + credentialId);
        }
        try {
            if (requirePush) {
                String branch = request.getString("branch");
                new GitBareRepoReadSaveRequest(scmSource, branch, null, branch, null, null).invokeOnScm(new GitSCMFileSystem.FSFunction<Void>(){

                    public Void invoke(Repository repository) throws IOException, InterruptedException {
                        GitUtils.validatePushAccess(repository, repositoryUrl, creds);
                        return null;
                    }
                });
            } else {
                List<ErrorMessage.Error> errors = GitUtils.validateCredentials(repositoryUrl, creds);
                if (!errors.isEmpty()) {
                    throw new ServiceException.UnauthorizedException(errors.get(0).getMessage());
                }
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message != null && message.contains("TransportException")) {
                throw new ServiceException.PreconditionRequired("Repository URL unreachable: " + repositoryUrl);
            }
            return HttpResponses.errorWithoutStack((int)428, (String)message);
        }
        return HttpResponses.okJSON();
    }

    private void createPWCredentials(String credentialId, User user, @JsonBody JSONObject request, String repositoryUrl) {
        StandardUsernamePasswordCredentials existingCredential = (StandardUsernamePasswordCredentials)CredentialsUtils.findCredential((String)credentialId, StandardUsernamePasswordCredentials.class, (DomainRequirement[])new DomainRequirement[]{new BlueOceanDomainRequirement()});
        String requestUsername = request.getString("userName");
        String requestPassword = request.getString("password");
        String description = String.format("%s for %s", CREDENTIAL_DESCRIPTION_PW, repositoryUrl);
        UsernamePasswordCredentialsImpl newCredential = new UsernamePasswordCredentialsImpl(CredentialsScope.USER, credentialId, description, requestUsername, requestPassword);
        try {
            if (existingCredential == null) {
                CredentialsUtils.createCredentialsInUserStore((Credentials)newCredential, (User)user, (String)CREDENTIAL_DOMAIN_NAME, (List)ImmutableList.of((Object)new BlueOceanDomainSpecification()));
            } else {
                CredentialsUtils.updateCredentialsInUserStore((Credentials)existingCredential, (Credentials)newCredential, (User)user, (String)CREDENTIAL_DOMAIN_NAME, (List)ImmutableList.of((Object)new BlueOceanDomainSpecification()));
            }
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Could not persist credential", (Throwable)e);
        }
    }

    @Extension
    public static class GitScmFactory
    extends ScmFactory {
        public Scm getScm(@Nonnull String id, @Nonnull Reachable parent) {
            if (id.equals(GitScm.ID)) {
                return new GitScm(parent);
            }
            return null;
        }

        @Nonnull
        public Scm getScm(Reachable parent) {
            return new GitScm(parent);
        }
    }
}

