/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.triggers.SafeTimerTask;
import io.fabric8.jenkins.openshiftsync.BaseWatcher;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.WatcherCallback;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Watchable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecretWatcher
extends BaseWatcher {
    private Map<String, String> trackedSecrets;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SecretWatcher(String[] namespaces) {
        super(namespaces);
        this.trackedSecrets = new ConcurrentHashMap<String, String>();
    }

    @Override
    public Runnable getStartTimerTask() {
        return new SafeTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doRun() {
                if (!CredentialsUtils.hasCredentials()) {
                    SecretWatcher.this.logger.fine("No Openshift Token credential defined.");
                    return;
                }
                for (String namespace : SecretWatcher.this.namespaces) {
                    SecretList secrets = null;
                    try {
                        SecretWatcher.this.logger.fine("listing Secrets resources");
                        secrets = (SecretList)((FilterWatchListDeletable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().secrets().inNamespace(namespace)).withLabel("credential.sync.jenkins.openshift.io", "true")).list();
                        SecretWatcher.this.onInitialSecrets(secrets);
                        SecretWatcher.this.logger.fine("handled Secrets resources");
                    }
                    catch (Exception e) {
                        SecretWatcher.this.logger.log(Level.SEVERE, "Failed to load Secrets: " + e, e);
                    }
                    try {
                        String resourceVersion = "0";
                        if (secrets == null) {
                            SecretWatcher.this.logger.warning("Unable to get secret list; impacts resource version used for watch");
                        } else {
                            resourceVersion = secrets.getMetadata().getResourceVersion();
                        }
                        SecretWatcher secretWatcher = SecretWatcher.this;
                        synchronized (secretWatcher) {
                            if (SecretWatcher.this.watches.get(namespace) == null) {
                                SecretWatcher.this.logger.info("creating Secret watch for namespace " + namespace + " and resource version" + resourceVersion);
                                SecretWatcher.this.watches.put(namespace, ((Watchable)((FilterWatchListDeletable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().secrets().inNamespace(namespace)).withLabel("credential.sync.jenkins.openshift.io", "true")).withResourceVersion(resourceVersion)).watch(new WatcherCallback(SecretWatcher.this, namespace)));
                            }
                        }
                    }
                    catch (Exception e) {
                        SecretWatcher.this.logger.log(Level.SEVERE, "Failed to load Secrets: " + e, e);
                    }
                }
            }
        };
    }

    @Override
    public synchronized void start() {
        super.start();
        this.logger.info("Now handling startup secrets!!");
    }

    private synchronized void onInitialSecrets(SecretList secrets) {
        List items;
        if (secrets == null) {
            return;
        }
        if (this.trackedSecrets == null) {
            this.trackedSecrets = new ConcurrentHashMap<String, String>();
        }
        if ((items = secrets.getItems()) != null) {
            for (Secret secret : items) {
                try {
                    if (!this.validSecret(secret) || !this.shouldProcessSecret(secret)) continue;
                    this.upsertCredential(secret);
                    this.trackedSecrets.put(secret.getMetadata().getUid(), secret.getMetadata().getResourceVersion());
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Failed to update job", e);
                }
            }
        }
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    public synchronized void eventReceived(Watcher.Action action, Secret secret) {
        try {
            switch (action) {
                case ADDED: {
                    this.upsertCredential(secret);
                    break;
                }
                case DELETED: {
                    this.deleteCredential(secret);
                    break;
                }
                case MODIFIED: {
                    this.modifyCredential(secret);
                    break;
                }
                case ERROR: {
                    this.logger.warning("watch for secret " + secret.getMetadata().getName() + " received error event ");
                    break;
                }
                default: {
                    this.logger.warning("watch for secret " + secret.getMetadata().getName() + " received unknown event " + action);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        Secret secret = (Secret)resource;
        this.eventReceived(action, secret);
    }

    private void upsertCredential(Secret secret) throws Exception {
        if (this.validSecret(secret)) {
            CredentialsUtils.upsertCredential(secret);
            this.trackedSecrets.put(secret.getMetadata().getUid(), secret.getMetadata().getResourceVersion());
        }
    }

    private void modifyCredential(Secret secret) throws Exception {
        if (this.validSecret(secret) && this.shouldProcessSecret(secret)) {
            CredentialsUtils.upsertCredential(secret);
            this.trackedSecrets.put(secret.getMetadata().getUid(), secret.getMetadata().getResourceVersion());
        }
    }

    private boolean validSecret(Secret secret) {
        ObjectMeta metadata = secret.getMetadata();
        if (metadata != null) {
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            return name != null && !name.isEmpty() && namespace != null && !namespace.isEmpty();
        }
        return false;
    }

    private boolean shouldProcessSecret(Secret secret) {
        String uid = secret.getMetadata().getUid();
        String rv = secret.getMetadata().getResourceVersion();
        String savedRV = this.trackedSecrets.get(uid);
        return savedRV == null || !savedRV.equals(rv);
    }

    private void deleteCredential(Secret secret) throws Exception {
        this.trackedSecrets.remove(secret.getMetadata().getUid());
        CredentialsUtils.deleteCredential(secret);
    }
}

