/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.triggers.SafeTimerTask;
import hudson.util.ListBoxModel;
import io.fabric8.jenkins.openshiftsync.BuildConfigWatcher;
import io.fabric8.jenkins.openshiftsync.BuildWatcher;
import io.fabric8.jenkins.openshiftsync.ConfigMapWatcher;
import io.fabric8.jenkins.openshiftsync.ImageStreamWatcher;
import io.fabric8.jenkins.openshiftsync.OpenShiftToken;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.SecretWatcher;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class GlobalPluginConfiguration
extends GlobalConfiguration {
    private static final Logger logger = Logger.getLogger(GlobalPluginConfiguration.class.getName());
    private boolean enabled = true;
    private String server;
    private String credentialsId = "";
    private String[] namespaces;
    private String jobNamePattern;
    private String skipOrganizationPrefix;
    private String skipBranchSuffix;
    private transient BuildWatcher buildWatcher;
    private transient BuildConfigWatcher buildConfigWatcher;
    private transient SecretWatcher secretWatcher;
    private transient ConfigMapWatcher configMapWatcher;
    private transient ImageStreamWatcher imageStreamWatcher;

    @DataBoundConstructor
    public GlobalPluginConfiguration(boolean enable, String server, String namespace, String credentialsId, String jobNamePattern, String skipOrganizationPrefix, String skipBranchSuffix) {
        this.enabled = enable;
        this.server = server;
        this.namespaces = StringUtils.isBlank((String)namespace) ? null : namespace.split(" ");
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
        this.jobNamePattern = jobNamePattern;
        this.skipOrganizationPrefix = skipOrganizationPrefix;
        this.skipBranchSuffix = skipBranchSuffix;
        this.configChange();
    }

    public GlobalPluginConfiguration() {
        this.load();
        this.configChange();
    }

    public static GlobalPluginConfiguration get() {
        return (GlobalPluginConfiguration)((Object)GlobalConfiguration.all().get(GlobalPluginConfiguration.class));
    }

    public String getDisplayName() {
        return "OpenShift Jenkins Sync";
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.configChange();
        this.save();
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getCredentialsId() {
        return this.credentialsId == null ? "" : this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    public String getNamespace() {
        return this.namespaces == null ? "" : StringUtils.join((Object[])this.namespaces, (String)" ");
    }

    public void setNamespace(String namespace) {
        this.namespaces = StringUtils.isBlank((String)namespace) ? null : namespace.split(" ");
    }

    public String getJobNamePattern() {
        return this.jobNamePattern;
    }

    public void setJobNamePattern(String jobNamePattern) {
        this.jobNamePattern = jobNamePattern;
    }

    public String getSkipOrganizationPrefix() {
        return this.skipOrganizationPrefix;
    }

    public void setSkipOrganizationPrefix(String skipOrganizationPrefix) {
        this.skipOrganizationPrefix = skipOrganizationPrefix;
    }

    public String getSkipBranchSuffix() {
        return this.skipBranchSuffix;
    }

    public void setSkipBranchSuffix(String skipBranchSuffix) {
        this.skipBranchSuffix = skipBranchSuffix;
    }

    public static ListBoxModel doFillCredentialsIdItems(String credentialsId) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return null;
        }
        if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
            return new StandardListBoxModel().includeCurrentValue(credentialsId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, (ItemGroup)jenkins, OpenShiftToken.class).includeCurrentValue(credentialsId);
    }

    private void configChange() {
        if (!this.enabled) {
            if (this.buildConfigWatcher != null) {
                this.buildConfigWatcher.stop();
            }
            if (this.buildWatcher != null) {
                this.buildWatcher.stop();
            }
            if (this.configMapWatcher != null) {
                this.configMapWatcher.stop();
            }
            if (this.imageStreamWatcher != null) {
                this.imageStreamWatcher.stop();
            }
            if (this.secretWatcher != null) {
                this.secretWatcher.stop();
            }
            OpenShiftUtils.shutdownOpenShiftClient();
            return;
        }
        try {
            OpenShiftUtils.initializeOpenShiftClient(this.server);
            this.namespaces = OpenShiftUtils.getNamespaceOrUseDefault(this.namespaces, OpenShiftUtils.getOpenShiftClient());
            SafeTimerTask task = new SafeTimerTask(){

                protected void doRun() throws Exception {
                    logger.info("Waiting for Jenkins to be started");
                    while (true) {
                        Jenkins instance = Jenkins.getActiveInstance();
                        InitMilestone initLevel = instance.getInitLevel();
                        logger.fine("Jenkins init level: " + initLevel.toString());
                        if (initLevel == InitMilestone.COMPLETED) break;
                        logger.fine("Jenkins not ready...");
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    GlobalPluginConfiguration.this.buildConfigWatcher = new BuildConfigWatcher(GlobalPluginConfiguration.this.namespaces);
                    GlobalPluginConfiguration.this.buildConfigWatcher.start();
                    GlobalPluginConfiguration.this.buildWatcher = new BuildWatcher(GlobalPluginConfiguration.this.namespaces);
                    GlobalPluginConfiguration.this.buildWatcher.start();
                    GlobalPluginConfiguration.this.configMapWatcher = new ConfigMapWatcher(GlobalPluginConfiguration.this.namespaces);
                    GlobalPluginConfiguration.this.configMapWatcher.start();
                    GlobalPluginConfiguration.this.imageStreamWatcher = new ImageStreamWatcher(GlobalPluginConfiguration.this.namespaces);
                    GlobalPluginConfiguration.this.imageStreamWatcher.start();
                    GlobalPluginConfiguration.this.secretWatcher = new SecretWatcher(GlobalPluginConfiguration.this.namespaces);
                    GlobalPluginConfiguration.this.secretWatcher.start();
                }
            };
            Timer.get().schedule((Runnable)task, 1L, TimeUnit.SECONDS);
        }
        catch (KubernetesClientException e) {
            if (e.getCause() != null) {
                logger.log(Level.SEVERE, "Failed to configure OpenShift Jenkins Sync Plugin: " + e.getCause());
            }
            logger.log(Level.SEVERE, "Failed to configure OpenShift Jenkins Sync Plugin: " + (Object)((Object)e));
        }
    }
}

