/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Util;
import hudson.model.Fingerprint;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.remoting.Base64;
import hudson.security.ACL;
import io.fabric8.jenkins.openshiftsync.BuildConfigSecretToCredentialsMap;
import io.fabric8.jenkins.openshiftsync.GlobalPluginConfiguration;
import io.fabric8.jenkins.openshiftsync.NamespaceName;
import io.fabric8.jenkins.openshiftsync.OpenShiftToken;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.BuildConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;

public class CredentialsUtils {
    private static final Logger logger = Logger.getLogger(CredentialsUtils.class.getName());

    public static synchronized Secret getSourceCredentials(BuildConfig buildConfig) {
        if (buildConfig.getSpec() != null && buildConfig.getSpec().getSource() != null && buildConfig.getSpec().getSource().getSourceSecret() != null && !buildConfig.getSpec().getSource().getSourceSecret().getName().isEmpty()) {
            Secret sourceSecret = (Secret)((Resource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().secrets().inNamespace(buildConfig.getMetadata().getNamespace())).withName(buildConfig.getSpec().getSource().getSourceSecret().getName())).get();
            return sourceSecret;
        }
        return null;
    }

    public static synchronized String updateSourceCredentials(BuildConfig buildConfig) throws IOException {
        Secret sourceSecret = CredentialsUtils.getSourceCredentials(buildConfig);
        String credID = null;
        if (sourceSecret != null) {
            credID = CredentialsUtils.upsertCredential(sourceSecret, sourceSecret.getMetadata().getNamespace(), sourceSecret.getMetadata().getName());
            if (credID != null) {
                BuildConfigSecretToCredentialsMap.linkBCSecretToCredential(NamespaceName.create((HasMetadata)buildConfig).toString(), credID);
            }
        } else {
            credID = BuildConfigSecretToCredentialsMap.unlinkBCSecretToCrendential(NamespaceName.create((HasMetadata)buildConfig).toString());
            if (credID != null) {
                CredentialsUtils.deleteCredential(credID, NamespaceName.create((HasMetadata)buildConfig), buildConfig.getMetadata().getResourceVersion());
            }
        }
        return credID;
    }

    public static synchronized void deleteSourceCredentials(BuildConfig buildConfig) throws IOException {
        Secret sourceSecret = CredentialsUtils.getSourceCredentials(buildConfig);
        if (sourceSecret != null) {
            boolean watching;
            String labelValue = (String)sourceSecret.getMetadata().getLabels().get("credential.sync.jenkins.openshift.io");
            boolean bl = watching = labelValue != null && labelValue.equalsIgnoreCase("true");
            if (watching) {
                return;
            }
            CredentialsUtils.deleteCredential(sourceSecret);
        }
    }

    public static synchronized String upsertCredential(Secret secret) throws IOException {
        ObjectMeta metadata;
        if (secret != null && (metadata = secret.getMetadata()) != null) {
            return CredentialsUtils.upsertCredential(secret, metadata.getNamespace(), metadata.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String upsertCredential(Secret secret, String namespace, String secretName) throws IOException {
        String id = null;
        if (secret != null) {
            Credentials creds = CredentialsUtils.secretToCredentials(secret);
            if (creds == null) {
                return null;
            }
            id = CredentialsUtils.secretName(namespace, secretName);
            Credentials existingCreds = CredentialsUtils.lookupCredentials(id);
            SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getActiveInstance()).iterator().next();
                if (existingCreds != null) {
                    s.updateCredentials(Domain.global(), existingCreds, creds);
                    logger.info("Updated credential " + id + " from Secret " + NamespaceName.create((HasMetadata)secret) + " with revision: " + secret.getMetadata().getResourceVersion());
                } else {
                    s.addCredentials(Domain.global(), creds);
                    logger.info("Created credential " + id + " from Secret " + NamespaceName.create((HasMetadata)secret) + " with revision: " + secret.getMetadata().getResourceVersion());
                }
                s.save();
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)previousContext);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteCredential(String id, NamespaceName name, String resourceRevision) throws IOException {
        Credentials existingCred = CredentialsUtils.lookupCredentials(id);
        if (existingCred != null) {
            SecurityContext previousContext = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                Fingerprint fp = CredentialsProvider.getFingerprintOf((Credentials)existingCred);
                if (fp != null && fp.getJobs().size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (String job : fp.getJobs()) {
                        sb.append(job).append(" ");
                    }
                    logger.info("About to delete credential " + id + "which is referenced by jobs: " + sb.toString());
                }
                CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getActiveInstance()).iterator().next();
                s.removeCredentials(Domain.global(), existingCred);
                logger.info("Deleted credential " + id + " from Secret " + name + " with revision: " + resourceRevision);
                s.save();
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)previousContext);
            }
        }
    }

    public static void deleteCredential(Secret secret) throws IOException {
        if (secret != null) {
            String id = CredentialsUtils.secretName(secret.getMetadata().getNamespace(), secret.getMetadata().getName());
            CredentialsUtils.deleteCredential(id, NamespaceName.create((HasMetadata)secret), secret.getMetadata().getResourceVersion());
        }
    }

    public static String getCurrentToken() {
        String credentialsId = GlobalPluginConfiguration.get().getCredentialsId();
        if (credentialsId.equals("")) {
            return "";
        }
        OpenShiftToken token = (OpenShiftToken)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(OpenShiftToken.class, (ItemGroup)Jenkins.getActiveInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (token != null) {
            return token.getToken();
        }
        return "";
    }

    private static Credentials lookupCredentials(String id) {
        return CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(Credentials.class, (ItemGroup)Jenkins.getActiveInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    private static String secretName(String namespace, String name) {
        return namespace + "-" + name;
    }

    private static Credentials secretToCredentials(Secret secret) {
        String namespace = secret.getMetadata().getNamespace();
        String name = secret.getMetadata().getName();
        Map data = secret.getData();
        if (data == null) {
            logger.log(Level.WARNING, "An OpenShift secret was marked for import, but it has no secret data.  No credential will be created.");
            return null;
        }
        String secretName = CredentialsUtils.secretName(namespace, name);
        switch (secret.getType()) {
            case "Opaque": {
                String usernameData = (String)data.get("username");
                String passwordData = (String)data.get("password");
                if (StringUtils.isNotBlank((String)usernameData) && StringUtils.isNotBlank((String)passwordData)) {
                    return CredentialsUtils.newUsernamePasswordCredentials(secretName, usernameData, passwordData);
                }
                String sshKeyData = (String)data.get("ssh-privatekey");
                if (StringUtils.isNotBlank((String)sshKeyData)) {
                    return CredentialsUtils.newSSHUserCredential(secretName, (String)data.get("username"), sshKeyData);
                }
                logger.log(Level.WARNING, "Opaque secret either requires {0} and {1} fields for basic auth or {2} field for SSH key", new Object[]{"username", "password", "ssh-privatekey"});
                return null;
            }
            case "kubernetes.io/basic-auth": {
                return CredentialsUtils.newUsernamePasswordCredentials(secretName, (String)data.get("username"), (String)data.get("password"));
            }
            case "kubernetes.io/ssh-auth": {
                return CredentialsUtils.newSSHUserCredential(secretName, (String)data.get("username"), (String)data.get("ssh-privatekey"));
            }
        }
        logger.log(Level.WARNING, "Unknown secret type: " + secret.getType());
        return null;
    }

    private static Credentials newSSHUserCredential(String secretName, String username, String sshKeyData) {
        if (secretName == null || secretName.length() == 0 || sshKeyData == null || sshKeyData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " sshKeyData is null: " + (sshKeyData == null) + " sshKeyData is empty: " + (sshKeyData != null ? sshKeyData.length() == 0 : false));
            return null;
        }
        return new BasicSSHUserPrivateKey(CredentialsScope.GLOBAL, secretName, Util.fixNull((String)username), (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(new String(Base64.decode((String)sshKeyData), StandardCharsets.UTF_8)), null, secretName);
    }

    private static Credentials newUsernamePasswordCredentials(String secretName, String usernameData, String passwordData) {
        if (secretName == null || secretName.length() == 0 || usernameData == null || usernameData.length() == 0 || passwordData == null || passwordData.length() == 0) {
            logger.log(Level.WARNING, "Invalid secret data, secretName: " + secretName + " usernameData is null: " + (usernameData == null) + " usernameData is empty: " + (usernameData != null ? usernameData.length() == 0 : false) + " passwordData is null: " + (passwordData == null) + " passwordData is empty: " + (passwordData != null ? passwordData.length() == 0 : false));
            return null;
        }
        return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, secretName, secretName, new String(Base64.decode((String)usernameData), StandardCharsets.UTF_8), new String(Base64.decode((String)passwordData), StandardCharsets.UTF_8));
    }

    public static boolean hasCredentials() {
        return !StringUtils.isEmpty((String)OpenShiftUtils.getAuthenticatedOpenShiftClient().getConfiguration().getOauthToken());
    }
}

