/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jenkins.openshiftsync;

import com.thoughtworks.xstream.XStreamException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.triggers.SafeTimerTask;
import hudson.util.XStream2;
import io.fabric8.jenkins.openshiftsync.BaseWatcher;
import io.fabric8.jenkins.openshiftsync.CredentialsUtils;
import io.fabric8.jenkins.openshiftsync.JenkinsUtils;
import io.fabric8.jenkins.openshiftsync.OpenShiftUtils;
import io.fabric8.jenkins.openshiftsync.WatcherCallback;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.openshift.api.model.ImageStreamTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;

public class ConfigMapWatcher
extends BaseWatcher {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, List<PodTemplate>> trackedConfigMaps = new ConcurrentHashMap<String, List<PodTemplate>>();
    private static final String SPECIAL_IST_PREFIX = "imagestreamtag:";
    private static final int SPECIAL_IST_PREFIX_IDX = "imagestreamtag:".length();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ConfigMapWatcher(String[] namespaces) {
        super(namespaces);
    }

    @Override
    public Runnable getStartTimerTask() {
        return new SafeTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doRun() {
                if (!CredentialsUtils.hasCredentials()) {
                    ConfigMapWatcher.this.logger.fine("No Openshift Token credential defined.");
                    return;
                }
                for (String namespace : ConfigMapWatcher.this.namespaces) {
                    ConfigMapList configMaps = null;
                    try {
                        ConfigMapWatcher.this.logger.fine("listing ConfigMap resources");
                        configMaps = (ConfigMapList)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().configMaps().inNamespace(namespace)).list();
                        ConfigMapWatcher.this.onInitialConfigMaps(configMaps);
                        ConfigMapWatcher.this.logger.fine("handled ConfigMap resources");
                    }
                    catch (Exception e) {
                        ConfigMapWatcher.this.logger.log(Level.SEVERE, "Failed to load ConfigMaps: " + e, e);
                    }
                    try {
                        String resourceVersion = "0";
                        if (configMaps == null) {
                            ConfigMapWatcher.this.logger.warning("Unable to get config map list; impacts resource version used for watch");
                        } else {
                            resourceVersion = configMaps.getMetadata().getResourceVersion();
                        }
                        ConfigMapWatcher configMapWatcher = ConfigMapWatcher.this;
                        synchronized (configMapWatcher) {
                            if (ConfigMapWatcher.this.watches.get(namespace) == null) {
                                ConfigMapWatcher.this.logger.info("creating ConfigMap watch for namespace " + namespace + " and resource version " + resourceVersion);
                                ConfigMapWatcher.this.watches.put(namespace, ((Watchable)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().configMaps().inNamespace(namespace)).withResourceVersion(resourceVersion)).watch(new WatcherCallback(ConfigMapWatcher.this, namespace)));
                            }
                        }
                    }
                    catch (Exception e) {
                        ConfigMapWatcher.this.logger.log(Level.SEVERE, "Failed to load ConfigMaps: " + e, e);
                    }
                }
            }
        };
    }

    @Override
    public synchronized void start() {
        super.start();
        this.logger.info("Now handling startup config maps!!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void eventReceived(Watcher.Action action, ConfigMap configMap) {
        try {
            switch (action) {
                case ADDED: {
                    if (!this.containsSlave(configMap)) return;
                    List<PodTemplate> templates = this.podTemplatesFromConfigMap(configMap);
                    this.trackedConfigMaps.put(configMap.getMetadata().getUid(), templates);
                    Iterator<PodTemplate> iterator = templates.iterator();
                    while (iterator.hasNext()) {
                        PodTemplate podTemplate = iterator.next();
                        JenkinsUtils.addPodTemplate(podTemplate);
                    }
                    return;
                }
                case MODIFIED: {
                    boolean alreadyTracked = this.trackedConfigMaps.containsKey(configMap.getMetadata().getUid());
                    if (alreadyTracked) {
                        if (this.containsSlave(configMap)) {
                            for (PodTemplate podTemplate : this.trackedConfigMaps.get(configMap.getMetadata().getUid())) {
                                JenkinsUtils.removePodTemplate(podTemplate);
                            }
                            Iterator<PodTemplate> iterator = this.podTemplatesFromConfigMap(configMap).iterator();
                            while (iterator.hasNext()) {
                                PodTemplate podTemplate;
                                podTemplate = iterator.next();
                                JenkinsUtils.addPodTemplate(podTemplate);
                            }
                            return;
                        }
                        Iterator<PodTemplate> iterator = this.trackedConfigMaps.get(configMap.getMetadata().getUid()).iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                this.trackedConfigMaps.remove(configMap.getMetadata().getUid());
                                return;
                            }
                            PodTemplate podTemplate = iterator.next();
                            JenkinsUtils.removePodTemplate(podTemplate);
                        }
                    }
                    if (!this.containsSlave(configMap)) return;
                    List<PodTemplate> templates = this.podTemplatesFromConfigMap(configMap);
                    this.trackedConfigMaps.put(configMap.getMetadata().getUid(), templates);
                    Iterator<PodTemplate> podTemplate = templates.iterator();
                    while (podTemplate.hasNext()) {
                        PodTemplate podTemplate2 = podTemplate.next();
                        JenkinsUtils.addPodTemplate(podTemplate2);
                    }
                    return;
                }
                case DELETED: {
                    if (!this.trackedConfigMaps.containsKey(configMap.getMetadata().getUid())) return;
                    Iterator<PodTemplate> iterator = this.trackedConfigMaps.get(configMap.getMetadata().getUid()).iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.trackedConfigMaps.remove(configMap.getMetadata().getUid());
                            return;
                        }
                        PodTemplate podTemplate = iterator.next();
                        JenkinsUtils.removePodTemplate(podTemplate);
                    }
                }
                case ERROR: {
                    this.logger.warning("watch for configMap " + configMap.getMetadata().getName() + " received error event ");
                    return;
                }
            }
            this.logger.warning("watch for configMap " + configMap.getMetadata().getName() + " received unknown event " + action);
            return;
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Caught: " + e, e);
        }
    }

    @Override
    public <T> void eventReceived(Watcher.Action action, T resource) {
        ConfigMap cfgmap = (ConfigMap)resource;
        this.eventReceived(action, cfgmap);
    }

    private synchronized void onInitialConfigMaps(ConfigMapList configMaps) {
        List items;
        if (configMaps == null) {
            return;
        }
        if (this.trackedConfigMaps == null) {
            this.trackedConfigMaps = new ConcurrentHashMap<String, List<PodTemplate>>(configMaps.getItems().size());
        }
        if ((items = configMaps.getItems()) != null) {
            for (ConfigMap configMap : items) {
                try {
                    if (!this.containsSlave(configMap) || this.trackedConfigMaps.containsKey(configMap.getMetadata().getUid())) continue;
                    List<PodTemplate> templates = this.podTemplatesFromConfigMap(configMap);
                    this.trackedConfigMaps.put(configMap.getMetadata().getUid(), templates);
                    for (PodTemplate podTemplate : templates) {
                        JenkinsUtils.addPodTemplate(podTemplate);
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Failed to update ConfigMap PodTemplates", e);
                }
            }
        }
    }

    private boolean containsSlave(ConfigMap configMap) {
        return this.hasSlaveLabelOrAnnotation(configMap.getMetadata().getLabels());
    }

    private boolean hasOneAndOnlyOneWithSomethingAfter(String str, String substr) {
        return str.contains(substr) && str.indexOf(substr) == str.lastIndexOf(substr) && str.indexOf(substr) < str.length();
    }

    public List<PodTemplate> podTemplatesFromConfigMap(ConfigMap configMap) {
        ArrayList<PodTemplate> results = new ArrayList<PodTemplate>();
        Map data = configMap.getData();
        XStream2 xStream2 = new XStream2();
        for (Map.Entry entry : data.entrySet()) {
            try {
                Object podTemplate = xStream2.fromXML((String)entry.getValue());
                String warningPrefix = "Content of key '" + (String)entry.getKey() + "' in ConfigMap '" + configMap.getMetadata().getName();
                if (podTemplate instanceof PodTemplate) {
                    block16: {
                        PodTemplate pt = (PodTemplate)podTemplate;
                        String image = pt.getImage();
                        try {
                            if (image.startsWith(SPECIAL_IST_PREFIX)) {
                                if ((image = image.substring(SPECIAL_IST_PREFIX_IDX)).contains("@")) {
                                    this.logger.warning(warningPrefix + " the presence of @ implies an image stream image, not an image stream tag,  so no ImageStreamTag to Docker image reference translation was performed.");
                                } else {
                                    boolean hasNamespace = this.hasOneAndOnlyOneWithSomethingAfter(image, "/");
                                    boolean hasTag = this.hasOneAndOnlyOneWithSomethingAfter(image, ":");
                                    String namespace = OpenShiftUtils.getAuthenticatedOpenShiftClient().getNamespace();
                                    String isName = image;
                                    String newImage = null;
                                    if (hasNamespace) {
                                        String[] parts = image.split("/");
                                        namespace = parts[0];
                                        isName = parts[1];
                                    }
                                    if (hasTag) {
                                        ImageStreamTag ist = (ImageStreamTag)((Resource)((NonNamespaceOperation)OpenShiftUtils.getAuthenticatedOpenShiftClient().imageStreamTags().inNamespace(namespace)).withName(isName)).get();
                                        if (ist != null && ist.getImage() != null && ist.getImage().getDockerImageReference() != null && ist.getImage().getDockerImageReference().length() > 0) {
                                            newImage = ist.getImage().getDockerImageReference();
                                            this.logger.fine(String.format("Converting image ref %s as an imagestreamtag %s to fully qualified image %s", image, isName, newImage));
                                        } else {
                                            this.logger.warning(warningPrefix + " used the 'imagestreamtag:' prefix in the image field, but the subsequent value, while a valid ImageStreamTag reference, produced no valid ImageStreaTag upon lookup, so no ImageStreamTag to Docker image reference translation was performed.");
                                        }
                                    } else {
                                        this.logger.warning(warningPrefix + " used the 'imagestreamtag:' prefix in the image field, but the subsequent value had no tag indicator, so no ImageStreamTag to Docker image reference translation was performed.");
                                    }
                                    if (newImage != null) {
                                        this.logger.fine("translated IST ref " + image + " to docker image ref " + newImage);
                                        ((ContainerTemplate)pt.getContainers().get(0)).setImage(newImage);
                                    }
                                }
                            }
                        }
                        catch (Throwable t) {
                            if (!this.logger.isLoggable(Level.FINE)) break block16;
                            this.logger.log(Level.FINE, "podTemplateFromConfigMap", t);
                        }
                    }
                    results.add((PodTemplate)podTemplate);
                    continue;
                }
                this.logger.warning(warningPrefix + "' is not a PodTemplate");
            }
            catch (XStreamException xse) {
                this.logger.warning(new IOException("Unable to read key '" + (String)entry.getKey() + "' from ConfigMap '" + configMap.getMetadata().getName() + "'", xse).getMessage());
            }
            catch (Error e) {
                this.logger.warning(new IOException("Unable to read key '" + (String)entry.getKey() + "' from ConfigMap '" + configMap.getMetadata().getName() + "'", e).getMessage());
            }
        }
        return results;
    }
}

