/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api.transfer;

import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.packagedrone.repo.api.transfer.TransferWriterEntryContext;

public class TransferArchiveWriter
implements TransferWriterEntryContext {
    private final ZipOutputStream stream;

    public TransferArchiveWriter(OutputStream stream) {
        this.stream = new ZipOutputStream(stream);
    }

    @Override
    public TransferWriterEntryContext createEntry(String name, Map<String, String> properties, InputStream stream) throws IOException {
        return this.store(Collections.<String>emptyList(), name, properties, stream);
    }

    private TransferWriterEntryContext store(List<String> parents, String name, Map<String, String> properties, InputStream stream) throws IOException {
        final ArrayList<String> newParents = new ArrayList<String>(parents.size());
        newParents.addAll(parents);
        name = name.replace(File.separatorChar, '/');
        int idx = name.lastIndexOf(47);
        if (idx >= 0) {
            newParents.add(name.substring(idx + 1, name.length() - 1));
        } else {
            newParents.add(name);
        }
        String basename = this.makeBaseName(newParents);
        this.addEntry(basename + "/properties.json", new ByteArrayInputStream(this.writeProperties(properties).getBytes("UTF-8")));
        this.addEntry(basename + "/name", new ByteArrayInputStream(name.getBytes("UTF-8")));
        this.addEntry(basename + "/content", stream);
        return new TransferWriterEntryContext(){

            @Override
            public TransferWriterEntryContext createEntry(String name, Map<String, String> properties, InputStream stream) throws IOException {
                return TransferArchiveWriter.this.store(newParents, name, properties, stream);
            }
        };
    }

    private void addEntry(String name, InputStream stream) throws IOException {
        this.stream.putNextEntry(new ZipEntry(name));
        IOUtils.copy((InputStream)stream, (OutputStream)this.stream);
        this.stream.closeEntry();
    }

    protected String writeProperties(Map<String, String> properties) throws IOException {
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        return new GsonBuilder().create().toJson(properties);
    }

    private String makeBaseName(List<String> parents) {
        StringBuilder sb = new StringBuilder();
        for (String segment : parents) {
            sb.append("/artifacts/").append(segment);
        }
        return sb.toString();
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

