/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.pm.jenkins;

import com.google.gson.GsonBuilder;
import de.dentrassi.pm.jenkins.AbstractUploader;
import de.dentrassi.pm.jenkins.UrlMaker;
import hudson.console.ConsoleNote;
import hudson.console.ExpandableDetailsNote;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.InputStreamEntity;
import org.eclipse.packagedrone.repo.api.transfer.TransferArchiveWriter;
import org.eclipse.packagedrone.repo.api.upload.ArtifactInformation;
import org.eclipse.packagedrone.repo.api.upload.RejectedArtifact;
import org.eclipse.packagedrone.repo.api.upload.UploadError;
import org.eclipse.packagedrone.repo.api.upload.UploadResult;

public class UploaderV3
extends AbstractUploader {
    private final HttpClient client;
    private final TaskListener listener;
    private final String serverUrl;
    private final String deployKey;
    private final String channelId;
    private boolean failed;
    private final File tempFile;
    private TransferArchiveWriter transfer;

    public UploaderV3(HttpClient client, Run<?, ?> run, TaskListener listener, String serverUrl, String deployKey, String channelId) throws IOException {
        super(run);
        this.client = client;
        this.listener = listener;
        this.serverUrl = serverUrl;
        this.deployKey = deployKey;
        this.channelId = channelId;
        listener.getLogger().println("Uploading using Package Drone V3 uploader");
        this.tempFile = File.createTempFile("pdrone-", "upload");
        try {
            this.transfer = new TransferArchiveWriter(new BufferedOutputStream(new FileOutputStream(this.tempFile)));
        }
        catch (IOException e) {
            this.tempFile.delete();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(File file, String filename) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            this.fillProperties(properties);
            this.transfer.createEntry(filename, properties, new BufferedInputStream(in));
        }
        catch (IOException e) {
            this.failed = true;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean complete() {
        if (this.failed) {
            return false;
        }
        try {
            this.closeTransfer();
            URIBuilder uri = new URIBuilder(String.format("%s/api/v3/upload/archive/channel/%s", this.serverUrl, URIUtil.encodeWithinPath((String)this.channelId)));
            this.listener.getLogger().println("API endpoint: " + uri.build().toString());
            HttpPut httppost = new HttpPut(uri.build());
            String encodedAuth = Base64.encodeBase64String((byte[])("deploy:" + this.deployKey).getBytes("ISO-8859-1"));
            httppost.setHeader("Authorization", "Basic " + encodedAuth);
            FileInputStream stream = new FileInputStream(this.tempFile);
            try {
                httppost.setEntity((HttpEntity)new InputStreamEntity((InputStream)stream, this.tempFile.length()));
                HttpResponse response = this.client.execute((HttpUriRequest)httppost);
                HttpEntity resEntity = response.getEntity();
                this.listener.getLogger().println("Call returned: " + response.getStatusLine());
                if (resEntity != null) {
                    switch (response.getStatusLine().getStatusCode()) {
                        case 200: {
                            this.processUploadResult(UploaderV3.makeString(resEntity));
                            boolean bl = true;
                            return bl;
                        }
                        case 404: {
                            this.listener.error("Failed to find upload endpoint V3. This could mean that you configured a wrong server URL or that the server does not support the Upload V3. You will need a version 0.14+ of Eclipse Package Drone. It could also mean that you did use wrong credentials.");
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (!this.handleError(response)) {
                        this.addErrorMessage("Failed to upload: " + response.getStatusLine());
                    }
                    boolean bl = false;
                    return bl;
                }
                this.addErrorMessage("Did not receive a result");
                boolean bl = false;
                return bl;
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to perform archive upload"));
            return false;
        }
    }

    private boolean handleError(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity.getContentType() == null || !entity.getContentType().getValue().equals("application/json")) {
            return false;
        }
        UploadError error = (UploadError)new GsonBuilder().create().fromJson(UploaderV3.makeString(entity), UploadError.class);
        if (error == null) {
            return false;
        }
        if (error.getMessage() == null) {
            return false;
        }
        this.listener.error(error.getMessage());
        return true;
    }

    private void processUploadResult(String string) {
        try {
            UploadResult result = (UploadResult)new GsonBuilder().create().fromJson(string, UploadResult.class);
            this.listener.getLogger().print("Uploaded to chanel: ");
            this.listener.hyperlink(UrlMaker.make(this.serverUrl, result.getChannelId()), result.getChannelId());
            this.listener.getLogger().println();
            this.listener.annotate((ConsoleNote)this.makeArtifactsList(result));
            this.listener.getLogger().println();
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error("Failed to parse upload result"));
        }
    }

    private ExpandableDetailsNote makeArtifactsList(UploadResult result) {
        ArrayList<Entry> entries = new ArrayList<Entry>(result.getCreatedArtifacts().size() + result.getRejectedArtifacts().size());
        for (ArtifactInformation ai : result.getCreatedArtifacts()) {
            entries.add(new Entry(ai.getName(), ai.getId(), false, null, ai));
        }
        for (RejectedArtifact ra : result.getRejectedArtifacts()) {
            entries.add(new Entry(ra.getName(), null, true, ra.getReason(), null));
        }
        Collections.sort(entries, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        StringBuilder sb = new StringBuilder();
        sb.append("<table>");
        sb.append("<thead><tr><th>Name</th><th>Result</th><th>Size</th><th>Validation</th></tr></thead>");
        sb.append("<tbody>");
        for (Entry entry : entries) {
            sb.append("<tr>");
            sb.append("<td>").append(entry.getName()).append("</td>");
            if (!entry.isRejected()) {
                sb.append("<td>").append("<a target=\"_blank\" href=\"").append(UrlMaker.make(this.serverUrl, result.getChannelId(), entry.getId())).append("\">").append(entry.getId()).append("</a>").append("</td>");
                sb.append("<td>").append(entry.getArtifactInformation().getSize()).append("</td>");
                sb.append("<td>");
                if (entry.getArtifactInformation().getErrors() > 0L) {
                    sb.append(MessageFormat.format("{0,choice,1#1 error|1<{0,number,integer} errors}", entry.getArtifactInformation().getErrors()));
                }
                if (entry.getArtifactInformation().getWarnings() > 0L) {
                    if (entry.getArtifactInformation().getErrors() > 0L) {
                        sb.append(", ");
                    }
                    sb.append(MessageFormat.format("{0,choice,1#1 error|1<{0,number,integer} warnings}", entry.getArtifactInformation().getErrors()));
                }
                sb.append("</td>");
            } else {
                sb.append("<td>").append(entry.getReason()).append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</tbody></table>");
        return new ExpandableDetailsNote(String.format("Uploaded: %s, rejected: %s", result.getCreatedArtifacts().size(), result.getRejectedArtifacts().size()), sb.toString());
    }

    private void addErrorMessage(String message) {
        this.listener.error(message);
    }

    @Override
    public void close() throws IOException {
        this.closeTransfer();
        this.tempFile.delete();
    }

    private void closeTransfer() throws IOException {
        if (this.transfer != null) {
            this.transfer.close();
            this.transfer = null;
        }
    }

    private static class Entry {
        private final String name;
        private final String id;
        private final boolean rejected;
        private final String reason;
        private final ArtifactInformation artifactInformation;

        public Entry(String name, String id, boolean rejected, String reason, ArtifactInformation artifactInformation) {
            this.name = name;
            this.id = id;
            this.rejected = rejected;
            this.reason = reason;
            this.artifactInformation = artifactInformation;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public boolean isRejected() {
            return this.rejected;
        }

        public String getReason() {
            return this.reason;
        }

        public ArtifactInformation getArtifactInformation() {
            return this.artifactInformation;
        }
    }
}

