/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.pm.jenkins;

import de.dentrassi.pm.jenkins.AbstractUploader;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.InputStreamEntity;

public class UploaderV2
extends AbstractUploader {
    private final HttpClient client;
    private final TaskListener listener;
    private final String serverUrl;
    private final String deployKey;
    private final String channelId;
    private boolean failed;

    public UploaderV2(HttpClient client, Run<?, ?> run, TaskListener listener, String serverUrl, String deployKey, String channelId) {
        super(run);
        this.client = client;
        this.listener = listener;
        this.serverUrl = serverUrl;
        this.deployKey = deployKey;
        this.channelId = channelId;
        listener.getLogger().println("Uploading using Package Drone V2 uploader");
    }

    private URI makeUrl(String file) throws URIException, IOException {
        URI fullUri;
        try {
            URIBuilder b = new URIBuilder(this.serverUrl);
            b.setUserInfo("deploy", this.deployKey);
            b.setPath(b.getPath() + String.format("/api/v2/upload/channel/%s/%s", URIUtil.encodeWithinPath((String)this.channelId), file));
            String jenkinsUrl = Jenkins.getInstance().getRootUrl();
            if (jenkinsUrl != null) {
                String url = jenkinsUrl + this.run.getUrl();
                b.addParameter("jenkins:buildUrl", url);
            }
            b.addParameter("jenkins:buildId", this.run.getId());
            b.addParameter("jenkins:buildNumber", String.valueOf(this.run.getNumber()));
            b.addParameter("jenkins:jobName", this.run.getParent().getFullName());
            HashMap<String, String> properties = new HashMap<String, String>();
            this.fillProperties(properties);
            for (Map.Entry entry : properties.entrySet()) {
                b.addParameter((String)entry.getKey(), (String)entry.getValue());
            }
            fullUri = b.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return fullUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void upload(File file, String filename) throws IOException {
        URI uri = this.makeUrl(filename);
        HttpPut httppost = new HttpPut(uri);
        FileInputStream stream = new FileInputStream(file);
        try {
            httppost.setEntity((HttpEntity)new InputStreamEntity((InputStream)stream, file.length()));
            HttpResponse response = this.client.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            if (resEntity == null) return;
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    this.addUploadedArtifacts(filename, resEntity);
                    return;
                }
                default: {
                    this.addUploadFailure(filename, response);
                    return;
                }
            }
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    @Override
    public boolean complete() {
        return !this.failed;
    }

    private void addUploadFailure(String fileName, HttpResponse response) throws IOException {
        this.failed = true;
        String message = UploaderV2.makeString(response.getEntity());
        this.listener.error("Failed to upload %s: %s %s = %s", new Object[]{fileName, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), message});
    }

    private void addUploadedArtifacts(String fileName, HttpEntity resEntity) throws IOException {
        String artId = UploaderV2.makeString(resEntity);
        this.listener.getLogger().format("Uploaded %s as ", fileName);
        this.listener.getLogger().print(artId);
        this.listener.getLogger().println();
    }

    @Override
    public void close() {
    }
}

