/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.pm.jenkins;

import de.dentrassi.pm.jenkins.AbstractUploader;
import de.dentrassi.pm.jenkins.BuildData;
import de.dentrassi.pm.jenkins.UploaderV2;
import de.dentrassi.pm.jenkins.UploaderV3;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import jenkins.tasks.SimpleBuildStep;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DroneRecorder
extends Recorder
implements SimpleBuildStep {
    private String serverUrl;
    private String channel;
    private String deployKey;
    private final String artifacts;
    private String excludes = "";
    private boolean defaultExcludes = true;
    private boolean stripPath;
    private boolean allowEmptyArchive;
    private boolean failsAsUpload;
    private boolean uploadV3 = false;

    @DataBoundConstructor
    public DroneRecorder(String serverUrl, String channel, String deployKey, String artifacts) {
        this.serverUrl = Util.fixEmptyAndTrim((String)serverUrl);
        this.channel = Util.fixEmptyAndTrim((String)channel);
        this.artifacts = artifacts;
        this.deployKey = Util.fixEmptyAndTrim((String)deployKey);
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = Util.fixEmptyAndTrim((String)excludes);
    }

    @DataBoundSetter
    public void setDefaultExcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    @DataBoundSetter
    public void setStripPath(boolean stripPath) {
        this.stripPath = stripPath;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundSetter
    public void setAllowEmptyArchive(boolean allowEmptyArchive) {
        this.allowEmptyArchive = allowEmptyArchive;
    }

    @DataBoundSetter
    public void setFailsAsUpload(boolean failsAsUpload) {
        this.failsAsUpload = failsAsUpload;
    }

    @DataBoundSetter
    public void setUploadV3(boolean uploadV3) {
        this.uploadV3 = uploadV3;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getArtifacts() {
        return this.artifacts;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getDeployKey() {
        return this.deployKey;
    }

    public boolean isDefaultExcludes() {
        return this.defaultExcludes;
    }

    public boolean isStripPath() {
        return this.stripPath;
    }

    public boolean isAllowEmptyArchive() {
        return this.allowEmptyArchive;
    }

    public boolean isFailsAsUpload() {
        return this.failsAsUpload;
    }

    public boolean isUploadV3() {
        return this.uploadV3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        EnvVars env = run.getEnvironment(listener);
        this.serverUrl = Util.replaceMacro((String)this.serverUrl, (Map)env);
        this.channel = Util.replaceMacro((String)this.channel, (Map)env);
        this.deployKey = Util.replaceMacro((String)this.deployKey, (Map)env);
        if (!this.validateStart(run, listener)) {
            run.setResult(Result.FAILURE);
            return;
        }
        listener.getLogger().format("Package Drone Server URL: %s%n", this.serverUrl);
        String artifacts = env.expand(this.artifacts);
        UploadFiles uploader = new UploadFiles(artifacts, this.excludes, this.defaultExcludes, this.stripPath, run, listener);
        try {
            workspace.act((FilePath.FileCallable)uploader);
        }
        finally {
            uploader.close();
            if (uploader.isFailed() && this.failsAsUpload) {
                run.setResult(Result.FAILURE);
            }
        }
        run.addAction((Action)new BuildData(this.serverUrl, this.channel, uploader.artifacts));
    }

    private boolean validateStart(Run<?, ?> run, TaskListener listener) {
        if (this.serverUrl == null || this.serverUrl.isEmpty()) {
            listener.fatalError(run.getDisplayName() + ": Server URL is empty");
            return false;
        }
        if (this.channel == null || this.channel.isEmpty()) {
            listener.fatalError(run.getDisplayName() + ": Channel ID/Name is empty");
            return false;
        }
        if (this.deployKey == null || this.deployKey.isEmpty()) {
            listener.fatalError(run.getDisplayName() + ": Deploy key is empty");
            return false;
        }
        return true;
    }

    private final class UploadFiles
    extends MasterToSlaveFileCallable<List<String>>
    implements Closeable {
        private static final long serialVersionUID = 1L;
        private final String includes;
        private final String excludes;
        private final boolean defaultExcludes;
        private final Run<?, ?> run;
        private final DefaultHttpClient httpclient;
        private final TaskListener listener;
        private final Map<String, String> artifacts = new HashMap<String, String>();
        private final boolean stripPath;
        private boolean failed;

        public boolean isFailed() {
            return this.failed;
        }

        UploadFiles(String includes, String excludes, boolean defaultExcludes, boolean stripPath, Run<?, ?> run, TaskListener listener) {
            this.includes = includes;
            this.excludes = excludes;
            this.defaultExcludes = defaultExcludes;
            this.stripPath = stripPath;
            this.run = run;
            this.listener = listener;
            this.httpclient = new DefaultHttpClient();
        }

        @Override
        public void close() {
            this.httpclient.getConnectionManager().shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> invoke(File basedir, VirtualChannel channel) throws IOException, InterruptedException {
            LinkedList<String> result = new LinkedList<String>();
            FileSet fileSet = Util.createFileSet((File)basedir, (String)this.includes, (String)this.excludes);
            fileSet.setDefaultexcludes(this.defaultExcludes);
            String[] includedFiles = fileSet.getDirectoryScanner().getIncludedFiles();
            if (includedFiles.length == 0 && !DroneRecorder.this.isAllowEmptyArchive()) {
                this.run.setResult(Result.FAILURE);
            }
            AbstractUploader uploader = DroneRecorder.this.uploadV3 ? new UploaderV3((HttpClient)this.httpclient, this.run, this.listener, DroneRecorder.this.serverUrl, DroneRecorder.this.deployKey, DroneRecorder.this.channel) : new UploaderV2((HttpClient)this.httpclient, this.run, this.listener, DroneRecorder.this.serverUrl, DroneRecorder.this.deployKey, DroneRecorder.this.channel);
            try {
                for (String f : includedFiles) {
                    File file = new File(basedir, f);
                    String filename = this.stripPath ? file.getName() : f;
                    uploader.upload(file, filename);
                }
                this.failed = !uploader.complete();
                LinkedList<String> linkedList = result;
                return linkedList;
            }
            finally {
                uploader.close();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Package Drone Deployer";
        }

        public FormValidation doCheckArtifacts(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }
    }
}

