/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.pm.jenkins;

import com.google.common.io.CharStreams;
import de.dentrassi.pm.jenkins.Uploader;
import hudson.model.Run;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import jenkins.model.Jenkins;
import org.apache.http.HttpEntity;

public abstract class AbstractUploader
implements Uploader {
    protected static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected final Run<?, ?> run;

    public AbstractUploader(Run<?, ?> run) {
        this.run = run;
    }

    protected void fillProperties(Map<String, String> properties) {
        String jenkinsUrl = Jenkins.getInstance().getRootUrl();
        if (jenkinsUrl != null) {
            String url = jenkinsUrl + this.run.getUrl();
            properties.put("jenkins:buildUrl", url);
        }
        properties.put("jenkins:timestamp", DATE_FORMATTER.format(this.run.getTime()));
        properties.put("jenkins:buildId", this.run.getId());
        properties.put("jenkins:buildNumber", String.valueOf(this.run.getNumber()));
        properties.put("jenkins:jobName", this.run.getParent().getFullName());
    }

    protected static String makeString(HttpEntity entity) throws IOException {
        InputStreamReader reader = new InputStreamReader(entity.getContent(), UTF_8);
        try {
            String string = CharStreams.toString((Readable)reader).trim();
            return string;
        }
        finally {
            reader.close();
        }
    }

    static {
        DATE_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

