/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.jenkins.plugins.serenarapublisher;

import com.urbancode.commons.util.https.OpenSSLProtocolSocketFactory;
import java.io.Serializable;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;

public class UrbanDeploySite
implements Serializable {
    private static final long serialVersionUID = -8723534991244260459L;
    private String profileName;
    private String url;
    private String user;
    private String password;

    public UrbanDeploySite() {
    }

    public UrbanDeploySite(String profileName, String url, String user, String password) {
        this.profileName = profileName;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public String getDisplayName() {
        if (StringUtils.isEmpty((String)this.profileName)) {
            return this.url;
        }
        return this.profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        if (this.url != null) {
            this.url = this.url.replaceAll("\\\\", "/");
        }
        while (this.url != null && this.url.endsWith("/")) {
            this.url = this.url.substring(0, this.url.length() - 1);
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void verifyConnection() throws Exception {
        URI uri = UriBuilder.fromPath((String)this.url).path("rest").path("state").build(new Object[0]);
        this.executeJSONGet(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeJSONGet(URI uri) throws Exception {
        String result = null;
        HttpClient httpClient = new HttpClient();
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            OpenSSLProtocolSocketFactory socketFactory = new OpenSSLProtocolSocketFactory();
            Protocol https = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
            Protocol.registerProtocol((String)"https", (Protocol)https);
        }
        GetMethod method = new GetMethod(uri.toString());
        try {
            HttpClientParams params = httpClient.getParams();
            params.setAuthenticationPreemptive(true);
            UsernamePasswordCredentials clientCredentials = new UsernamePasswordCredentials(this.user, this.password);
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)clientCredentials);
            int responseCode = httpClient.executeMethod((HttpMethod)method);
            if (responseCode == 401) {
                throw new Exception("Error connecting to SerenaRA: Invalid user and/or password");
            }
            if (responseCode != 200) {
                throw new Exception("Error connecting to SerenaRA: " + responseCode);
            }
            result = method.getResponseBodyAsString();
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    public String executeJSONPut(URI uri, String putContents) throws Exception {
        String result = null;
        HttpClient httpClient = new HttpClient();
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            OpenSSLProtocolSocketFactory socketFactory = new OpenSSLProtocolSocketFactory();
            Protocol https = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
            Protocol.registerProtocol((String)"https", (Protocol)https);
        }
        PutMethod method = new PutMethod(uri.toString());
        method.setRequestBody(putContents);
        method.setRequestHeader("Content-Type", "application/json");
        method.setRequestHeader("charset", "utf-8");
        try {
            HttpClientParams params = httpClient.getParams();
            params.setAuthenticationPreemptive(true);
            UsernamePasswordCredentials clientCredentials = new UsernamePasswordCredentials(this.user, this.password);
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)clientCredentials);
            int responseCode = httpClient.executeMethod((HttpMethod)method);
            if (responseCode != 200) {
                throw new Exception("SerenaRA returned error code: " + responseCode);
            }
            result = method.getResponseBodyAsString();
        }
        catch (Exception e) {
            throw new Exception("Error connecting to SerenaRA: " + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    public String executeJSONPost(URI uri) throws Exception {
        String result = null;
        HttpClient httpClient = new HttpClient();
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            OpenSSLProtocolSocketFactory socketFactory = new OpenSSLProtocolSocketFactory();
            Protocol https = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
            Protocol.registerProtocol((String)"https", (Protocol)https);
        }
        PostMethod method = new PostMethod(uri.toString());
        method.setRequestHeader("charset", "utf-8");
        try {
            HttpClientParams params = httpClient.getParams();
            params.setAuthenticationPreemptive(true);
            UsernamePasswordCredentials clientCredentials = new UsernamePasswordCredentials(this.user, this.password);
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)clientCredentials);
            int responseCode = httpClient.executeMethod((HttpMethod)method);
            if (responseCode != 200) {
                throw new Exception("SerenaRA returned error code: " + responseCode);
            }
            result = method.getResponseBodyAsString();
        }
        catch (Exception e) {
            throw new Exception("Error connecting to SerenaRA: " + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }
}

