/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.jenkins.plugins.serenarapublisher;

import com.urbancode.ds.jenkins.plugins.serenarapublisher.UrbanDeployPublisher;
import com.urbancode.ds.jenkins.plugins.serenarapublisher.UrbanDeploySite;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteList;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrbanDeployPublisherDescriptor
extends BuildStepDescriptor<Publisher> {
    private final CopyOnWriteList<UrbanDeploySite> sites = new CopyOnWriteList();

    public UrbanDeployPublisherDescriptor() {
        super(UrbanDeployPublisher.class);
        this.load();
    }

    public String getDisplayName() {
        return "Publish artifacts to Serena RA";
    }

    public String getHelpFile() {
        return "/plugin/serenarapublisher/help.html";
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public UrbanDeploySite[] getSites() {
        Iterator it = this.sites.iterator();
        int size = 0;
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return (UrbanDeploySite[])this.sites.toArray((Object[])new UrbanDeploySite[size]);
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        this.sites.replaceBy((Collection)req.bindParametersToList(UrbanDeploySite.class, "ud."));
        this.save();
        return true;
    }

    public Notifier newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String deployProc;
        String deployEnv;
        String deployApp;
        String fileExcludePatterns;
        String fileIncludePatterns;
        String baseDir;
        String directoryOffset;
        String versionName;
        String component;
        Boolean skip = "on".equalsIgnoreCase(req.getParameter("urbandeploypublisher.skip"));
        Boolean deploy = "on".equalsIgnoreCase(req.getParameter("urbandeploypublisher.deploy"));
        String siteName = req.getParameter("urbandeploypublisher.siteName");
        if (siteName != null) {
            siteName = Util.fixNull((String)req.getParameter("urbandeploypublisher.siteName").trim());
        }
        if ((component = req.getParameter("urbandeploypublisher.component")) != null) {
            component = Util.fixNull((String)req.getParameter("urbandeploypublisher.component").trim());
        }
        if ((versionName = req.getParameter("urbandeploypublisher.versionName")) != null) {
            versionName = Util.fixNull((String)req.getParameter("urbandeploypublisher.versionName").trim());
        }
        if ((directoryOffset = req.getParameter("urbandeploypublisher.directoryOffset")) != null) {
            directoryOffset = Util.fixNull((String)req.getParameter("urbandeploypublisher.directoryOffset").trim());
        }
        if ((baseDir = req.getParameter("urbandeploypublisher.baseDir")) != null) {
            baseDir = Util.fixNull((String)req.getParameter("urbandeploypublisher.baseDir").trim());
        }
        if ((fileIncludePatterns = req.getParameter("urbandeploypublisher.fileIncludePatterns")) != null) {
            fileIncludePatterns = Util.fixNull((String)req.getParameter("urbandeploypublisher.fileIncludePatterns").trim());
        }
        if ((fileExcludePatterns = req.getParameter("urbandeploypublisher.fileExcludePatterns")) != null) {
            fileExcludePatterns = Util.fixNull((String)req.getParameter("urbandeploypublisher.fileExcludePatterns").trim());
        }
        if ((deployApp = req.getParameter("urbandeploypublisher.deployApp")) != null) {
            deployApp = Util.fixNull((String)req.getParameter("urbandeploypublisher.deployApp").trim());
        }
        if ((deployEnv = req.getParameter("urbandeploypublisher.deployEnv")) != null) {
            deployEnv = Util.fixNull((String)req.getParameter("urbandeploypublisher.deployEnv").trim());
        }
        if ((deployProc = req.getParameter("urbandeploypublisher.deployProc")) != null) {
            deployProc = Util.fixNull((String)req.getParameter("urbandeploypublisher.deployProc").trim());
        }
        UrbanDeployPublisher notif = new UrbanDeployPublisher(siteName, component, versionName, directoryOffset, baseDir, fileIncludePatterns, fileExcludePatterns, skip, deploy, deployApp, deployEnv, deployProc);
        return notif;
    }

    public void doTestConnection(StaplerRequest req, StaplerResponse rsp, final @QueryParameter(value="ud.url") String url, final @QueryParameter(value="ud.user") String user, final @QueryParameter(value="ud.password") String password) throws IOException, ServletException {
        new FormFieldValidator(req, rsp, true){

            protected void check() throws IOException, ServletException {
                try {
                    UrbanDeploySite site = new UrbanDeploySite(null, url, user, password);
                    site.verifyConnection();
                    this.ok("Success");
                }
                catch (Exception e) {
                    this.error(e.getMessage());
                }
            }
        }.process();
    }
}

