/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.jenkins.plugins.serenarapublisher;

import com.urbancode.ds.jenkins.plugins.serenarapublisher.PublishArtifactsCallable;
import com.urbancode.ds.jenkins.plugins.serenarapublisher.UrbanDeployPublisherDescriptor;
import com.urbancode.ds.jenkins.plugins.serenarapublisher.UrbanDeploySite;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrbanDeployPublisher
extends Notifier {
    @Extension
    public static final UrbanDeployPublisherDescriptor DESCRIPTOR = new UrbanDeployPublisherDescriptor();
    private String siteName;
    private String component;
    private String baseDir;
    private String directoryOffset;
    private String fileIncludePatterns;
    private String fileExcludePatterns;
    private String versionName;
    private Boolean skip = false;
    private Boolean deploy = false;
    private String deployApp;
    private String deployEnv;
    private String deployProc;
    private Map<String, String> envMap = null;

    public UrbanDeployPublisher(String siteName, String component, String versionName, String directoryOffset, String baseDir, String fileIncludePatterns, String fileExcludePatterns, Boolean skip, Boolean deploy, String deployApp, String deployEnv, String deployProc) {
        this.component = component;
        this.versionName = versionName;
        this.baseDir = baseDir;
        this.directoryOffset = directoryOffset;
        this.fileIncludePatterns = fileIncludePatterns;
        this.fileExcludePatterns = fileExcludePatterns;
        this.siteName = siteName;
        this.skip = skip;
        this.deploy = deploy;
        this.deployApp = deployApp;
        this.deployEnv = deployEnv;
        this.deployProc = deployProc;
    }

    public String getSiteName() {
        UrbanDeploySite[] sites;
        String name = this.siteName;
        if (name == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            name = sites[0].getProfileName();
        }
        return name;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getBaseDir() {
        if (this.baseDir == null || this.baseDir.length() == 0) {
            this.baseDir = "${WORKSPACE}";
        }
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getDirectoryOffset() {
        return this.directoryOffset;
    }

    public void setDirectoryOffset(String directoryOffset) {
        this.directoryOffset = directoryOffset;
    }

    public String getFileIncludePatterns() {
        if (this.fileIncludePatterns == null || this.fileIncludePatterns.trim().length() == 0) {
            this.fileIncludePatterns = "**/*";
        }
        return this.fileIncludePatterns;
    }

    public void setFileIncludePatterns(String fileIncludePatterns) {
        this.fileIncludePatterns = fileIncludePatterns;
    }

    public String getFileExcludePatterns() {
        return this.fileExcludePatterns;
    }

    public void setFileExcludePatterns(String fileExcludePatterns) {
        this.fileExcludePatterns = fileExcludePatterns;
    }

    public String getVersionName() {
        if (this.versionName == null || this.versionName.length() == 0) {
            this.versionName = "${BUILD_NUMBER}";
        }
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setDeploy(boolean deploy) {
        this.deploy = deploy;
    }

    public boolean isDeploy() {
        return this.deploy;
    }

    public void setDeployApp(String deployApp) {
        this.deployApp = deployApp;
    }

    public String getDeployApp() {
        return this.deployApp;
    }

    public void setDeployEnv(String deployEnv) {
        this.deployEnv = deployEnv;
    }

    public String getDeployEnv() {
        return this.deployEnv;
    }

    public void setDeployProc(String deployProc) {
        this.deployProc = deployProc;
    }

    public String getDeployProc() {
        return this.deployProc;
    }

    public UrbanDeploySite getSite() {
        UrbanDeploySite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (UrbanDeploySite site : sites) {
            if (!site.getDisplayName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.isSkip()) {
            listener.getLogger().println("Skip artifacts upload to SerenaRA - step disabled.");
        } else if (build.getResult() == Result.FAILURE || build.getResult() == Result.ABORTED) {
            listener.getLogger().println("Skip artifacts upload to SerenaRA - build failed or aborted.");
        } else {
            this.envMap = build.getEnvironment((TaskListener)listener);
            String resolvedComponent = this.resolveVariables(this.getComponent());
            String resolvedBaseDir = this.resolveVariables(this.getBaseDir());
            String resolvedVersionName = this.resolveVariables(this.getVersionName());
            String resolvedFileIncludePatterns = this.resolveVariables(this.fileIncludePatterns);
            String resolvedFileExcludePatterns = this.resolveVariables(this.fileExcludePatterns);
            String resolvedDirectoryOffset = this.resolveVariables(this.directoryOffset);
            UrbanDeploySite udSite = this.getSite();
            try {
                PublishArtifactsCallable task = new PublishArtifactsCallable(resolvedBaseDir, resolvedDirectoryOffset, udSite, resolvedFileIncludePatterns, resolvedFileExcludePatterns, resolvedComponent, resolvedVersionName, listener);
                launcher.getChannel().call((Callable)task);
                if (this.isDeploy()) {
                    if (this.getDeployApp() == null || this.getDeployApp().trim().length() == 0) {
                        throw new Exception("Deploy Application is a required field if Deploy is selected!");
                    }
                    if (this.getDeployEnv() == null || this.getDeployEnv().trim().length() == 0) {
                        throw new Exception("Deploy Environment is a required field if Deploy is selected!");
                    }
                    if (this.getDeployProc() == null || this.getDeployProc().trim().length() == 0) {
                        throw new Exception("Deploy Process is a required field if Deploy is selected!");
                    }
                    listener.getLogger().println("Starting deployment of " + this.getDeployApp() + " in " + this.getDeployEnv());
                    this.createProcessRequest(udSite, resolvedComponent, resolvedVersionName);
                }
            }
            catch (Throwable th) {
                th.printStackTrace(listener.error("Failed to upload files" + th));
                build.setResult(Result.UNSTABLE);
            }
        }
        return true;
    }

    private void createProcessRequest(UrbanDeploySite site, String componentName, String versionName) throws Exception {
        URI uri = UriBuilder.fromPath((String)site.getUrl()).path("cli").path("applicationProcessRequest").path("request").build(new Object[0]);
        String json = "{\"application\":\"" + this.getDeployApp() + "\",\"applicationProcess\":\"" + this.getDeployProc() + "\",\"environment\":\"" + this.getDeployEnv() + "\",\"versions\":[{\"version\":\"" + versionName + "\",\"component\":\"" + componentName + "\"}]}";
        site.executeJSONPut(uri, json);
    }

    private String resolveVariables(String input) {
        String result = input;
        if (input != null && input.trim().length() > 0) {
            Pattern pattern = Pattern.compile("\\$\\{[^}]*}");
            Matcher matcher = pattern.matcher(result);
            while (matcher.find()) {
                String key = result.substring(matcher.start() + 2, matcher.end() - 1);
                if (!this.envMap.containsKey(key)) continue;
                result = matcher.replaceFirst(Matcher.quoteReplacement(this.envMap.get(key)));
                matcher.reset(result);
            }
        }
        return result;
    }
}

