/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.jenkins.plugins.serenarapublisher;

import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.ds.jenkins.plugins.serenarapublisher.UrbanDeploySite;
import com.urbancode.vfs.client.Client;
import com.urbancode.vfs.common.ClientChangeSet;
import com.urbancode.vfs.common.ClientPathEntry;
import hudson.model.BuildListener;
import hudson.remoting.Callable;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashSet;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishArtifactsCallable
implements Callable<Boolean, Exception> {
    private static final long serialVersionUID = 34598734957L;
    private final String resolvedBaseDir;
    private final String resolvedDirectoryOffset;
    private final UrbanDeploySite udSite;
    private final String resolvedFileIncludePatterns;
    private final String resolvedFileExcludePatterns;
    private final String resolvedComponent;
    private final String resolvedVersionName;
    private final BuildListener listener;

    public PublishArtifactsCallable(String resolvedBaseDir, String resolvedDirectoryOffset, UrbanDeploySite udSite, String resolvedFileIncludePatterns, String resolvedFileExcludePatterns, String resolvedComponent, String resolvedVersionName, BuildListener listener) {
        this.resolvedBaseDir = resolvedBaseDir;
        this.resolvedDirectoryOffset = resolvedDirectoryOffset;
        this.udSite = udSite;
        this.resolvedFileIncludePatterns = resolvedFileIncludePatterns;
        this.resolvedFileExcludePatterns = resolvedFileExcludePatterns;
        this.resolvedComponent = resolvedComponent;
        this.resolvedVersionName = resolvedVersionName;
        this.listener = listener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean call() throws Exception {
        File workDir = new File(this.resolvedBaseDir);
        if (!workDir.exists()) {
            throw new Exception("Base artifact directory " + workDir.toString() + " does not exist!");
        }
        if (this.resolvedDirectoryOffset != null && this.resolvedDirectoryOffset.trim().length() > 0) {
            workDir = new File(workDir, this.resolvedDirectoryOffset.trim());
        }
        HashSet<String> includesSet = new HashSet<String>();
        HashSet<String> excludesSet = new HashSet<String>();
        for (String pattern : this.resolvedFileIncludePatterns.split("\n")) {
            if (pattern == null || pattern.trim().length() <= 0) continue;
            includesSet.add(pattern.trim());
        }
        if (this.resolvedFileExcludePatterns != null) {
            for (String pattern : this.resolvedFileExcludePatterns.split("\n")) {
                if (pattern == null || pattern.trim().length() <= 0) continue;
                excludesSet.add(pattern.trim());
            }
        }
        String[] includesArray = new String[includesSet.size()];
        includesArray = includesSet.toArray(includesArray);
        String[] excludesArray = new String[excludesSet.size()];
        excludesArray = excludesSet.toArray(excludesArray);
        this.listener.getLogger().println("Connecting to " + this.udSite.getUrl());
        this.createComponentVersion(this.udSite, this.resolvedComponent, this.resolvedVersionName, this.listener);
        this.listener.getLogger().println("Working Directory: " + workDir.getPath());
        this.listener.getLogger().println("Includes: " + this.resolvedFileIncludePatterns);
        this.listener.getLogger().println("Excludes: " + (this.resolvedFileExcludePatterns == null ? "" : this.resolvedFileExcludePatterns));
        Client client = null;
        String stageId = null;
        try {
            ClientPathEntry[] entries = ClientPathEntry.createPathEntriesFromFileSystem((File)workDir, (String[])includesArray, (String[])excludesArray, (FileListerBuilder.Directories)FileListerBuilder.Directories.INCLUDE_ALL, (FileListerBuilder.Permissions)FileListerBuilder.Permissions.BEST_EFFORT, (FileListerBuilder.Symlinks)FileListerBuilder.Symlinks.AS_LINK, (String)"SHA-256");
            this.listener.getLogger().println("Invoke vfs client...");
            client = new Client(this.udSite.getUrl() + "/vfs", null, null);
            stageId = client.createStagingDirectory();
            this.listener.getLogger().println("Created staging directory: " + stageId);
            if (entries.length > 0) {
                for (ClientPathEntry entry : entries) {
                    File entryFile = new File(workDir, entry.getPath());
                    this.listener.getLogger().println("Adding " + entry.getPath() + " to staging directory...");
                    client.addFileToStagingDirectory(stageId, entry.getPath(), entryFile);
                }
                String repositoryId = this.getComponentRepositoryId(this.udSite, this.resolvedComponent);
                ClientChangeSet changeSet = ClientChangeSet.newChangeSet((String)repositoryId, (String)this.udSite.getUser(), (String)"Uploaded by Jenkins", (ClientPathEntry[])entries);
                this.listener.getLogger().println("Committing change set...");
                String changeSetId = client.commitStagingDirectory(stageId, changeSet);
                this.listener.getLogger().println("Created change set: " + changeSetId);
                this.listener.getLogger().println("Labeling change set with label: " + this.resolvedVersionName);
                client.labelChangeSet(repositoryId, URLDecoder.decode(changeSetId, "UTF-8"), this.resolvedVersionName, this.udSite.getUser(), "Associated with version " + this.resolvedVersionName);
                this.listener.getLogger().println("Done labeling change set!");
            } else {
                this.listener.getLogger().println("Did not find any files to upload!");
            }
            if (client == null) return true;
            if (stageId == null) return true;
        }
        catch (Throwable e) {
            try {
                throw new Exception("Failed to upload files", e);
            }
            catch (Throwable throwable) {
                if (client == null) throw throwable;
                if (stageId == null) throw throwable;
                try {
                    client.deleteStagingDirectory(stageId);
                    this.listener.getLogger().println("Deleted staging directory: " + stageId);
                    throw throwable;
                }
                catch (Exception e2) {
                    this.listener.getLogger().println("Failed to delete staging directory " + stageId + ": " + e2.getMessage());
                }
                throw throwable;
            }
        }
        try {
            client.deleteStagingDirectory(stageId);
            this.listener.getLogger().println("Deleted staging directory: " + stageId);
            return true;
        }
        catch (Exception e) {
            this.listener.getLogger().println("Failed to delete staging directory " + stageId + ": " + e.getMessage());
            return true;
        }
    }

    private String getComponentRepositoryId(UrbanDeploySite site, String componentName) throws Exception {
        String result = null;
        URI uri = UriBuilder.fromPath((String)site.getUrl()).path("rest").path("deploy").path("component").path(componentName).build(new Object[0]);
        String componentContent = site.executeJSONGet(uri);
        JSONArray properties = new JSONObject(componentContent).getJSONArray("properties");
        if (properties != null) {
            for (int i = 0; i < properties.length(); ++i) {
                JSONObject propertyJson = properties.getJSONObject(i);
                String propName = propertyJson.getString("name");
                String propValue = propertyJson.getString("value");
                if (!"code_station/repository".equalsIgnoreCase(propName)) continue;
                result = propValue.trim();
                break;
            }
        }
        return result;
    }

    private void createComponentVersion(UrbanDeploySite site, String componentName, String versionName, BuildListener listener) throws Exception {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)site.getUrl()).path("cli").path("version").path("createVersion");
        uriBuilder.queryParam("component", new Object[]{componentName});
        uriBuilder.queryParam("name", new Object[]{versionName});
        URI uri = uriBuilder.build(new Object[0]);
        listener.getLogger().println("Creating new version \"" + versionName + "\" on component " + componentName + "...");
        listener.getLogger().println("Calling URI \"" + uri.toString() + "\"...");
        site.executeJSONPost(uri);
        listener.getLogger().println("Successfully created new component version.");
    }
}

