/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.utils;

import com.splunk.splunkjenkins.Constants;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.RemoteUtils;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import hudson.util.ByteArrayOutputStream2;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.JenkinsJVM;
import org.jenkinsci.remoting.RoleChecker;

public class LogFileCallable
implements FilePath.FileCallable<Integer> {
    private static final long serialVersionUID = 5303809353063980298L;
    private static final Logger LOG = Logger.getLogger(LogFileCallable.class.getName());
    private static final String TIMEOUT_NAME = LogFileCallable.class.getName() + ".timeout";
    private final int WAIT_MINUTES = Integer.getInteger(TIMEOUT_NAME, 5);
    private final String baseName;
    private final String buildUrl;
    private final Map eventCollectorProperty;
    private final boolean sendFromSlave;
    private final long maxFileSize;
    private boolean enabledSplunkConfig = false;

    public LogFileCallable(String baseName, String buildUrl, Map eventCollectorProperty, boolean sendFromSlave, long maxFileSize) {
        this.baseName = baseName;
        this.eventCollectorProperty = eventCollectorProperty;
        this.buildUrl = buildUrl;
        this.sendFromSlave = sendFromSlave;
        this.maxFileSize = maxFileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendFiles(FilePath[] paths) {
        int eventCount = 0;
        for (FilePath path : paths) {
            try {
                if (path.isDirectory()) continue;
                if (this.sendFromSlave) {
                    LOG.log(Level.INFO, "uploading from agent:" + path.getName());
                    LOG.log(Level.FINE, "sent in " + (eventCount += ((Integer)path.act((FilePath.FileCallable)this)).intValue()) + " batches");
                    continue;
                }
                try (InputStream in = path.read();){
                    LOG.log(Level.FINE, "uploading from built-in node:" + path.getName());
                    eventCount += this.send(path.getRemote(), in).intValue();
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "archive file failed", e);
            }
        }
        return eventCount;
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    public Integer send(String fileName, InputStream input) throws IOException, InterruptedException {
        int n;
        String ws_posix_path;
        Object sourceName;
        long throttleSize = SplunkJenkinsInstallation.get().getMaxEventsBatchSize();
        if (!SplunkJenkinsInstallation.get().isRawEventEnabled()) {
            throttleSize /= 2L;
        }
        if (((String)(sourceName = fileName.replace("\\", "/"))).startsWith(ws_posix_path = this.baseName.replace("\\", "/"))) {
            sourceName = ((String)sourceName).substring(ws_posix_path.length() + 1);
        }
        sourceName = this.buildUrl + (String)sourceName;
        boolean jsonFile = fileName.endsWith(".json");
        EventType eventType = EventType.FILE;
        if (jsonFile && SplunkJenkinsInstallation.get().isRawEventEnabled()) {
            throttleSize = this.maxFileSize;
            eventType = EventType.JSON_FILE;
        }
        ByteArrayOutputStream2 logText = new ByteArrayOutputStream2(Constants.MIN_BUFFER_SIZE);
        long totalSize = 0L;
        Integer count = 0;
        byte[] buffer = new byte[Constants.MIN_BUFFER_SIZE];
        while ((n = input.read(buffer)) >= 0) {
            totalSize += (long)n;
            for (int i = 0; i < n; ++i) {
                logText.write((int)buffer[i]);
                if (buffer[i] != 10 || (long)logText.size() <= throttleSize) continue;
                eventType = EventType.FILE;
                this.flushLog((String)sourceName, (ByteArrayOutputStream)logText, eventType);
                Integer n2 = count;
                count = count + 1;
            }
            if (this.maxFileSize == 0L || totalSize <= this.maxFileSize) continue;
            logText.write(("file truncated to size:" + totalSize).getBytes(StandardCharsets.UTF_8));
            SplunkLogService.getInstance().send((Object)((String)sourceName + " too large"), "large_file");
            break;
        }
        if (logText.size() > 0) {
            this.flushLog((String)sourceName, (ByteArrayOutputStream)logText, eventType);
            Integer n3 = count;
            count = count + 1;
        }
        return count;
    }

    private void initSplunkins() {
        if (this.enabledSplunkConfig) {
            return;
        }
        RemoteUtils.initSplunkConfigOnAgent(this.eventCollectorProperty);
        this.enabledSplunkConfig = true;
    }

    private void flushLog(String source, ByteArrayOutputStream out, EventType eventType) {
        try {
            String text = out.toString("UTF-8");
            SoftReference<String> textRef = new SoftReference<String>(text);
            SplunkLogService.getInstance().send(textRef, eventType, source);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        out.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        if (!JenkinsJVM.isJenkinsJVM()) {
            this.initSplunkins();
        }
        try (FileInputStream input = new FileInputStream(f);){
            long expireTime = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(this.WAIT_MINUTES);
            int count = this.send(f.getAbsolutePath(), input);
            while (SplunkLogService.getInstance().getQueueSize() > 0L && System.currentTimeMillis() < expireTime) {
                Thread.sleep(500L);
            }
            if (System.currentTimeMillis() > expireTime) {
                LOG.log(Level.SEVERE, "sending file timeout in " + this.WAIT_MINUTES + " minutes, please adjust the value by passing -D" + TIMEOUT_NAME + "=minutes to slave jvm parameter");
            }
            SplunkLogService.getInstance().stopWorker();
            SplunkLogService.getInstance().releaseConnection();
            Integer n = count;
            return n;
        }
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }
}

