/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.listeners;

import com.splunk.splunkjenkins.listeners.Messages;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import jenkins.security.SecurityListener;
import org.acegisecurity.userdetails.UserDetails;

@Extension
public class UserSecurityListener
extends SecurityListener {
    protected void authenticated(@NonNull UserDetails details) {
        LogEventHelper.logUserAction(details.getUsername(), "authenticated");
    }

    protected void failedToAuthenticate(@NonNull String username) {
        LogEventHelper.logUserAction(this.getFullName(username), Messages.audit_user_fail_auth());
    }

    protected void loggedIn(@NonNull String username) {
        LogEventHelper.logUserAction(this.getFullName(username), Messages.audit_user_login());
    }

    protected void failedToLogIn(@NonNull String username) {
    }

    protected void loggedOut(@NonNull String username) {
        LogEventHelper.logUserAction(this.getFullName(username), Messages.audit_user_logout());
    }

    private String getFullName(String username) {
        User user = User.get((String)username);
        return user.getFullName();
    }
}

