/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.listeners;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Extension
public class LoggingQueueListener
extends QueueListener {
    private static final Cache<Long, Float> cache = CacheBuilder.newBuilder().maximumSize(3000L).build();
    private static final ConcurrentHashMap<Long, Long> queuePhase = new ConcurrentHashMap();
    private static final String QUEUE_UNKNOWN_MSG = "???";

    public void onEnterWaiting(Queue.WaitingItem wi) {
        this.sendToSplunkOnEnter(wi.task, wi.getId(), "enqueue");
    }

    public void onLeaveWaiting(Queue.WaitingItem wi) {
        String causeOfWaiting = wi.getWhy();
        if (QUEUE_UNKNOWN_MSG.equals(causeOfWaiting)) {
            causeOfWaiting = "waiting probably caused by quiet period";
        }
        this.sendToSplunkOnLeft(wi.task, wi.getId(), "waiting", causeOfWaiting, wi.getInQueueSince());
    }

    public void onEnterBlocked(Queue.BlockedItem bi) {
        this.sendToSplunkOnEnter(bi.task, bi.getId(), "blocked");
    }

    public void onLeaveBlocked(Queue.BlockedItem bi) {
        String causeOfBlocked = bi.getWhy();
        if (QUEUE_UNKNOWN_MSG.equals(causeOfBlocked)) {
            causeOfBlocked = "waiting probably caused by QueueTaskDispatcher";
        }
        this.sendToSplunkOnLeft(bi.task, bi.getId(), "blocked", causeOfBlocked, bi.getInQueueSince());
    }

    public void onEnterBuildable(Queue.BuildableItem bi) {
        this.sendToSplunkOnEnter(bi.task, bi.getId(), "buildable");
    }

    public void onLeaveBuildable(Queue.BuildableItem bi) {
        String causeOfWaiting = bi.getWhy();
        if (QUEUE_UNKNOWN_MSG.equals(causeOfWaiting)) {
            causeOfWaiting = "waiting probably caused by lack of free executors";
        }
        this.sendToSplunkOnLeft(bi.task, bi.getId(), "buildable", causeOfWaiting, bi.getInQueueSince());
    }

    public void onLeft(Queue.LeftItem li) {
        Float queueTime = this.sendToSplunkOnLeft(li.task, li.getId(), "dequeue", li.getWhy(), li.getInQueueSince());
        queuePhase.remove(li.getId());
        cache.put((Object)li.getId(), (Object)queueTime);
    }

    public String getTaskName(Queue.Task task) {
        if (task == null) {
            return "n/a";
        }
        return task.getUrl();
    }

    public static Float getQueueTime(Long Id) {
        Float queueTime = (Float)cache.getIfPresent((Object)Id);
        if (queueTime == null) {
            queueTime = Float.valueOf(0.0f);
        }
        return queueTime;
    }

    private Map getCommonEvents(String type, Long id, String itemName) {
        Map<String, Object> event = LogEventHelper.getMasterStats();
        event.put("type", type);
        event.put("event_tag", "queue");
        event.put("queue_id", id);
        event.put("item", itemName);
        return event;
    }

    private void sendToSplunkOnEnter(Queue.Task task, Long id, String eventType) {
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.QUEUE_INFO)) {
            return;
        }
        String name = this.getTaskName(task);
        if (SplunkJenkinsInstallation.get().isJobIgnored(name)) {
            return;
        }
        queuePhase.put(id, System.currentTimeMillis());
        Object eventTypeEnqueue = eventType.equals("enqueue") ? eventType : "enqueue_" + eventType;
        Map event = this.getCommonEvents((String)eventTypeEnqueue, id, name);
        SplunkLogService.getInstance().send((Object)event, EventType.QUEUE_INFO);
    }

    private Float sendToSplunkOnLeft(Queue.Task task, Long id, String eventType, String message, Long inQueueSince) {
        float queueTimeDuration;
        Object durationName;
        Object eventTypeDequeue;
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.QUEUE_INFO)) {
            return Float.valueOf(0.0f);
        }
        String name = this.getTaskName(task);
        if (SplunkJenkinsInstallation.get().isJobIgnored(name)) {
            return Float.valueOf(0.0f);
        }
        if (eventType.equals("dequeue")) {
            eventTypeDequeue = eventType;
            durationName = "queue_time";
            queueTimeDuration = this.getQueueTime(id, inQueueSince).floatValue();
        } else {
            eventTypeDequeue = "dequeue_" + eventType;
            durationName = eventType + "_time";
            queueTimeDuration = this.getDurationInQueuePhase(id).floatValue();
        }
        Map event = this.getCommonEvents((String)eventTypeDequeue, id, name);
        event.put(durationName, Float.valueOf(queueTimeDuration));
        event.put("message", message);
        SplunkLogService.getInstance().send((Object)event, EventType.QUEUE_INFO);
        return Float.valueOf(queueTimeDuration);
    }

    private Float getDurationInQueuePhase(Long id) {
        Long startTime = queuePhase.get(id);
        Float durationInPhase = startTime == null ? Float.valueOf(0.0f) : Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f);
        return durationInPhase;
    }

    private Float getQueueTime(Long id, Long inQueueSince) {
        float queueTime = (float)(System.currentTimeMillis() - inQueueSince) / 1000.0f;
        return Float.valueOf(queueTime);
    }

    public static void expire(Long Id) {
        cache.invalidate((Object)Id);
    }
}

