/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.links;

import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.links.LinkSplunkAction;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.TransientActionFactory;

@Extension
public class RunActionFactory
extends TransientActionFactory<Run> {
    public Class<Run> type() {
        return Run.class;
    }

    @NonNull
    public Collection<? extends Action> createFor(@NonNull Run target) {
        Job job = target.getParent();
        LogEventHelper.UrlQueryBuilder builder = new LogEventHelper.UrlQueryBuilder().putIfAbsent("job", job.getFullName()).putIfAbsent("build", "" + target.getNumber());
        File junitFile = new File(target.getRootDir(), "junitResult.xml");
        if (junitFile.exists() || job.getClass().getName().startsWith("hudson.maven.")) {
            builder.putIfAbsent("master", SplunkJenkinsInstallation.get().getMetadataHost());
            String query = builder.build();
            return Collections.singleton(new LinkSplunkAction("testAnalysis", query, "Splunk"));
        }
        String query = builder.putIfAbsent("type", "build").putIfAbsent("host", SplunkJenkinsInstallation.get().getMetadataHost()).build();
        return Collections.singleton(new LinkSplunkAction("build", query, "Splunk"));
    }
}

