/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.splunk.splunkjenkins.Messages;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class SplunkArtifactNotifier
extends Notifier
implements SimpleBuildStep {
    private final String includeFiles;
    private final String excludeFiles;
    private final boolean publishFromSlave;
    private final boolean skipGlobalSplunkArchive;
    private final String sizeLimit;

    @DataBoundConstructor
    public SplunkArtifactNotifier(String includeFiles, String excludeFiles, boolean publishFromSlave, boolean skipGlobalSplunkArchive, String sizeLimit) {
        this.includeFiles = includeFiles;
        this.excludeFiles = excludeFiles;
        this.publishFromSlave = publishFromSlave;
        this.skipGlobalSplunkArchive = skipGlobalSplunkArchive;
        this.sizeLimit = sizeLimit;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        EnvVars envVars = new HashMap();
        try {
            envVars = build.getEnvironment(listener);
        }
        catch (Exception ex) {
            listener.getLogger().println("failed to get env");
        }
        long maxFileSize = LogEventHelper.parseFileSize(this.sizeLimit);
        listener.getLogger().println("sending files at job level, includes:" + this.includeFiles + " excludes:" + this.excludeFiles);
        int eventCount = LogEventHelper.sendFiles(build, workspace, (Map<String, String>)envVars, listener, this.includeFiles, this.excludeFiles, this.publishFromSlave, maxFileSize);
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "sent " + eventCount + " events with file size limit " + maxFileSize);
    }

    public String toString() {
        return "SplunkArtifactNotifier{includeFiles='" + this.includeFiles + "', excludeFiles='" + this.excludeFiles + "', publishFromSlave=" + this.publishFromSlave + ", skipGlobalSplunkArchive=" + this.skipGlobalSplunkArchive + ", sizeLimit='" + this.sizeLimit + "'}";
    }

    public String getIncludeFiles() {
        return this.includeFiles;
    }

    public String getExcludeFiles() {
        return this.excludeFiles;
    }

    public boolean isPublishFromSlave() {
        return this.publishFromSlave;
    }

    public boolean isSkipGlobalSplunkArchive() {
        return this.skipGlobalSplunkArchive;
    }

    public String getSizeLimit() {
        return this.sizeLimit;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SplunArtifactArchive();
        }
    }
}

