/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.cloudbees.workflow.rest.external.ChunkVisitor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class WorkspaceChunkVisitor
extends ChunkVisitor {
    private static final Logger LOG = Logger.getLogger(WorkspaceChunkVisitor.class.getName());
    Map<String, String> workspaceNodes = new HashMap<String, String>();
    String execNodeName = null;
    String execNodeStartId = null;

    public WorkspaceChunkVisitor(@NonNull WorkflowRun run) {
        super(run);
    }

    public void atomNode(@CheckForNull FlowNode before, @NonNull FlowNode atomNode, @CheckForNull FlowNode after, @NonNull ForkScanner scan) {
        try {
            this.recordExecNode(atomNode);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "failed to extract pipeline info", ex);
        }
        super.atomNode(before, atomNode, after, scan);
    }

    private void recordExecNode(FlowNode atomNode) {
        if (this.execNodeName == null) {
            WorkspaceAction workspaceAction;
            StepStartNode nodeStep = this.getPipelineBlockBoundaryStartNode(atomNode, "node");
            if (nodeStep != null && (workspaceAction = (WorkspaceAction)nodeStep.getAction(WorkspaceAction.class)) != null) {
                this.execNodeName = workspaceAction.getNode();
                this.execNodeStartId = nodeStep.getId();
                if (StringUtils.isEmpty((CharSequence)this.execNodeName)) {
                    this.execNodeName = "(built-in)";
                }
                LOG.log(Level.FINE, "found workspace node id={0}, name={1}", new String[]{this.execNodeStartId, this.execNodeName});
            }
        } else if (atomNode instanceof StepStartNode && atomNode.getId().equals(this.execNodeStartId)) {
            this.execNodeName = null;
        }
        if (this.execNodeName != null) {
            this.workspaceNodes.put(atomNode.getId(), this.execNodeName);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private StepStartNode getPipelineBlockBoundaryStartNode(FlowNode atomNode, String functionName) {
        StepStartNode startNode = null;
        if (atomNode instanceof StepEndNode && ((StepEndNode)atomNode).getStartNode() != null && ((StepStartNode)((StepEndNode)atomNode).getStartNode()).getDescriptor() != null && ((StepStartNode)((StepEndNode)atomNode).getStartNode()).getDescriptor().getFunctionName().equals(functionName)) {
            StepStartNode blockStart = (StepStartNode)((StepEndNode)atomNode).getStartNode();
            if (blockStart.getParents().size() < 1) {
                return null;
            }
            FlowNode boundaryNode = (FlowNode)blockStart.getParents().get(0);
            if (boundaryNode instanceof StepStartNode) {
                startNode = (StepStartNode)boundaryNode;
            } else if (boundaryNode instanceof FlowStartNode) {
                startNode = blockStart;
            }
        }
        return startNode;
    }

    public Map<String, String> getWorkspaceNodes() {
        return this.workspaceNodes;
    }
}

