/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.jenkins.plugins.bfa.db;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.sonyericsson.jenkins.plugins.bfa.Messages;
import com.sonyericsson.jenkins.plugins.bfa.db.KnowledgeBase;
import com.sonyericsson.jenkins.plugins.bfa.db.MongoDBKnowledgeBaseCache;
import com.sonyericsson.jenkins.plugins.bfa.model.FailureCause;
import com.sonyericsson.jenkins.plugins.bfa.model.indication.FoundIndication;
import com.sonyericsson.jenkins.plugins.bfa.statistics.FailureCauseStatistics;
import com.sonyericsson.jenkins.plugins.bfa.statistics.Statistics;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import jenkins.model.Jenkins;
import net.vz.mongodb.jackson.JacksonDBCollection;
import net.vz.mongodb.jackson.WriteResult;
import org.bson.types.ObjectId;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class MongoDBKnowledgeBase
extends KnowledgeBase {
    private static final long serialVersionUID = 4984133048405390951L;
    public static final String COLLECTION_NAME = "failureCauses";
    public static final String STATISTICS_COLLECTION_NAME = "statistics";
    private static final int MONGO_DEFAULT_PORT = 27017;
    static final BasicDBObject NOT_REMOVED_QUERY = new BasicDBObject("_removed", (Object)new BasicDBObject("$exists", (Object)false));
    private static final Logger logger = Logger.getLogger(MongoDBKnowledgeBase.class.getName());
    private transient Mongo mongo;
    private transient DB db;
    private transient DBCollection collection;
    private transient DBCollection statisticsCollection;
    private transient JacksonDBCollection<FailureCause, String> jacksonCollection;
    private transient MongoDBKnowledgeBaseCache cache;
    private String host;
    private int port;
    private String dbName;
    private String userName;
    private Secret password;
    private boolean enableStatistics;

    public String getUserName() {
        return this.userName;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDbName() {
        return this.dbName;
    }

    @DataBoundConstructor
    public MongoDBKnowledgeBase(String host, int port, String dbName, String userName, Secret password, boolean enableStatistics) {
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.userName = userName;
        this.password = password;
        this.enableStatistics = enableStatistics;
    }

    @Override
    public synchronized void start() throws UnknownHostException, AuthenticationException {
        this.initCache();
    }

    @Override
    public synchronized void stop() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
    }

    private void initCache() throws UnknownHostException, AuthenticationException {
        if (this.cache == null) {
            this.cache = new MongoDBKnowledgeBaseCache(this.getJacksonCollection());
            this.cache.start();
        }
    }

    @Override
    public Collection<FailureCause> getCauses() throws UnknownHostException, AuthenticationException {
        this.initCache();
        return this.cache.getCauses();
    }

    @Override
    public Collection<FailureCause> getCauseNames() throws UnknownHostException, AuthenticationException {
        LinkedList<FailureCause> list = new LinkedList<FailureCause>();
        BasicDBObject keys = new BasicDBObject();
        keys.put("name", (Object)1);
        net.vz.mongodb.jackson.DBCursor dbCauses = this.getJacksonCollection().find((DBObject)NOT_REMOVED_QUERY, (DBObject)keys);
        while (dbCauses.hasNext()) {
            list.add((FailureCause)dbCauses.next());
        }
        return list;
    }

    @Override
    public Collection<FailureCause> getShallowCauses() throws Exception {
        LinkedList<FailureCause> list = new LinkedList<FailureCause>();
        BasicDBObject keys = new BasicDBObject();
        keys.put("name", (Object)1);
        keys.put("description", (Object)1);
        keys.put("categories", (Object)1);
        BasicDBObject orderBy = new BasicDBObject("name", (Object)1);
        net.vz.mongodb.jackson.DBCursor dbCauses = this.getJacksonCollection().find((DBObject)NOT_REMOVED_QUERY, (DBObject)keys);
        dbCauses = dbCauses.sort((DBObject)orderBy);
        while (dbCauses.hasNext()) {
            list.add((FailureCause)dbCauses.next());
        }
        return list;
    }

    @Override
    public FailureCause getCause(String id) throws UnknownHostException, AuthenticationException {
        FailureCause returnCase = null;
        try {
            returnCase = (FailureCause)this.getJacksonCollection().findOneById((Object)id);
        }
        catch (IllegalArgumentException e) {
            logger.fine("Could not find the id, returning null for id: " + id);
            return returnCase;
        }
        return returnCase;
    }

    @Override
    public FailureCause addCause(FailureCause cause) throws UnknownHostException, AuthenticationException {
        return this.addCause(cause, true);
    }

    @Override
    public FailureCause removeCause(String id) throws Exception {
        BasicDBObject idq = new BasicDBObject("_id", (Object)new ObjectId(id));
        BasicDBObject removedInfo = new BasicDBObject("timestamp", (Object)new Date());
        removedInfo.put("by", (Object)Jenkins.getAuthentication().getName());
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("_removed", (Object)removedInfo));
        FailureCause modified = (FailureCause)this.getJacksonCollection().findAndModify((DBObject)idq, null, null, false, (DBObject)update, true, false);
        this.initCache();
        this.cache.updateCache();
        return modified;
    }

    public FailureCause addCause(FailureCause cause, boolean doUpdate) throws UnknownHostException, AuthenticationException {
        WriteResult result = this.getJacksonCollection().insert((Object)cause);
        if (doUpdate) {
            this.initCache();
            this.cache.updateCache();
        }
        return (FailureCause)result.getSavedObject();
    }

    @Override
    public FailureCause saveCause(FailureCause cause) throws UnknownHostException, AuthenticationException {
        return this.saveCause(cause, true);
    }

    public FailureCause saveCause(FailureCause cause, boolean doUpdate) throws UnknownHostException, AuthenticationException {
        WriteResult result = this.getJacksonCollection().save((Object)cause);
        if (doUpdate) {
            this.initCache();
            this.cache.updateCache();
        }
        return (FailureCause)result.getSavedObject();
    }

    @Override
    public void convertFrom(KnowledgeBase oldKnowledgeBase) throws Exception {
        if (oldKnowledgeBase instanceof MongoDBKnowledgeBase) {
            this.convertFromAbstract(oldKnowledgeBase);
            this.convertRemoved((MongoDBKnowledgeBase)oldKnowledgeBase);
        } else {
            for (FailureCause cause : oldKnowledgeBase.getCauseNames()) {
                try {
                    if (this.getCause(cause.getId()) != null) {
                        this.saveCause(cause, false);
                        continue;
                    }
                    cause.setId(null);
                    this.addCause(cause, false);
                }
                catch (MongoException e) {
                    cause.setId(null);
                    this.addCause(cause, false);
                }
            }
            this.initCache();
            this.cache.updateCache();
        }
    }

    @Override
    public List<String> getCategories() throws UnknownHostException, AuthenticationException {
        this.initCache();
        return this.cache.getCategories();
    }

    protected void convertRemoved(MongoDBKnowledgeBase oldKnowledgeBase) throws Exception {
        List<DBObject> removed = oldKnowledgeBase.getRemovedCauses();
        DBCollection dbCollection = this.getJacksonCollection().getDbCollection();
        for (DBObject obj : removed) {
            dbCollection.save(obj);
        }
    }

    protected List<DBObject> getRemovedCauses() throws Exception {
        BasicDBObject query = new BasicDBObject("_removed", (Object)new BasicDBObject("$exists", (Object)true));
        DBCursor dbCursor = this.getJacksonCollection().getDbCollection().find((DBObject)query);
        LinkedList<DBObject> removed = new LinkedList<DBObject>();
        while (dbCursor.hasNext()) {
            removed.add(dbCursor.next());
        }
        return removed;
    }

    @Override
    public boolean equals(KnowledgeBase oldKnowledgeBase) {
        if (this.getClass().isInstance(oldKnowledgeBase)) {
            MongoDBKnowledgeBase oldMongoDBKnowledgeBase = (MongoDBKnowledgeBase)oldKnowledgeBase;
            return MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getHost(), this.host) && oldMongoDBKnowledgeBase.getPort() == this.port && MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getDbName(), this.dbName) && MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getUserName(), this.userName) && MongoDBKnowledgeBase.equals(oldMongoDBKnowledgeBase.getPassword(), this.password) && this.enableStatistics == oldMongoDBKnowledgeBase.enableStatistics;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof KnowledgeBase) {
            return this.equals((KnowledgeBase)other);
        }
        return false;
    }

    public static boolean equals(Object firstObject, Object secondObject) {
        if (firstObject == null) {
            return secondObject == null;
        }
        if (secondObject == null) {
            return false;
        }
        return secondObject.equals(firstObject);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.enableStatistics;
    }

    @Override
    public void saveStatistics(Statistics stat) throws UnknownHostException, AuthenticationException {
        BasicDBObject object = new BasicDBObject();
        object.put("projectName", (Object)stat.getProjectName());
        object.put("buildNumber", (Object)stat.getBuildNumber());
        object.put("master", (Object)stat.getMaster());
        object.put("slaveHostName", (Object)stat.getSlaveHostName());
        object.put("startingTime", (Object)stat.getStartingTime());
        object.put("duration", (Object)stat.getDuration());
        object.put("timeZoneOffset", (Object)stat.getTimeZoneOffset());
        object.put("triggerCauses", stat.getTriggerCauses());
        object.put("result", (Object)stat.getResult());
        List<FailureCauseStatistics> failureCauseStatisticsList = stat.getFailureCauseStatisticsList();
        this.addFailureCausesToDBObject((DBObject)object, failureCauseStatisticsList);
        this.getStatisticsCollection().insert(new DBObject[]{object});
    }

    private void addFailureCausesToDBObject(DBObject object, List<FailureCauseStatistics> failureCauseStatisticsList) throws UnknownHostException, AuthenticationException {
        if (failureCauseStatisticsList != null && failureCauseStatisticsList.size() > 0) {
            LinkedList<BasicDBObject> failureCauseStatisticsObjects = new LinkedList<BasicDBObject>();
            for (FailureCauseStatistics failureCauseStatistics : failureCauseStatisticsList) {
                BasicDBObject failureCauseStatisticsObject = new BasicDBObject();
                ObjectId id = new ObjectId(failureCauseStatistics.getId());
                DBRef failureCauseRef = new DBRef(this.getDb(), COLLECTION_NAME, (Object)id);
                failureCauseStatisticsObject.put("failureCause", (Object)failureCauseRef);
                List<FoundIndication> foundIndicationList = failureCauseStatistics.getIndications();
                this.addIndicationsToDBObject((DBObject)failureCauseStatisticsObject, foundIndicationList);
                failureCauseStatisticsObjects.add(failureCauseStatisticsObject);
            }
            object.put(COLLECTION_NAME, failureCauseStatisticsObjects);
        }
    }

    private void addIndicationsToDBObject(DBObject object, List<FoundIndication> indications) {
        if (indications != null && indications.size() > 0) {
            LinkedList<BasicDBObject> foundIndicationObjects = new LinkedList<BasicDBObject>();
            for (FoundIndication foundIndication : indications) {
                BasicDBObject foundIndicationObject = new BasicDBObject();
                foundIndicationObject.put("pattern", (Object)foundIndication.getPattern());
                foundIndicationObject.put("matchingFile", (Object)foundIndication.getMatchingFile());
                foundIndicationObject.put("matchingString", (Object)foundIndication.getMatchingString());
                foundIndicationObjects.add(foundIndicationObject);
            }
            object.put("indications", foundIndicationObjects);
        }
    }

    public Descriptor<KnowledgeBase> getDescriptor() {
        return Jenkins.getInstance().getDescriptorByType(MongoDBKnowledgeBaseDescriptor.class);
    }

    private Mongo getMongoConnection() throws UnknownHostException {
        if (this.mongo == null) {
            this.mongo = new Mongo(this.host, this.port);
        }
        return this.mongo;
    }

    private DB getDb() throws UnknownHostException, AuthenticationException {
        char[] pwd;
        if (this.db == null) {
            this.db = this.getMongoConnection().getDB(this.dbName);
        }
        if (Util.fixEmpty((String)this.userName) != null && Util.fixEmpty((String)Secret.toString((Secret)this.password)) != null && !this.db.authenticate(this.userName, pwd = this.password.getPlainText().toCharArray())) {
            throw new AuthenticationException("Could not athenticate with the mongo database");
        }
        return this.db;
    }

    private DBCollection getCollection() throws UnknownHostException, AuthenticationException {
        if (this.collection == null) {
            this.collection = this.getDb().getCollection(COLLECTION_NAME);
        }
        return this.collection;
    }

    private DBCollection getStatisticsCollection() throws UnknownHostException, AuthenticationException {
        if (this.statisticsCollection == null) {
            this.statisticsCollection = this.getDb().getCollection(STATISTICS_COLLECTION_NAME);
        }
        return this.statisticsCollection;
    }

    private synchronized JacksonDBCollection<FailureCause, String> getJacksonCollection() throws UnknownHostException, AuthenticationException {
        if (this.jacksonCollection == null) {
            if (this.collection == null) {
                this.collection = this.getCollection();
            }
            this.jacksonCollection = JacksonDBCollection.wrap((DBCollection)this.collection, FailureCause.class, String.class);
        }
        return this.jacksonCollection;
    }

    @Extension
    public static class MongoDBKnowledgeBaseDescriptor
    extends KnowledgeBase.KnowledgeBaseDescriptor {
        public String getDisplayName() {
            return Messages.MongoDBKnowledgeBase_DisplayName();
        }

        public int getDefaultPort() {
            return 27017;
        }

        public FormValidation doCheckHost(@QueryParameter(value="value") String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.error((String)"Please provide a host name!");
            }
            Matcher m = Pattern.compile("\\s").matcher(value);
            if (m.find()) {
                return FormValidation.error((String)"Host name contains white space!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPort(@QueryParameter(value="value") String value) {
            try {
                Long.parseLong(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Please provide a port number!");
            }
        }

        public FormValidation doCheckDBName(@QueryParameter(value="value") String value) {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"Please provide a database name!");
            }
            Matcher m = Pattern.compile("\\s").matcher(value);
            if (m.find()) {
                return FormValidation.error((String)"Database name contains white space!");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter(value="host") String host, @QueryParameter(value="port") int port, @QueryParameter(value="dbName") String dbName, @QueryParameter(value="userName") String userName, @QueryParameter(value="password") String password) {
            MongoDBKnowledgeBase base = new MongoDBKnowledgeBase(host, port, dbName, userName, Secret.fromString((String)password), false);
            try {
                base.getCollection();
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)Messages.MongoDBKnowledgeBase_ConnectionError());
            }
            return FormValidation.ok((String)Messages.MongoDBKnowledgeBase_ConnectionOK());
        }
    }
}

