/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.wasPlugin;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.plugins.wasPlugin.QualysAuth.AuthType;
import com.qualys.plugins.wasPlugin.QualysAuth.QualysAuth;
import com.qualys.plugins.wasPlugin.QualysClient.QualysCSClient;
import com.qualys.plugins.wasPlugin.QualysClient.QualysCSResponse;
import com.qualys.plugins.wasPlugin.QualysCriteria.QualysCriteria;
import com.qualys.plugins.wasPlugin.report.ReportAction;
import com.qualys.plugins.wasPlugin.util.Helper;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.lang.invoke.CallSite;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

public class WASScanLauncher {
    private Run<?, ?> run;
    private TaskListener listener;
    private String webAppId;
    private String scanName;
    private String scanType;
    private String authRecord;
    private String optionProfile;
    private String cancelOptions;
    private String authRecordId;
    private String optionProfileId;
    private String cancelHours;
    private int pollingIntervalForVulns;
    private int vulnsTimeout;
    private String portalUrl;
    private String apiServer;
    private AuthType authType;
    private String apiUser;
    private Secret apiPass;
    private String clientId;
    private String clientSecret;
    private boolean useProxy;
    private String proxyServer;
    private int proxyPort;
    private String proxyUsername;
    private Secret proxyPassword;
    private boolean isFailConditionsConfigured;
    private JsonObject criteriaObject;
    private QualysCSClient apiClient;
    private boolean failOnScanError;
    private static final Logger logger = Helper.getLogger(WASScanLauncher.class.getName());
    private static final int DEFAULT_POLLING_INTERVAL_FOR_VULNS = 5;
    private static final int DEFAULT_TIMEOUT_FOR_VULNS = 1440;
    private final JsonObject kbData = new JsonObject();
    private ArrayList<ArrayList<String>> qidBatches = new ArrayList();

    public WASScanLauncher(Run<?, ?> run, TaskListener listener, String webAppId, String scanName, String scanType, String authRecord, String optionProfile, String cancelOptions, String authRecordId, String optionProfileId, String cancelHours, boolean isFailConditionsConfigured, String pollingIntervalStr, String vulnsTimeoutStr, JsonObject criteriaObject, String apiServer, AuthType authType, String apiUser, String apiPass, String clientId, String clientSecret, boolean useProxy, String proxyServer, int proxyPort, String proxyUsername, String proxyPassword, String portalUrl, boolean failOnScanError) {
        this.run = run;
        this.listener = listener;
        this.webAppId = webAppId;
        this.scanName = scanName;
        this.scanType = scanType;
        this.authRecord = authRecord;
        this.optionProfile = optionProfile;
        this.cancelOptions = cancelOptions;
        this.authRecordId = authRecordId;
        this.optionProfileId = optionProfileId;
        this.cancelHours = cancelHours;
        this.apiServer = apiServer;
        this.authType = authType;
        this.apiUser = apiUser;
        this.apiPass = Secret.fromString((String)apiPass);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.useProxy = useProxy;
        this.proxyServer = proxyServer;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = Secret.fromString((String)proxyPassword);
        this.portalUrl = portalUrl;
        if (scanName != null && !scanName.isEmpty() && !scanName.equals("")) {
            this.scanName = this.scanName + "_[timestamp]";
        }
        this.criteriaObject = criteriaObject;
        this.isFailConditionsConfigured = isFailConditionsConfigured;
        QualysAuth auth = new QualysAuth();
        auth.setQualysCredentials(apiServer, authType, apiUser, apiPass, clientId, clientSecret);
        if (useProxy) {
            auth.setProxyCredentials(proxyServer, proxyPort, proxyUsername, proxyPassword);
        }
        this.apiClient = new QualysCSClient(auth, System.out);
        this.pollingIntervalForVulns = this.setTimeoutInMinutes("pollingInterval", 5, pollingIntervalStr, listener);
        this.vulnsTimeout = this.setTimeoutInMinutes("vulnsTimeout", 1440, vulnsTimeoutStr, listener);
        this.failOnScanError = failOnScanError;
    }

    private int setTimeoutInMinutes(String timeoutType, int defaultTimeoutInMins, String timeout, TaskListener listener) {
        if (timeout != null && !timeout.isEmpty()) {
            try {
                String[] numbers = timeout.split("\\*");
                int timeoutInMins = 1;
                for (int i = 0; i < numbers.length; ++i) {
                    timeoutInMins = (int)((long)timeoutInMins * Long.parseLong(numbers[i]));
                }
                return timeoutInMins;
            }
            catch (Exception e) {
                listener.getLogger().println("Invalid " + timeoutType + " time value. Cannot parse -" + e.getMessage());
                listener.getLogger().println("Using default period of " + String.valueOf(timeoutType.equals("vulnsTimeout") ? "60*24" : Integer.valueOf(defaultTimeoutInMins)) + " minutes for " + timeoutType + ".");
            }
        }
        return defaultTimeoutInMins;
    }

    public void getAndProcessLaunchScanResult() throws Exception {
        block6: {
            try {
                String scanId = this.launchScan();
                if (scanId != null && !scanId.equals("")) {
                    JsonObject result;
                    this.listener.getLogger().println(String.valueOf(new Timestamp(System.currentTimeMillis())) + " New Scan launched successfully. Scan ID: " + scanId);
                    logger.info("New Scan launched successfully.");
                    JsonObject evaluationResult = null;
                    Boolean buildPassed = true;
                    if (this.isFailConditionsConfigured && (result = this.fetchScanResult(scanId)) != null) {
                        evaluationResult = this.evaluateFailurePolicy(result);
                        Helper.copyEvaluationResultToFile(this.run.getArtifactsDir().getAbsolutePath(), "qualys_" + scanId, this.listener.getLogger(), evaluationResult.getAsJsonObject("result"));
                        buildPassed = evaluationResult.get("passed").getAsBoolean();
                    }
                    ReportAction action = new ReportAction(this.run, scanId, this.webAppId, this.scanName, this.apiServer, this.authType, this.apiUser, this.apiPass, this.clientId, this.clientSecret, this.useProxy, this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword, this.portalUrl);
                    this.run.addAction((Action)action);
                    if (this.isFailConditionsConfigured && !buildPassed.booleanValue()) {
                        String failureMessage = evaluationResult.get("failureMessage").getAsString();
                        throw new Exception(failureMessage);
                    }
                    break block6;
                }
                throw new Exception("API Error. Could not launch new scan");
            }
            catch (AbortException e) {
                e.printStackTrace();
                throw new Exception(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e.getMessage());
            }
        }
    }

    private String getBuildFailureMessages(JsonObject result) throws Exception {
        JsonObject qidsObj;
        boolean qidsPass;
        ArrayList<CallSite> failureMessages = new ArrayList<CallSite>();
        if (result.has("qids") && result.get("qids") != null && !result.get("qids").isJsonNull() && !(qidsPass = (qidsObj = result.get("qids").getAsJsonObject()).get("result").getAsBoolean())) {
            String found = qidsObj.get("found").getAsString();
            failureMessages.add((CallSite)((Object)("QIDs configured in Failure Conditions were found in the scan result : " + found)));
        }
        Object sevConfigured = "\nConfigured : ";
        Object sevFound = "\nFound : ";
        boolean severityFailed = false;
        for (int i = 1; i <= 5; ++i) {
            JsonObject sevObj;
            JsonObject severity;
            if (!result.has("severities") || result.get("severities") == null || result.get("severities").isJsonNull() || !(severity = (sevObj = result.get("severities").getAsJsonObject()).get("" + i).getAsJsonObject()).has("configured") || severity.get("configured").isJsonNull() || severity.get("configured").getAsInt() == -1) continue;
            sevFound = (String)sevFound + "Severity " + i + ": " + String.valueOf(severity.get("found").isJsonNull() ? Integer.valueOf(0) : severity.get("found").getAsString()) + ";";
            sevConfigured = (String)sevConfigured + "Severity " + i + ">" + severity.get("configured").getAsString() + ";";
            boolean sevPass = severity.get("result").getAsBoolean();
            if (sevPass) continue;
            severityFailed = true;
        }
        if (severityFailed) {
            failureMessages.add((CallSite)((Object)("The vulnerabilities count by severity exceeded one of the configured threshold value :" + (String)sevConfigured + (String)sevFound)));
        }
        return StringUtils.join(failureMessages, (String)"\n");
    }

    public JsonObject evaluateFailurePolicy(JsonObject result) throws Exception {
        Gson gson = new Gson();
        QualysCriteria criteria = new QualysCriteria(gson.toJson((JsonElement)this.criteriaObject));
        Boolean passed = criteria.evaluate(result);
        JsonObject obj = new JsonObject();
        obj.add("passed", gson.toJsonTree((Object)passed));
        obj.add("result", (JsonElement)criteria.returnObject);
        if (!passed.booleanValue()) {
            String failureMessage = this.getBuildFailureMessages(criteria.getResult());
            obj.addProperty("failureMessage", failureMessage);
        }
        return obj;
    }

    /*
     * Exception decompiling
     */
    public JsonObject fetchScanResult(String scanId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JSONObject getKbData(String qids) {
        Object kbData = null;
        String params = "?action=list&details=All&show_supported_modules_info=1&ids=" + qids;
        String responseString = this.apiClient.getKbData(params);
        JSONObject jsonResponse = null;
        if (!responseString.isEmpty()) {
            JSONObject reponseJson = new JSONObject(responseString);
            String responseStatusCode = reponseJson.get("statusCode").toString();
            String responseBody = reponseJson.get("body").toString();
            if (responseStatusCode.equals("200")) {
                jsonResponse = XML.toJSONObject((String)responseBody);
            }
        }
        return jsonResponse;
    }

    public Boolean batchAndGetKbData(JsonObject scanResult) {
        try {
            int i;
            JsonObject serviceResp = scanResult.getAsJsonObject("ServiceResponse");
            JsonArray dataArr = serviceResp.getAsJsonArray("data");
            JsonObject obj = dataArr.get(0).getAsJsonObject();
            JsonObject scanObj = obj.getAsJsonObject("WasScan");
            JsonObject vulns = scanObj.getAsJsonObject("vulns");
            JsonArray listArr = vulns.getAsJsonArray("list");
            int vulnsCount = vulns.get("count").getAsInt();
            ArrayList<String> batch = new ArrayList<String>();
            for (i = 0; i < vulnsCount; ++i) {
                ArrayList<String> oneBatch;
                JsonObject listItem = listArr.get(i).getAsJsonObject();
                JsonObject WasScanVuln = listItem.getAsJsonObject("WasScanVuln");
                String qid = WasScanVuln.get("qid").getAsString();
                batch.add(qid);
                if (batch.size() == 500) {
                    oneBatch = new ArrayList<String>();
                    oneBatch.addAll(batch);
                    this.qidBatches.add(oneBatch);
                    batch.clear();
                    continue;
                }
                if (i != vulnsCount - 1) continue;
                oneBatch = new ArrayList();
                oneBatch.addAll(batch);
                this.qidBatches.add(oneBatch);
                batch.clear();
            }
            if (this.qidBatches != null && !this.qidBatches.isEmpty()) {
                for (i = 0; i < this.qidBatches.size(); ++i) {
                    String ids = this.qidBatches.get(i).toString().replace("[", "").replace("]", "").replace(" ", "");
                    Boolean batchResult = this.processBatch(ids);
                    if (batchResult.booleanValue()) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.listener.getLogger().println(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Error batchAndGetKbData: " + e.getMessage());
            return false;
        }
    }

    public Boolean processBatch(String qids) {
        try {
            Gson gson = new Gson();
            JSONObject kbResult = this.getKbData(qids);
            if (kbResult != null) {
                JSONObject kbOutput = kbResult.getJSONObject("KNOWLEDGE_BASE_VULN_LIST_OUTPUT");
                JSONObject kbResponse = kbOutput.getJSONObject("RESPONSE");
                JSONObject kbVulnList = kbResponse.getJSONObject("VULN_LIST");
                String scanResultString = gson.toJson((Object)kbVulnList);
                JSONArray kbVulns = kbVulnList.getJSONArray("VULN");
                for (int i = 0; i < kbVulns.length(); ++i) {
                    JSONObject listItem = kbVulns.getJSONObject(i);
                    String qid = Integer.toString(listItem.getInt("QID"));
                    String solution = listItem.getString("SOLUTION");
                    String diagnosis = listItem.getString("DIAGNOSIS");
                    this.kbData.addProperty(qid + "_solution", solution);
                    this.kbData.addProperty(qid + "_diagnosis", diagnosis);
                }
                return true;
            }
            this.listener.getLogger().println(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Kb data not found for qids: " + qids);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.listener.getLogger().println(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Error processBatch: " + e.getMessage());
            return false;
        }
    }

    public JsonObject getScanResult(String scanId) {
        JsonObject scanResult = null;
        QualysCSResponse statusResponse = this.apiClient.getScanResult(scanId);
        scanResult = statusResponse.response;
        return scanResult;
    }

    public String getScanFinishedStatus(String scanId) {
        String status = null;
        try {
            QualysCSResponse statusResponse = this.apiClient.getScanStatus(scanId);
            JsonObject result = statusResponse.response;
            JsonElement respEl = result.get("ServiceResponse");
            JsonObject respObj = respEl.getAsJsonObject();
            JsonElement respCodeObj = respObj.get("responseCode");
            if (respCodeObj != null && !respCodeObj.getAsString().equals("SUCCESS")) {
                JsonObject respErr = respObj.getAsJsonObject("responseErrorDetails");
                logger.info("Server Response: " + respErr.toString());
                String reason = respErr.get("errorMessage").getAsString();
                throw new Exception(reason);
            }
            JsonArray dataArr = respObj.getAsJsonArray("data");
            JsonObject obj = dataArr.get(0).getAsJsonObject();
            JsonObject scanObj = obj.getAsJsonObject("WasScan");
            String scanStatus = scanObj.get("status").getAsString();
            String error = "Unknown.";
            try {
                JsonObject summaryObj = scanObj.getAsJsonObject("summary");
                error = summaryObj.get("resultsStatus").getAsString();
            }
            catch (Exception e) {
                logger.info("Could not read error reason from response.");
            }
            if (scanStatus.equalsIgnoreCase("error") || scanStatus.equalsIgnoreCase("canceled") || scanStatus.equalsIgnoreCase("finished") && !error.equalsIgnoreCase("finished")) {
                this.listener.getLogger().println(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Scan Status: " + scanStatus + ". Reason: " + error);
                return error;
            }
            this.listener.getLogger().println(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Scan Status: " + scanStatus);
            return scanStatus.equalsIgnoreCase("error") || scanStatus.equalsIgnoreCase("canceled") || scanStatus.equalsIgnoreCase("finished") ? scanStatus : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.listener.getLogger().println(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Error getting scan status: " + e.getMessage());
            return status;
        }
    }

    public String launchScan() throws Exception {
        JsonObject authRec;
        JsonObject result = new JsonObject();
        JsonObject requestData = new JsonObject();
        Object printLine = "Launching Qualys WAS scan with - ";
        if (this.scanType == null || this.scanType.isEmpty() || this.scanType.equals("")) {
            throw new AbortException("Scan Type - Required parameter to launch scan is missing.");
        }
        if (this.scanName == null || this.scanName.isEmpty() || this.scanName.equals("")) {
            throw new AbortException("Scan Name - Required parameter to launch scan is missing.");
        }
        if (this.webAppId == null || this.webAppId.isEmpty() || this.webAppId.equals("")) {
            throw new AbortException("Web App ID - Required parameter to launch scan is missing.");
        }
        JsonObject requestObj = new JsonObject();
        JsonObject data = new JsonObject();
        JsonObject wasScan = new JsonObject();
        wasScan.addProperty("type", this.scanType);
        EnvVars env = this.run.getEnvironment(this.listener);
        String job_name = (String)env.get((Object)"JOB_NAME");
        String build_no = (String)env.get((Object)"BUILD_NUMBER");
        String timestamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date());
        this.scanName = this.scanName.replaceAll("(?i)\\[job_name\\]", job_name).replaceAll("(?i)\\[build_number\\]", build_no).replaceAll("(?i)\\[timestamp\\]", timestamp);
        wasScan.addProperty("name", this.scanName);
        JsonObject webappDetails = new JsonObject();
        JsonObject webapp = new JsonObject();
        webappDetails.addProperty("id", this.webAppId);
        webapp.add("webApp", (JsonElement)webappDetails);
        if (this.authRecord != null && this.authRecord.equals("useDefault")) {
            authRec = new JsonObject();
            authRec.addProperty("isDefault", "true");
            webapp.add("webAppAuthRecord", (JsonElement)authRec);
        } else if (this.authRecord != null && this.authRecordId != null && this.authRecord.equals("other") && !this.authRecordId.isEmpty() && !this.authRecordId.equals("")) {
            authRec = new JsonObject();
            authRec.addProperty("id", this.authRecordId);
            webapp.add("webAppAuthRecord", (JsonElement)authRec);
        }
        if (this.cancelHours != null && this.cancelOptions != null && this.cancelOptions.equals("xhours") && !this.cancelHours.isEmpty() && !this.cancelHours.equals("")) {
            wasScan.addProperty("cancelAfterNHours", this.cancelHours);
        }
        if (this.optionProfile != null && this.optionProfileId != null && this.optionProfile.equals("other") && !this.optionProfileId.isEmpty() && !this.optionProfileId.equals("")) {
            JsonObject profRec = new JsonObject();
            profRec.addProperty("id", this.optionProfileId);
            wasScan.add("profile", (JsonElement)profRec);
        } else if (this.optionProfile != null && this.optionProfile.equals("useDefault")) {
            printLine = (String)printLine + "OptionProfile:Default";
        }
        wasScan.add("target", (JsonElement)webapp);
        data.add("WasScan", (JsonElement)wasScan);
        requestObj.add("data", (JsonElement)data);
        requestData.add("ServiceRequest", (JsonElement)requestObj);
        Map<String, String> webAppDetialsMap = this.getWebappDetails(this.webAppId);
        if (webAppDetialsMap != null && webappDetails.has("warning")) {
            this.listener.getLogger().println("WARNING: " + webAppDetialsMap.get("warning"));
        }
        String webAppName = webAppDetialsMap.get("webAppName");
        this.listener.getLogger().println("Using Web Application: " + webAppName);
        ArrayList<String> scan_ids = new ArrayList<String>();
        this.listener.getLogger().println(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Calling Launch Scan API with Payload: " + String.valueOf(requestData));
        if (this.isFailConditionsConfigured) {
            this.listener.getLogger().println("Using Build Failure Conditions configuration: " + String.valueOf(this.criteriaObject));
        }
        QualysCSResponse response = this.apiClient.launchWASScan(requestData);
        result = response.response;
        JsonElement respEl = result.get("ServiceResponse");
        JsonObject respObj = respEl.getAsJsonObject();
        JsonElement respCodeObj = respObj.get("responseCode");
        if (respCodeObj != null && !respCodeObj.getAsString().equals("SUCCESS")) {
            JsonObject respErr = respObj.getAsJsonObject("responseErrorDetails");
            logger.info("Server Response: " + respErr.toString());
            throw new AbortException("Error while launching new scan. Server returned: " + String.valueOf(respErr));
        }
        JsonArray dataArr = respObj.get("data").getAsJsonArray();
        if (dataArr.size() == 0) {
            return "";
        }
        for (int i = 0; i < dataArr.size(); ++i) {
            JsonObject obj = dataArr.get(i).getAsJsonObject();
            JsonObject wasObj = obj.get("WasScan").getAsJsonObject();
            String scan_id = wasObj.get("id").getAsString();
            scan_ids.add(scan_id);
        }
        return String.join((CharSequence)", ", scan_ids);
    }

    public Map<String, String> getWebappDetails(String id) throws Exception {
        logger.info("Fetching web app details from server.");
        JsonObject result = new JsonObject();
        HashMap<String, String> webAppDetails = new HashMap<String, String>();
        try {
            QualysCSResponse webAppDetialsResp = this.apiClient.getWebAppDetails(this.webAppId);
            result = webAppDetialsResp.response;
            JsonElement respEl = result.get("ServiceResponse");
            JsonObject respObj = respEl.getAsJsonObject();
            JsonElement respCodeObj = respObj.get("responseCode");
            if (respCodeObj != null && !respCodeObj.getAsString().equals("SUCCESS")) {
                JsonObject respErr = respObj.getAsJsonObject("responseErrorDetails");
                logger.info("Server Response: " + respErr.toString());
                String reason = respErr.get("errorMessage").getAsString();
                throw new Exception(reason);
            }
            JsonArray dataArr = respObj.getAsJsonArray("data");
            for (int i = 0; i < dataArr.size(); ++i) {
                JsonObject scannerObj;
                String scannerAppliance;
                JsonObject obj = dataArr.get(i).getAsJsonObject();
                JsonObject webAppObj = obj.getAsJsonObject("WebApp");
                String webAppName = webAppObj.get("name").getAsString();
                String webAppURL = webAppObj.get("url").getAsString();
                JsonElement scannerEl = webAppObj.get("defaultScanner");
                if (scannerEl != null && !scannerEl.isJsonNull() && (scannerAppliance = (scannerObj = scannerEl.getAsJsonObject()).get("type").getAsString()).toLowerCase().equals("external")) {
                    webAppDetails.put("warning", "Default Scanner Appliance for this webapp is EXTERNAL scanner which will not work and an INTERNAL scanner appliance should be configured as default for the web app.");
                }
                webAppDetails.put("webAppName", webAppName);
                webAppDetails.put("webAppURL", webAppURL);
            }
        }
        catch (Exception e) {
            logger.info("Exception fetching web app details. Reason: " + e.getMessage());
            throw e;
        }
        return webAppDetails;
    }
}

