/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.containerSecurity.report;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import qshaded.com.google.gson.Gson;
import qshaded.com.google.gson.JsonArray;
import qshaded.com.google.gson.JsonElement;
import qshaded.com.google.gson.JsonObject;
import qshaded.com.google.gson.reflect.TypeToken;

@Extension
public class ReportAction
implements Action {
    private String dockerImageId;
    private Run<?, ?> run;
    private int prevBuildNumber;
    private JsonObject reportObject;
    private JsonObject trendingData;
    private String imageNameInput;
    private String portalURL;
    private String imageSHA;
    private static final Logger logger = Logger.getLogger(ReportAction.class.getName());

    public ReportAction() {
    }

    public ReportAction(String dockerImageId, Run<?, ?> run, PrintStream buildLogger, String imageInput, String portalURL, String imageSHA) {
        this.dockerImageId = dockerImageId;
        this.run = run;
        this.prevBuildNumber = 0;
        this.imageNameInput = imageInput;
        this.portalURL = portalURL;
        this.imageSHA = imageSHA;
    }

    public JsonObject getReportJsonObject() {
        String summaryFilename = this.run.getArtifactsDir().getAbsolutePath() + File.separator + "qualys_images_summary.json";
        try {
            File f = new File(summaryFilename);
            if (f.exists()) {
                Gson gson = new Gson();
                String resultString = FileUtils.readFileToString((File)f);
                JsonObject obj = (JsonObject)gson.fromJson(resultString, JsonObject.class);
                JsonObject scanResult = obj.getAsJsonObject("scanResult");
                this.reportObject = scanResult.getAsJsonObject(this.dockerImageId);
                JsonArray trendingDataArr = obj.getAsJsonArray("trendingData");
                for (JsonElement el : trendingDataArr) {
                    JsonObject trend = el.getAsJsonObject();
                    String imageId = trend.get("imageId").getAsString();
                    if (!imageId.equals(this.dockerImageId)) continue;
                    this.trendingData = trend;
                }
            } else {
                logger.info("Error: Couldn't find summary file for the build.");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            logger.info("Error while reading summary file: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Error while reading summary file: " + e.getMessage());
        }
        JsonObject totalVulnsTrend = this.getTotalVulnsTrend();
        this.reportObject.add("totalVulnsTrend", (JsonElement)totalVulnsTrend);
        return this.reportObject;
    }

    public JsonObject getTotalVulnsTrend() {
        Gson gson = new Gson();
        JsonObject obj = new JsonObject();
        JsonArray rposArr = this.trendingData.get("repos").getAsJsonArray();
        JsonArray vulnsArr = this.trendingData.get("confirmedVulns").getAsJsonArray();
        JsonArray totalVulns = (JsonArray)gson.fromJson((JsonElement)vulnsArr, JsonArray.class);
        obj.add("current", (JsonElement)totalVulns);
        obj.addProperty("prevBuildNumber", (Number)this.prevBuildNumber);
        obj.addProperty("addChart", "1");
        obj.addProperty("prev", "null");
        if (rposArr == null) {
            obj.addProperty("addChart", "0");
        }
        JsonArray prevRunSummary = null;
        Run prevRun = this.run;
        while (prevRun != null && prevRun.getPreviousBuild() != null) {
            try {
                String filename;
                File f;
                if ((prevRun = prevRun.getPreviousBuild()) == null || !(f = new File(filename = prevRun.getArtifactsDir().getAbsolutePath() + File.separator + "qualys_images_summary.json")).exists()) continue;
                this.prevBuildNumber = prevRun.number;
                String result = FileUtils.readFileToString((File)f);
                JsonObject obj1 = (JsonObject)gson.fromJson(result, JsonObject.class);
                prevRunSummary = obj1.getAsJsonArray("trendingData");
                break;
            }
            catch (RuntimeException e) {
                break;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        if (prevRunSummary != null && !prevRunSummary.isJsonNull() && rposArr != null) {
            Type listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType();
            List currRepos = (List)gson.fromJson(rposArr.toString(), listType);
            for (JsonElement el : prevRunSummary) {
                JsonArray arr;
                JsonArray prevVulnsArray;
                JsonArray repoString;
                List prevRepos;
                JsonObject rpoObj = el.getAsJsonObject();
                if (rpoObj.get("repos").getAsJsonArray().size() <= 0 || !currRepos.containsAll(prevRepos = (List)gson.fromJson((repoString = rpoObj.get("repos").getAsJsonArray()).toString(), listType))) continue;
                JsonElement vulnsArrEl = rpoObj.get("confirmedVulns");
                if (vulnsArrEl != null && !vulnsArrEl.isJsonNull() && vulnsArrEl.isJsonArray() && (prevVulnsArray = (JsonArray)gson.fromJson((JsonElement)(arr = vulnsArrEl.getAsJsonArray()), JsonArray.class)) != null && !prevVulnsArray.isJsonNull()) {
                    obj.add("prev", (JsonElement)prevVulnsArray);
                }
                return obj;
            }
        }
        return obj;
    }

    public String getImageNameOrImageId() {
        return StringUtils.isNotBlank((String)this.imageNameInput) ? this.imageNameInput : this.dockerImageId;
    }

    public String getImageId() {
        return this.dockerImageId;
    }

    public String getImageSummaryPortalURL() {
        if (this.portalURL.endsWith("/")) {
            return this.portalURL + "cs/#/assets/images/" + this.imageSHA;
        }
        return this.portalURL + "/cs/#/assets/images/" + this.imageSHA;
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public String getDisplayName() {
        return "Qualys Report For " + this.dockerImageId;
    }

    public String getUrlName() {
        return "qualys_report_for_" + this.dockerImageId + ".html";
    }
}

