/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.containerSecurity;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.qualys.plugins.common.QualysAuth.AuthType;
import com.qualys.plugins.common.QualysAuth.QualysAuth;
import com.qualys.plugins.common.QualysClient.QualysCSClient;
import com.qualys.plugins.common.QualysClient.QualysCSTestConnectionResponse;
import com.qualys.plugins.containerSecurity.CheckSensorSlaveCallable;
import com.qualys.plugins.containerSecurity.GetImageVulns;
import com.qualys.plugins.containerSecurity.ImageShaExtractSlaveCallable;
import com.qualys.plugins.containerSecurity.QualysEvaluationException;
import com.qualys.plugins.containerSecurity.TagImageSlaveCallable;
import com.qualys.plugins.containerSecurity.config.QualysGlobalConfig;
import com.qualys.plugins.containerSecurity.model.ProxyConfiguration;
import com.qualys.plugins.containerSecurity.util.Helper;
import com.qualys.plugins.containerSecurity.util.OAuthCredential;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import qshaded.com.google.gson.Gson;
import qshaded.com.google.gson.JsonArray;
import qshaded.com.google.gson.JsonElement;
import qshaded.com.google.gson.JsonObject;
import qshaded.com.google.gson.reflect.TypeToken;

@Extension
public class GetImageVulnsNotifier
extends Notifier
implements SimpleBuildStep {
    private String apiServer;
    private String platform;
    private String apiUser;
    private Secret apiPass;
    private String credentialsId;
    private String imageIds;
    private String pollingInterval;
    private String vulnsTimeout;
    private boolean isFailOnSevereVulns;
    private int severity1Limit;
    private int severity2Limit;
    private int severity3Limit;
    private int severity4Limit;
    private int severity5Limit;
    private boolean isSev1Vulns = false;
    private boolean isSev2Vulns = false;
    private boolean isSev3Vulns = false;
    private boolean isSev4Vulns = false;
    private boolean isSev5Vulns = false;
    private String proxyServer;
    private Secret proxyPassword;
    private String proxyUsername;
    private int proxyPort;
    private String proxyCredentialsId;
    private boolean useProxy = false;
    private String excludeList;
    private String excludeBy;
    private boolean isExcludeConditions;
    private boolean isFailOnQidFound;
    private String qidList;
    private boolean isFailOnCVEs = false;
    private String cveList;
    private boolean isFailOnSoftware = false;
    private String softwareList;
    private boolean isPotentialVulnsToBeChecked = false;
    private boolean useLocalConfig = false;
    private boolean useGlobalConfig = false;
    private String webhookUrl;
    private String dockerUrl;
    private String dockerCert;
    private String cvssVersion;
    private String cvssThreshold;
    private boolean failByCvss = false;
    private JsonObject criteriaObj;
    private long taggingTime;
    private static final Logger logger = Logger.getLogger(GetImageVulnsNotifier.class.getName());
    private static final int DEFAULT_POLLING_INTERVAL_FOR_VULNS = 30;
    private static final int DEFAULT_TIMEOUT_FOR_VULNS = 600;

    @DataBoundConstructor
    public GetImageVulnsNotifier(boolean useGlobalConfig, boolean useLocalConfig, String apiServer, String apiUser, String apiPass, String credentialsId, String pollingInterval, String vulnsTimeout, boolean isFailOnSevereVulns, int severity1Limit, int severity2Limit, int severity3Limit, int severity4Limit, int severity5Limit, boolean isSev1Vulns, boolean isSev2Vulns, boolean isSev3Vulns, boolean isSev4Vulns, boolean isSev5Vulns, String proxyServer, int proxyPort, String proxyUsername, String proxyPassword, boolean useProxy, String proxyCredentialsId, boolean isFailOnQidFound, String qidList, boolean isFailOnCVEs, String cveList, boolean isFailOnSoftware, String softwareList, boolean isPotentialVulnsToBeChecked, String imageIds, String webhookUrl, boolean isExcludeConditions, String excludeBy, String excludeList, boolean failByCvss, String cvssVersion, String cvssThreshold, String platform, String dockerUrl, String dockerCert) {
        if (useGlobalConfig) {
            this.imageIds = imageIds;
            this.useGlobalConfig = useGlobalConfig;
        }
        if (useLocalConfig) {
            this.useLocalConfig = useLocalConfig;
            this.imageIds = imageIds;
            this.apiServer = apiServer;
            this.platform = platform;
            if (apiUser != null && !apiUser.isEmpty()) {
                this.apiUser = apiUser;
            }
            if (apiPass != null && !apiPass.isEmpty()) {
                this.apiPass = Secret.fromString((String)apiPass);
            }
            this.credentialsId = credentialsId;
            this.pollingInterval = pollingInterval;
            this.vulnsTimeout = vulnsTimeout;
            this.isFailOnSevereVulns = isFailOnSevereVulns;
            this.isSev1Vulns = isSev1Vulns;
            if (isSev1Vulns && severity1Limit > 0) {
                this.severity1Limit = severity1Limit;
            }
            this.isSev2Vulns = isSev2Vulns;
            if (isSev2Vulns && severity2Limit > 0) {
                this.severity2Limit = severity2Limit;
            }
            this.isSev3Vulns = isSev3Vulns;
            if (isSev3Vulns && severity3Limit > 0) {
                this.severity3Limit = severity3Limit;
            }
            this.isSev4Vulns = isSev4Vulns;
            if (isSev4Vulns && severity4Limit > 0) {
                this.severity4Limit = severity4Limit;
            }
            this.isSev5Vulns = isSev5Vulns;
            if (isSev5Vulns && severity5Limit > 0) {
                this.severity5Limit = severity5Limit;
            }
            this.useProxy = useProxy;
            if (useProxy) {
                this.proxyCredentialsId = proxyCredentialsId;
                if (proxyServer != null && !proxyServer.isEmpty()) {
                    this.proxyServer = proxyServer;
                }
                this.proxyPort = proxyPort;
                if (proxyUsername != null && !proxyUsername.isEmpty()) {
                    this.proxyUsername = proxyUsername;
                }
                if (proxyPassword != null && !proxyPassword.isEmpty()) {
                    this.proxyPassword = Secret.fromString((String)proxyPassword);
                }
            }
            this.isFailOnQidFound = isFailOnQidFound;
            if (isFailOnQidFound && qidList != null && !StringUtils.isBlank((String)qidList)) {
                this.qidList = qidList;
            }
            this.isFailOnCVEs = isFailOnCVEs;
            if (isFailOnCVEs && cveList != null && !StringUtils.isBlank((String)cveList)) {
                this.cveList = cveList;
            }
            this.isFailOnSoftware = isFailOnSoftware;
            if (isFailOnSoftware && softwareList != null && !StringUtils.isBlank((String)softwareList)) {
                this.softwareList = softwareList;
            }
            this.isExcludeConditions = isExcludeConditions;
            if (isExcludeConditions) {
                this.excludeBy = excludeBy;
                this.excludeList = excludeList;
            }
            this.isPotentialVulnsToBeChecked = isPotentialVulnsToBeChecked;
            if (failByCvss) {
                this.failByCvss = failByCvss;
                this.cvssVersion = cvssVersion;
                this.cvssThreshold = cvssThreshold;
            }
        }
        if (!StringUtils.isBlank((String)webhookUrl)) {
            this.webhookUrl = webhookUrl;
        }
        if (!StringUtils.isBlank((String)dockerUrl)) {
            this.dockerUrl = dockerUrl;
        }
        if (!StringUtils.isBlank((String)dockerCert)) {
            this.dockerCert = dockerCert;
        }
    }

    public GetImageVulnsNotifier() {
    }

    public String getPlatform() {
        return this.platform;
    }

    @DataBoundSetter
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getApiUser() {
        return this.apiUser;
    }

    @DataBoundSetter
    public void setApiUser(String apiUser) {
        this.apiUser = apiUser;
    }

    public Secret getApiPass() {
        return this.apiPass;
    }

    @DataBoundSetter
    public void setApiPass(String apiPass) {
        this.apiPass = Secret.fromString((String)apiPass);
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @DataBoundSetter
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public Secret getProxyPassword() {
        return this.proxyPassword;
    }

    @DataBoundSetter
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = Secret.fromString((String)proxyPassword);
    }

    public boolean getFailByCvss() {
        return this.failByCvss;
    }

    @DataBoundSetter
    public void setFailByCvss(boolean failByCvss) {
        this.failByCvss = failByCvss;
    }

    public String getCvssVersion() {
        return this.cvssVersion;
    }

    @DataBoundSetter
    public void setCvssVersion(String cvssVersion) {
        this.cvssVersion = cvssVersion;
    }

    public String getCvssThreshold() {
        return this.cvssThreshold;
    }

    @DataBoundSetter
    public void setCvssThreshold(String cvssThreshold) {
        this.cvssThreshold = cvssThreshold;
    }

    @DataBoundSetter
    public void setSoftwareList(String list) {
        this.softwareList = list;
    }

    public boolean getIsFailOnSoftware() {
        return this.isFailOnSoftware;
    }

    @DataBoundSetter
    public void setIsFailOnSoftware(boolean software) {
        this.isFailOnSoftware = software;
    }

    public String getSoftwareList() {
        return this.softwareList;
    }

    public boolean getIsExcludeConditions() {
        return this.isExcludeConditions;
    }

    @DataBoundSetter
    public void setIsExcludeConditions(boolean isExcludeConditions) {
        this.isExcludeConditions = isExcludeConditions;
    }

    public String getExcludeBy() {
        return this.excludeBy;
    }

    @DataBoundSetter
    public void setExcludeBy(String excludeBy) {
        this.excludeBy = excludeBy;
    }

    public String getExcludeList() {
        return this.excludeList;
    }

    @DataBoundSetter
    public void setExcludeList(String excludeList) {
        this.excludeList = excludeList;
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    @DataBoundSetter
    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    @DataBoundSetter
    public void setPollingInterval(String pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    @DataBoundSetter
    public void setVulnsTimeout(String vulnsTimeout) {
        this.vulnsTimeout = vulnsTimeout;
    }

    @DataBoundSetter
    public void setIsFailOnSevereVulns(boolean isFailOnSevereVulns) {
        this.isFailOnSevereVulns = isFailOnSevereVulns;
    }

    public boolean getIsFailOnQidFound() {
        return this.isFailOnQidFound;
    }

    @DataBoundSetter
    public void setIsFailOnQidFound(boolean isFailOnQidFound) {
        this.isFailOnQidFound = isFailOnQidFound;
    }

    public String getQidList() {
        return this.qidList;
    }

    @DataBoundSetter
    public void setQidList(String qidList) {
        this.qidList = qidList;
    }

    public boolean getIsFailOnCVEs() {
        return this.isFailOnCVEs;
    }

    @DataBoundSetter
    public void setIsFailOnCVEs(boolean CVEs) {
        this.isFailOnCVEs = CVEs;
    }

    public String getCveList() {
        return this.cveList;
    }

    @DataBoundSetter
    public void setCveList(String list) {
        this.cveList = list;
    }

    public boolean getIsPotentialVulnsToBeChecked() {
        return this.isPotentialVulnsToBeChecked;
    }

    @DataBoundSetter
    public void setIsPotentialVulnsToBeChecked(boolean isPotentialVulnsToBeChecked) {
        this.isPotentialVulnsToBeChecked = isPotentialVulnsToBeChecked;
    }

    @DataBoundSetter
    public void setSeverity1Limit(int severity1Limit) {
        this.severity1Limit = severity1Limit;
    }

    public int getSeverity1Limit() {
        return this.severity1Limit;
    }

    @DataBoundSetter
    public void setSeverity2Limit(int severity2Limit) {
        this.severity2Limit = severity2Limit;
    }

    public int getSeverity2Limit() {
        return this.severity2Limit;
    }

    @DataBoundSetter
    public void setSeverity3Limit(int severity3Limit) {
        this.severity3Limit = severity3Limit;
    }

    public int getSeverity3Limit() {
        return this.severity3Limit;
    }

    @DataBoundSetter
    public void setSeverity4Limit(int severity4Limit) {
        this.severity4Limit = severity4Limit;
    }

    public int getSeverity4Limit() {
        return this.severity4Limit;
    }

    @DataBoundSetter
    public void setSeverity5Limit(int severity5Limit) {
        this.severity5Limit = severity5Limit;
    }

    public int getSeverity5Limit() {
        return this.severity5Limit;
    }

    @DataBoundSetter
    public void setIsSev1Vulns(boolean isSev1Vulns) {
        this.isSev1Vulns = isSev1Vulns;
    }

    public boolean getIsSev1Vulns() {
        return this.isSev1Vulns;
    }

    @DataBoundSetter
    public void setIsSev2Vulns(boolean isSev2Vulns) {
        this.isSev2Vulns = isSev2Vulns;
    }

    public boolean getIsSev2Vulns() {
        return this.isSev2Vulns;
    }

    @DataBoundSetter
    public void setIsSev3Vulns(boolean isSev3Vulns) {
        this.isSev3Vulns = isSev3Vulns;
    }

    public boolean getIsSev3Vulns() {
        return this.isSev3Vulns;
    }

    @DataBoundSetter
    public void setIsSev4Vulns(boolean isSev4Vulns) {
        this.isSev4Vulns = isSev4Vulns;
    }

    public boolean getIsSev4Vulns() {
        return this.isSev4Vulns;
    }

    @DataBoundSetter
    public void setIsSev5Vulns(boolean isSev5Vulns) {
        this.isSev5Vulns = isSev5Vulns;
    }

    public boolean getIsSev5Vulns() {
        return this.isSev5Vulns;
    }

    public boolean getIsFailOnSevereVulns() {
        return this.isFailOnSevereVulns;
    }

    public String getPollingInterval() {
        return this.pollingInterval;
    }

    public String getVulnsTimeout() {
        return this.vulnsTimeout;
    }

    public String getApiServer() {
        return this.apiServer;
    }

    @DataBoundSetter
    public void setApiServer(String apiServer) {
        this.apiServer = apiServer.trim();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    @DataBoundSetter
    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    @DataBoundSetter
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyCredentialsId() {
        return this.proxyCredentialsId;
    }

    @DataBoundSetter
    public void setProxyCredentialsId(String proxyCredentialsId) {
        this.proxyCredentialsId = proxyCredentialsId;
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    @DataBoundSetter
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @DataBoundSetter
    public void setImageIds(String images) {
        this.imageIds = images;
    }

    public String getImageIds() {
        return this.imageIds;
    }

    @DataBoundSetter
    public void setDockerUrl(String dockerUrl) {
        this.dockerUrl = dockerUrl;
    }

    public String getDockerUrl() {
        return this.dockerUrl;
    }

    @DataBoundSetter
    public void setDockerCert(String dockerCert) {
        this.dockerCert = dockerCert;
    }

    public String getDockerCert() {
        return this.dockerCert;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundSetter
    public void setUseLocalConfig(boolean useLocalConfig) {
        this.useLocalConfig = useLocalConfig;
    }

    @DataBoundSetter
    public void setUseGlobalConfig(boolean useGlobalConfig) {
        this.useGlobalConfig = useGlobalConfig;
    }

    public boolean getUseLocalConfig() {
        return this.useLocalConfig;
    }

    public boolean getUseGlobalConfig() {
        return this.useGlobalConfig;
    }

    public String getPluginVersion() throws IOException {
        String path = GetImageVulnsNotifier.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String versionName = path.split("qualys-cs_")[1];
        String version = versionName.substring(0, versionName.length() - 4);
        return version;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        logger.info("Triggered build #" + run.number);
        try {
            String version = this.getPluginVersion();
            taskListener.getLogger().println("Qualys Container Scanning Connector(version-" + version + ") started.");
        }
        catch (Exception e) {
            taskListener.getLogger().println("Qualys Container Scanning Connector started.");
            logger.info("Could not read version from pom.xml. Reason: " + e.getMessage());
        }
        this.setConfigOptions(taskListener, run);
        this.criteriaObj = this.getCriteriaAsJsonObject();
        String imageIdCSV = null;
        try {
            imageIdCSV = this.getDockerImageId(run.getEnvironment(taskListener), taskListener.getLogger());
        }
        catch (Exception e1) {
            taskListener.getLogger().println("Exception while reading environment variable IMAGE_ID: " + e1.getMessage());
        }
        if (this.imageIds != null && !this.imageIds.isEmpty()) {
            String[] imageList = this.imageIds.split(",");
            try {
                Job project = run.getParent();
                this.getImageScanResult(run, taskListener, new ArrayList<String>(Arrays.asList(imageList)), (Item)project, filePath.absolutize(), launcher);
            }
            catch (QualysEvaluationException exc) {
                throw new AbortException(exc.getMessage());
            }
            catch (Exception e) {
                throw new AbortException(e.getMessage());
            }
        } else if (StringUtils.isNotBlank((String)imageIdCSV)) {
            taskListener.getLogger().println("IMAGE_ID read from EnvVars is " + imageIdCSV);
            String[] imageList = imageIdCSV.split(",");
            try {
                Job project = run.getParent();
                this.getImageScanResult(run, taskListener, new ArrayList<String>(Arrays.asList(imageList)), (Item)project, filePath.absolutize(), launcher);
            }
            catch (QualysEvaluationException exc) {
                throw new AbortException(exc.getMessage());
            }
            catch (Exception e) {
                throw new AbortException(e.getMessage());
            }
        } else {
            taskListener.getLogger().println("No image ids found!");
            throw new AbortException("Image IDs can't be set to null or empty.");
        }
    }

    public void setConfigOptions(TaskListener listener, Run<?, ?> run) throws AbortException {
        JsonObject json;
        if (this.useGlobalConfig) {
            this.apiServer = QualysGlobalConfig.get().getApiServer();
            this.apiServer = this.apiServer.trim();
            this.credentialsId = QualysGlobalConfig.get().getCredentialsId();
            if (StringUtils.isEmpty((String)this.credentialsId) && StringUtils.isEmpty((String)this.apiServer)) {
                throw new AbortException("This Job is configured to use Global Configuration but Qualys Credentials/API Server fields are set to empty in Global configuration!");
            }
            this.useProxy = QualysGlobalConfig.get().getUseProxy();
            this.pollingInterval = QualysGlobalConfig.get().getPollingInterval();
            this.vulnsTimeout = QualysGlobalConfig.get().getVulnsTimeout();
            this.severity1Limit = QualysGlobalConfig.get().getSeverity1Limit();
            this.severity2Limit = QualysGlobalConfig.get().getSeverity2Limit();
            this.severity3Limit = QualysGlobalConfig.get().getSeverity3Limit();
            this.severity4Limit = QualysGlobalConfig.get().getSeverity4Limit();
            this.severity5Limit = QualysGlobalConfig.get().getSeverity5Limit();
            this.isSev1Vulns = QualysGlobalConfig.get().getIsSev1Vulns();
            this.isSev2Vulns = QualysGlobalConfig.get().getIsSev2Vulns();
            this.isSev3Vulns = QualysGlobalConfig.get().getIsSev3Vulns();
            this.isSev4Vulns = QualysGlobalConfig.get().getIsSev4Vulns();
            this.isSev5Vulns = QualysGlobalConfig.get().getIsSev5Vulns();
            this.proxyServer = QualysGlobalConfig.get().getProxyServer();
            this.proxyPort = QualysGlobalConfig.get().getProxyPort();
            this.proxyCredentialsId = QualysGlobalConfig.get().getProxyCredentialsId();
            this.proxyPassword = QualysGlobalConfig.get().getProxyPassword();
            this.proxyUsername = QualysGlobalConfig.get().getProxyUsername();
            this.isFailOnQidFound = QualysGlobalConfig.get().getIsFailOnQidFound();
            this.qidList = QualysGlobalConfig.get().getQidList();
            this.isFailOnCVEs = QualysGlobalConfig.get().getIsFailOnCVEs();
            this.cveList = QualysGlobalConfig.get().getCveList();
            this.isFailOnSoftware = QualysGlobalConfig.get().getIsFailOnSoftware();
            this.softwareList = QualysGlobalConfig.get().getSoftwareList();
            this.isPotentialVulnsToBeChecked = QualysGlobalConfig.get().getIsPotentialVulnsToBeChecked();
            this.isExcludeConditions = QualysGlobalConfig.get().getIsExcludeConditions();
            this.excludeBy = QualysGlobalConfig.get().getExcludeBy();
            this.excludeList = QualysGlobalConfig.get().getExcludeList();
            this.failByCvss = QualysGlobalConfig.get().getFailByCvss();
            this.cvssVersion = QualysGlobalConfig.get().getCvssVersion();
            this.cvssThreshold = QualysGlobalConfig.get().getCvssThreshold();
            json = this.configToJson();
            listener.getLogger().println("Using Global configuration settings for Qualys Container Security step : " + json.toString());
            logger.info("Using Global configuration settings for Qualys Container Security step : " + json.toString());
        } else {
            json = this.configToJson();
            listener.getLogger().println("Using Job Specific configuration settings for Qualys Container Security step : " + json.toString());
            logger.info("Using Job Specific configuration settings for Qualys Container Security step  : " + json.toString());
        }
        boolean bl = this.isFailOnSevereVulns = this.isSev1Vulns || this.isSev2Vulns || this.isSev3Vulns || this.isSev4Vulns || this.isSev5Vulns;
        if (this.webhookUrl != null && !StringUtils.isBlank((String)this.webhookUrl)) {
            logger.info("Using Job Specific Webhook URL settings : " + this.webhookUrl);
            listener.getLogger().println("Using Job Specific Webhook URL settings : " + this.webhookUrl);
        } else {
            String url = QualysGlobalConfig.get().getWebhookUrl();
            if (url != null && !StringUtils.isBlank((String)url)) {
                this.webhookUrl = url;
                logger.info("Using Global Webhook URL settings : " + this.webhookUrl);
                listener.getLogger().println("Using Global Webhook URL settings : " + this.webhookUrl);
            } else {
                logger.info("No webhook configured.");
                listener.getLogger().println("No webhook configured.");
            }
        }
        if (this.dockerUrl != null && !StringUtils.isBlank((String)this.dockerUrl)) {
            logger.info("Using Job Specific Docker Url/Nerdctl binary path settings : " + this.dockerUrl);
            listener.getLogger().println("Using Job Specific Docker Url/Nerdctl binary path settings : " + this.dockerUrl);
            if (this.dockerCert != null && !StringUtils.isBlank((String)this.dockerCert)) {
                logger.info("Using Job Specific Docker cert settings : " + this.dockerCert);
                listener.getLogger().println("Using Job Specific Docker cert settings : " + this.dockerCert);
            }
        } else {
            String dockerUrlConf = QualysGlobalConfig.get().getDockerUrl();
            if (StringUtils.isEmpty((String)dockerUrlConf)) {
                this.dockerUrl = "unix:///var/run/docker.sock";
            } else {
                this.dockerUrl = dockerUrlConf;
                logger.info("Using Global Docker Url/Nerdctl binary path settings : " + this.dockerUrl);
                listener.getLogger().println("Using Global Docker Url/Nerdctl binary path settings : " + this.dockerUrl);
            }
            String dockerCertConf = QualysGlobalConfig.get().getDockerCert();
            if (!StringUtils.isEmpty((String)dockerCertConf)) {
                this.dockerCert = dockerCertConf;
                if (this.dockerCert != null && !StringUtils.isBlank((String)this.dockerCert)) {
                    logger.info("Using Global Docker Cert settings : " + this.dockerCert);
                    listener.getLogger().println("Using Global Docker Cert settings : " + this.dockerCert);
                }
            }
        }
    }

    public JsonObject getCriteriaAsJsonObject() {
        JsonArray empty;
        JsonObject obj = new JsonObject();
        obj.addProperty("webhookUrl", this.webhookUrl);
        obj.addProperty("dockerUrl", this.dockerUrl);
        obj.addProperty("dockerCert", this.dockerCert);
        JsonObject dataCollectionObj = new JsonObject();
        dataCollectionObj.addProperty("frequency", this.pollingInterval);
        dataCollectionObj.addProperty("timeout", this.vulnsTimeout);
        obj.add("dataCollection", (JsonElement)dataCollectionObj);
        JsonObject failConditionsObj = new JsonObject();
        Gson gson = new Gson();
        if (this.isFailOnQidFound) {
            if (this.qidList == null || this.qidList.isEmpty()) {
                empty = new JsonArray();
                failConditionsObj.add("qids", (JsonElement)empty);
            } else {
                List<String> qids = Arrays.asList(this.qidList.split(","));
                JsonElement element = gson.toJsonTree(qids, TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
                failConditionsObj.add("qids", element);
            }
        }
        if (this.isFailOnCVEs) {
            if (this.cveList == null || this.cveList.isEmpty()) {
                empty = new JsonArray();
                failConditionsObj.add("cves", (JsonElement)empty);
            } else {
                List<String> cves = Arrays.asList(this.cveList.split(","));
                JsonElement element2 = gson.toJsonTree(cves, TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
                failConditionsObj.add("cves", element2);
            }
        }
        if (this.failByCvss) {
            if ((this.cvssThreshold == null || this.cvssThreshold.isEmpty()) && (this.cvssVersion == null || this.cvssVersion.isEmpty())) {
                empty = new JsonArray();
                failConditionsObj.add("version", (JsonElement)empty);
                failConditionsObj.add("configured", (JsonElement)empty);
            } else {
                JsonObject cvssObj = new JsonObject();
                cvssObj.addProperty("version", this.cvssVersion);
                cvssObj.addProperty("configured", (Number)Double.parseDouble(this.cvssThreshold));
                failConditionsObj.add("cvss", (JsonElement)cvssObj);
            }
        }
        empty = new JsonArray();
        failConditionsObj.add("software", (JsonElement)empty);
        if (this.isFailOnSoftware && this.softwareList != null && !this.softwareList.isEmpty()) {
            List<String> softwares = Arrays.asList(this.softwareList.split(","));
            softwares.replaceAll(String::trim);
            JsonElement element2 = gson.toJsonTree(softwares, TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
            failConditionsObj.add("software", element2);
        }
        JsonObject severities = new JsonObject();
        if (this.isSev5Vulns) {
            severities.addProperty("5", (Number)this.severity5Limit);
        }
        if (this.isSev4Vulns) {
            severities.addProperty("4", (Number)this.severity4Limit);
        }
        if (this.isSev3Vulns) {
            severities.addProperty("3", (Number)this.severity3Limit);
        }
        if (this.isSev2Vulns) {
            severities.addProperty("2", (Number)this.severity2Limit);
        }
        if (this.isSev1Vulns) {
            severities.addProperty("1", (Number)this.severity1Limit);
        }
        failConditionsObj.add("severities", (JsonElement)severities);
        if (this.isExcludeConditions) {
            JsonElement element;
            if ("cve".equals(this.excludeBy)) {
                failConditionsObj.addProperty("excludeBy", "cve");
                List<String> cves = Arrays.asList(this.excludeList.split(","));
                element = gson.toJsonTree(cves, TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
                failConditionsObj.add("excludeCVEs", element);
            }
            if ("qid".equals(this.excludeBy)) {
                failConditionsObj.addProperty("excludeBy", "qid");
                List<String> qids = Arrays.asList(this.excludeList.split(","));
                element = gson.toJsonTree(qids, TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType());
                failConditionsObj.add("excludeQids", element);
            }
        }
        failConditionsObj.addProperty("checkPotentialVulns", Boolean.valueOf(this.isPotentialVulnsToBeChecked));
        obj.add("failConditions", (JsonElement)failConditionsObj);
        logger.info("Criteria Object to common library: " + String.valueOf(obj));
        return obj;
    }

    public JsonObject configToJson() {
        JsonObject obj = new JsonObject();
        if (!Objects.isNull(this.apiServer) && !StringUtils.isBlank((String)this.apiServer)) {
            obj.addProperty("apiServer", this.apiServer);
        }
        if (!Objects.isNull(this.platform) && !StringUtils.isBlank((String)this.platform)) {
            obj.addProperty("platform", this.platform);
        }
        if (!Objects.isNull(this.platform) && !this.platform.equalsIgnoreCase("pcp") && Helper.platformsList.containsKey(this.platform)) {
            Map<String, String> platformObj = Helper.platformsList.get(this.platform);
            obj.addProperty("apiServer", platformObj.get("url"));
            this.apiServer = platformObj.get("url");
        }
        obj.addProperty("useProxy", Boolean.valueOf(this.useProxy));
        if (this.proxyServer != null && this.useProxy && !StringUtils.isBlank((String)this.proxyServer)) {
            obj.addProperty("proxyServer", this.proxyServer);
        }
        if (this.useProxy) {
            obj.addProperty("proxyPort", (Number)this.proxyPort);
        }
        if (this.proxyCredentialsId != null && this.useProxy && !StringUtils.isBlank((String)this.proxyCredentialsId)) {
            obj.addProperty("proxyCredentialsId", this.proxyCredentialsId);
        }
        obj.addProperty("pollingInterval", this.pollingInterval);
        obj.addProperty("vulnsTimeout", this.vulnsTimeout);
        if (this.isSev1Vulns) {
            obj.addProperty("isSev1Vulns", Boolean.valueOf(this.isSev1Vulns));
            obj.addProperty("severity1Limit", (Number)this.severity1Limit);
        }
        if (this.isSev2Vulns) {
            obj.addProperty("isSev2Vulns", Boolean.valueOf(this.isSev2Vulns));
            obj.addProperty("severity2Limit", (Number)this.severity2Limit);
        }
        if (this.isSev3Vulns) {
            obj.addProperty("isSev3Vulns", Boolean.valueOf(this.isSev3Vulns));
            obj.addProperty("severity3Limit", (Number)this.severity3Limit);
        }
        if (this.isSev4Vulns) {
            obj.addProperty("isSev4Vulns", Boolean.valueOf(this.isSev4Vulns));
            obj.addProperty("severity4Limit", (Number)this.severity4Limit);
        }
        if (this.isSev5Vulns) {
            obj.addProperty("isSev5Vulns", Boolean.valueOf(this.isSev5Vulns));
            obj.addProperty("severity5Limit", (Number)this.severity5Limit);
        }
        obj.addProperty("isExcludeConditions", Boolean.valueOf(this.isExcludeConditions));
        if (this.isExcludeConditions) {
            obj.addProperty("excludeBy", this.excludeBy);
            if ("qid".equals(this.excludeBy)) {
                obj.addProperty("QidExcludeList", this.excludeList);
            }
            if ("cve".equals(this.excludeBy)) {
                obj.addProperty("CveExcludeList", this.excludeList);
            }
        }
        if (this.failByCvss) {
            obj.addProperty("failByCvss", Boolean.valueOf(this.failByCvss));
            obj.addProperty("cvssVersion", this.cvssVersion);
            obj.addProperty("cvssThreshold", (Number)Double.parseDouble(this.cvssThreshold));
        }
        obj.addProperty("isFailOnQidFound", Boolean.valueOf(this.isFailOnQidFound));
        if (this.isFailOnQidFound) {
            obj.addProperty("qidList", this.qidList);
        }
        obj.addProperty("isFailOnCVEs", Boolean.valueOf(this.isFailOnCVEs));
        if (this.isFailOnCVEs) {
            obj.addProperty("cveList", this.cveList);
        }
        obj.addProperty("isFailOnSoftware", Boolean.valueOf(this.isFailOnSoftware));
        if (this.isFailOnSoftware) {
            if (this.softwareList != null && !this.softwareList.isEmpty()) {
                List<String> softwares = Arrays.asList(this.softwareList.split(","));
                softwares.replaceAll(String::trim);
                obj.addProperty("softwareList", String.join((CharSequence)", ", softwares));
            } else {
                obj.addProperty("softwareList", this.softwareList);
            }
        }
        obj.addProperty("isPotentialVulnsToBeChecked", Boolean.valueOf(this.isPotentialVulnsToBeChecked));
        return obj;
    }

    public void getImageScanResult(Run<?, ?> run, TaskListener listener, ArrayList<String> imageList, Item project, FilePath workspace, Launcher launcher) throws Exception {
        String apiPassVal;
        String apiUserVal;
        QualysAuth auth;
        HashMap<String, String> uniqueImageIdList;
        block20: {
            if (imageList == null || imageList.isEmpty()) {
                listener.getLogger().println("No image ids found.");
                if (this.isFailOnSevereVulns || this.isFailOnQidFound || this.isFailOnCVEs || this.isFailOnSoftware || this.failByCvss) {
                    throw new Exception("No image ids found");
                }
                return;
            }
            LinkedHashSet<String> imageSet = new LinkedHashSet<String>(imageList);
            uniqueImageIdList = this.processImages(imageSet, listener, launcher);
            auth = new QualysAuth();
            apiUserVal = "";
            apiPassVal = "";
            if (!StringUtils.isBlank((String)this.apiUser)) {
                apiUserVal = this.apiUser;
                apiPassVal = this.apiPass.getPlainText();
            } else {
                try {
                    logger.info("Using qualys API Server URL: " + this.apiServer);
                    StandardCredentials credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.apiServer).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
                    if (credentials != null) {
                        if (credentials instanceof StandardUsernamePasswordCredentials) {
                            StandardUsernamePasswordCredentials userPass = (StandardUsernamePasswordCredentials)credentials;
                            apiUserVal = userPass.getUsername();
                            apiPassVal = userPass.getPassword().getPlainText();
                            auth.setQualysCredentials(this.apiServer, AuthType.Basic, apiUserVal, apiPassVal, "", "");
                            if (apiPassVal.trim().equals("") || apiUserVal.trim().equals("")) {
                                throw new Exception("Username and/or Password field is empty for credentials id: " + this.credentialsId);
                            }
                            break block20;
                        }
                        if (credentials instanceof OAuthCredential) {
                            OAuthCredential oauth = (OAuthCredential)credentials;
                            String clientId = oauth.getClientId();
                            String clientSecret = oauth.getClientSecret();
                            auth.setQualysCredentials(this.apiServer, AuthType.OAuth, "", "", clientId, clientSecret);
                            break block20;
                        }
                        throw new IllegalArgumentException("Unsupported credential type: " + String.valueOf(credentials.getClass()));
                    }
                    throw new Exception("Could not read credentials for API login : credentials id: " + this.credentialsId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Exception("Invalid credentials! " + e.getMessage());
                }
            }
        }
        String proxyUsernameVal = "";
        String proxyPasswordVal = "";
        Pattern pattern = Pattern.compile("\\{env.(.*?)\\}");
        Matcher matcher = pattern.matcher(apiUserVal);
        if (matcher.find()) {
            try {
                apiUserVal = (String)run.getEnvironment(listener).get((Object)matcher.group(1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            listener.getLogger().println("Environment variable = " + matcher.group(1) + ", value = " + apiUserVal);
        }
        if ((matcher = pattern.matcher(apiPassVal)).find()) {
            try {
                apiPassVal = (String)run.getEnvironment(listener).get((Object)matcher.group(1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            listener.getLogger().println("Environment variable = " + matcher.group(1) + ", value = " + apiPassVal);
        }
        if (this.useProxy) {
            StandardUsernamePasswordCredentials credential;
            if (StringUtils.isNotBlank((String)this.proxyUsername) && this.proxyPassword != null) {
                proxyPasswordVal = this.proxyPassword.getPlainText();
                proxyUsernameVal = this.proxyUsername;
            }
            if (StringUtils.isNotEmpty((String)this.proxyCredentialsId) && (credential = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.apiServer).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.proxyCredentialsId))) != null) {
                proxyUsernameVal = credential.getUsername();
                proxyPasswordVal = credential.getPassword().getPlainText();
            }
            auth.setProxyCredentials(this.proxyServer, proxyUsernameVal, proxyPasswordVal, this.proxyPort);
        }
        int pollingIntervalForVulns = this.setTimeoutInSec("polling", 30, this.pollingInterval, listener);
        int timeoutToFetchVulnsInMillis = this.setTimeoutInSec("vulns", 600, this.vulnsTimeout, listener);
        QualysCSClient client = new QualysCSClient(auth, listener.getLogger());
        boolean isFailConditionsConfigured = false;
        if (this.isFailOnCVEs || this.isFailOnQidFound || this.isFailOnSevereVulns || this.isFailOnSoftware || this.failByCvss) {
            isFailConditionsConfigured = true;
        }
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration(this.useProxy, this.proxyServer, this.proxyPort, proxyUsernameVal, proxyPasswordVal);
        GetImageVulns executor = new GetImageVulns(client, auth, run, listener, pollingIntervalForVulns, timeoutToFetchVulnsInMillis, this.webhookUrl, this.criteriaObj, isFailConditionsConfigured, proxyConfiguration);
        listener.getLogger().println("Qualys task - Started fetching image scan results.");
        executor.getAndProcessDockerImagesScanResult(uniqueImageIdList, this.taggingTime);
        listener.getLogger().println("Qualys task - Finished.");
    }

    private HashMap<String, String> processImages(Set<String> imageList, TaskListener listener, Launcher launcher) throws IOException, InterruptedException {
        Boolean isCICDSensorRunning;
        HashMap<String, String> finalImagesList = new HashMap<String, String>();
        ArrayList<String> listOfImageIds = new ArrayList<String>();
        listener.getLogger().println("Checking if Qualys CS sensor is running on same instance using: " + this.dockerUrl + (String)(StringUtils.isNotBlank((String)this.dockerCert) ? " & docker Cert path : " + this.dockerCert + "." : ""));
        VirtualChannel channel = launcher.getChannel();
        Boolean bl = isCICDSensorRunning = channel == null ? null : (Boolean)channel.call((Callable)new CheckSensorSlaveCallable(this.dockerUrl, this.dockerCert, listener));
        if (isCICDSensorRunning == null) {
            throw new AbortException("Unable to launch the sensor check operation using SlaveCallable");
        }
        listener.getLogger().println("*** Qualys CS sensor container is up and running!! ***");
        if (!isCICDSensorRunning.booleanValue()) {
            throw new AbortException("Qualys CS sensor is not deployed in CICD mode");
        }
        listener.getLogger().println("*** Qualys CS sensor is deployed in CICD mode ***");
        listener.getLogger().println("For Image tagging, using " + (Helper.isRuntimeDocker(this.dockerUrl) ? "docker url: " : "Nerdctl binary path") + this.dockerUrl + (String)(StringUtils.isNotBlank((String)this.dockerCert) ? " & docker Cert path : " + this.dockerCert + "." : ""));
        Instant instant = Instant.now();
        this.taggingTime = instant.getEpochSecond();
        listener.getLogger().println("***Epoch Time in seconds before tagging = " + this.taggingTime);
        for (String OriginalImage : imageList) {
            String imageSha;
            VirtualChannel channel2;
            String image = OriginalImage.trim();
            try {
                channel2 = launcher.getChannel();
                imageSha = channel2 == null ? null : (String)channel2.call((Callable)new ImageShaExtractSlaveCallable(image, this.dockerUrl, this.dockerCert, listener));
            }
            catch (Exception e) {
                e.printStackTrace(listener.getLogger());
                throw e;
            }
            if (imageSha == null) continue;
            if (!listOfImageIds.contains(imageSha)) {
                listOfImageIds.add(imageSha);
                finalImagesList.put(imageSha, image);
                logger.info("Adding qualys_scan_target tag to the image " + image);
                listener.getLogger().println("Adding qualys specific tag to the image " + image);
                try {
                    channel2 = launcher.getChannel();
                    if (channel2 == null) continue;
                    channel2.call((Callable)new TagImageSlaveCallable(image, imageSha, this.dockerUrl, this.dockerCert, listener));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(listener.getLogger());
                    throw e;
                }
            }
            listener.getLogger().println(image + " has same image Id as one of the configured image: " + finalImagesList.get(imageSha) + ". So processing it only once.");
        }
        return finalImagesList;
    }

    private int setTimeoutInSec(String timeoutType, int defaultTimeoutInSec, String timeout, TaskListener listener) {
        int timeoutInSec = defaultTimeoutInSec;
        if (timeout != null && !timeout.isEmpty()) {
            try {
                String[] numbers = timeout.split("\\*");
                int timeoutInSecs = 1;
                for (int i = 0; i < numbers.length; ++i) {
                    timeoutInSecs = (int)((long)timeoutInSecs * Long.parseLong(numbers[i]));
                }
                if (timeoutType.equals("polling") && timeoutInSecs < 30) {
                    listener.getLogger().println("Polling interval timeout cannot be less than 30 seconds. Using default polling interval of " + defaultTimeoutInSec + " seconds.");
                    return defaultTimeoutInSec;
                }
                return timeoutInSecs;
            }
            catch (Exception e) {
                listener.getLogger().println("Invalid " + timeoutType + " time value. Cannot parse -" + e.getMessage());
                listener.getLogger().println("Using default period of " + defaultTimeoutInSec + " seconds for " + timeoutType + " data");
            }
        }
        return timeoutInSec;
    }

    private String getDockerImageId(EnvVars envVars, PrintStream logger) {
        String imageId = "";
        try {
            if (envVars == null || envVars.isEmpty()) {
                return imageId;
            }
            imageId = envVars.get("IMAGE_ID", "");
        }
        catch (Exception e) {
            logger.println(e.getMessage());
        }
        return imageId;
    }

    @Extension
    @Symbol(value={"getImageVulnsFromQualys"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final String URL_REGEX = "^(https?)://[-a-zA-Z0-9+&#/%?=~_|!:,.;]*[-a-zA-Z0-9+&#/%=~_|]";
        private static final String PROXY_REGEX = "^((https?)://)?[-a-zA-Z0-9+&#/%?=~_|!,.;]*[-a-zA-Z0-9+&#/%=~_|]";
        private static final String TIMEOUT_PERIOD_REGEX = "^(\\d+[*]?)*(?<!\\*)$";

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Scan container images with Qualys CS";
        }

        public FormValidation doCheckCveList(@QueryParameter String cveList) {
            if (!Helper.isValidCVEList(cveList)) {
                return FormValidation.error((String)"Enter valid CVEs!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiServer(@QueryParameter String apiServer) {
            try {
                Pattern patt = Pattern.compile(URL_REGEX);
                Matcher matcher = patt.matcher(apiServer.trim());
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Server name is not valid!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckWebhookUrl(@QueryParameter String webhookUrl) {
            try {
                if (StringUtils.isEmpty((String)webhookUrl)) {
                    return FormValidation.ok();
                }
                Pattern patt = Pattern.compile(URL_REGEX);
                Matcher matcher = patt.matcher(webhookUrl);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Webhook Url is not valid!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckCvssThreshold(@QueryParameter String cvssThreshold) {
            block6: {
                try {
                    if (cvssThreshold == null || cvssThreshold.isEmpty()) break block6;
                    double cvssDouble = 0.0;
                    try {
                        cvssDouble = Double.parseDouble(cvssThreshold);
                        if (cvssDouble < 0.0 || cvssDouble > 10.0) {
                            return FormValidation.error((String)"Please enter a number in range of 0.0 to 10.0");
                        }
                    }
                    catch (NumberFormatException e) {
                        return FormValidation.error((String)("Input is not a valid number. " + e.getMessage()));
                    }
                }
                catch (RuntimeException e) {
                    return FormValidation.error((String)"Enter valid number!");
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Enter valid number!");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiUser(@QueryParameter String apiUser) {
            try {
                if (apiUser.trim().equals("")) {
                    return FormValidation.error((String)"API Username cannot be empty.");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckApiPass(@QueryParameter String apiPass) {
            try {
                if (apiPass.trim().equals("")) {
                    return FormValidation.error((String)"API Password cannot be empty.");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckPollingInterval(@QueryParameter String pollingInterval) {
            try {
                if (pollingInterval.trim().equals("")) {
                    return FormValidation.ok();
                }
                Pattern patt = Pattern.compile(TIMEOUT_PERIOD_REGEX);
                Matcher matcher = patt.matcher(pollingInterval);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Timeout period is not valid!");
                }
                try {
                    String[] numbers = pollingInterval.split("\\*");
                    long timeoutInSecs = 1L;
                    for (int i = 0; i < numbers.length; ++i) {
                        timeoutInSecs *= Long.parseLong(numbers[i]);
                    }
                    if (timeoutInSecs < 30L) {
                        return FormValidation.error((String)"Polling Interval Should not be less than 30 seconds");
                    }
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Please enter valid Polling Interval");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)("Timeout period string : " + pollingInterval + ", reason = " + String.valueOf(e)));
            }
        }

        public FormValidation doCheckVulnsTimeout(@QueryParameter String vulnsTimeout) {
            try {
                if (vulnsTimeout.trim().equals("")) {
                    return FormValidation.ok();
                }
                Pattern patt = Pattern.compile(TIMEOUT_PERIOD_REGEX);
                Matcher matcher = patt.matcher(vulnsTimeout);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Timeout period is not valid!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)("Timeout period string : " + vulnsTimeout + ", reason = " + String.valueOf(e)));
            }
        }

        public FormValidation doCheckSeverity1Limit(@QueryParameter String severity1Limit) {
            try {
                int severity1LimitInt;
                if (severity1Limit != null && !severity1Limit.isEmpty() && (severity1LimitInt = Integer.parseInt(severity1Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSeverity2Limit(@QueryParameter String severity2Limit) {
            try {
                int severity2LimitInt;
                if (severity2Limit != null && !severity2Limit.isEmpty() && (severity2LimitInt = Integer.parseInt(severity2Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSeverity3Limit(@QueryParameter String severity3Limit) {
            try {
                int severity3LimitInt;
                if (severity3Limit != null && !severity3Limit.isEmpty() && (severity3LimitInt = Integer.parseInt(severity3Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSeverity4Limit(@QueryParameter String severity4Limit) {
            try {
                int severity4LimitInt;
                if (severity4Limit != null && !severity4Limit.isEmpty() && (severity4LimitInt = Integer.parseInt(severity4Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSeverity5Limit(@QueryParameter String severity5Limit) {
            try {
                int severity5LimitInt;
                if (severity5Limit != null && !severity5Limit.isEmpty() && (severity5LimitInt = Integer.parseInt(severity5Limit)) < 0) {
                    return FormValidation.error((String)"Please enter a number greater than or equal to 0.");
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid number!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQidList(@QueryParameter String qidList) {
            if (qidList == null || qidList.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                String[] qidsString;
                for (String qid : qidsString = qidList.split(",")) {
                    if (qid.contains("-")) {
                        int lastInRange;
                        String[] range = qid.split("-");
                        int firstInRange = Integer.parseInt(range[0]);
                        if (firstInRange <= (lastInRange = Integer.parseInt(range[1]))) continue;
                        return FormValidation.error((String)"Enter valid QID range");
                    }
                    Integer.parseInt(qid);
                }
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid QID range/numbers");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQidExcludeList(@QueryParameter String qidExcludeList) {
            if (qidExcludeList == null || qidExcludeList.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                String[] qidsString;
                for (String qid : qidsString = qidExcludeList.split(",")) {
                    if (qid.contains("-")) {
                        int lastInRange;
                        String[] range = qid.split("-");
                        int firstInRange = Integer.parseInt(range[0]);
                        if (firstInRange <= (lastInRange = Integer.parseInt(range[1]))) continue;
                        return FormValidation.error((String)"Enter valid QID range");
                    }
                    Integer.parseInt(qid);
                }
            }
            catch (RuntimeException e) {
                return FormValidation.error((String)"Enter valid QID range/numbers");
            }
            catch (Exception e) {
                return FormValidation.error((String)"Enter valid QID range/numbers");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckConnection(@QueryParameter String apiServer, @QueryParameter String credentialsId, @QueryParameter String proxyServer, @QueryParameter String proxyPort, @QueryParameter String proxyCredentialsId, @QueryParameter boolean useProxy, @AncestorInPath Item item) {
            item.checkPermission(Item.CONFIGURE);
            String apiUser = "";
            String apiPass = "";
            String proxyUsername = "";
            String proxyPassword = "";
            try {
                apiServer = apiServer.trim();
                apiServer = QualysGlobalConfig.get().getPortalUrl(apiServer);
                logger.info("Using qualys API Server URL: " + apiServer);
                FormValidation apiServerValidation = this.doCheckApiServer(apiServer);
                FormValidation proxyServerValidation = this.doCheckProxyServer(proxyServer);
                FormValidation proxyPortValidation = this.doCheckProxyPort(proxyPort);
                ArrayList<String> invalidFields = new ArrayList<String>();
                if (apiServerValidation != FormValidation.ok()) {
                    invalidFields.add("API Server URL");
                }
                if (StringUtils.isBlank((String)credentialsId)) {
                    invalidFields.add("Credentials");
                }
                if (useProxy) {
                    if (proxyServerValidation != FormValidation.ok()) {
                        invalidFields.add("Proxy Server");
                    }
                    if (proxyPortValidation != FormValidation.ok()) {
                        invalidFields.add("Proxy Port");
                    }
                }
                if (!invalidFields.isEmpty()) {
                    return FormValidation.error((String)("Invalid inputs for the following fields: " + String.join((CharSequence)", ", invalidFields)));
                }
                QualysAuth auth = new QualysAuth();
                if (StringUtils.isNotEmpty((String)credentialsId)) {
                    StandardCredentials credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)item, null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
                    if (credentials instanceof StandardUsernamePasswordCredentials) {
                        StandardUsernamePasswordCredentials userPass = (StandardUsernamePasswordCredentials)credentials;
                        apiUser = userPass != null ? userPass.getUsername() : "";
                        apiPass = userPass != null ? userPass.getPassword().getPlainText() : "";
                        auth.setQualysCredentials(apiServer, AuthType.Basic, apiUser, apiPass, "", "");
                    } else if (credentials instanceof OAuthCredential) {
                        OAuthCredential oauth = (OAuthCredential)credentials;
                        String clientId = oauth.getClientId();
                        String clientSecret = oauth.getClientSecret();
                        auth.setQualysCredentials(apiServer, AuthType.OAuth, "", "", clientId, clientSecret);
                    } else {
                        throw new IllegalArgumentException("Unsupported credential type: " + String.valueOf(credentials.getClass()));
                    }
                }
                if (StringUtils.isNotEmpty((String)proxyCredentialsId)) {
                    StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)proxyCredentialsId));
                    proxyUsername = c != null ? c.getUsername() : "";
                    String string = proxyPassword = c != null ? c.getPassword().getPlainText() : "";
                }
                if (useProxy) {
                    int proxyPortInt = Integer.parseInt(proxyPort);
                    auth.setProxyCredentials(proxyServer, proxyUsername, proxyPassword, proxyPortInt);
                }
                QualysCSClient client = new QualysCSClient(auth, System.out);
                QualysCSTestConnectionResponse resp = client.testConnection();
                logger.info("Received response : " + String.valueOf(resp));
                if (!resp.success) {
                    return FormValidation.error((String)resp.message);
                }
                return FormValidation.ok((String)"Connection test successful!");
            }
            catch (Exception e) {
                e.printStackTrace();
                return FormValidation.error((String)"Connection test failed. (Reason: Wrong inputs. Please check API Server and Proxy details.)");
            }
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.add(credentialsId);
            }
            result.includeEmptyValue();
            for (Object c : CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList())) {
                String label = Helper.buildMaskedLabel(c.getUsername(), "*****", c.getDescription(), c.getId());
                result.add(label, c.getId());
            }
            for (Object c : CredentialsProvider.lookupCredentials(OAuthCredential.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList())) {
                String clientId = Helper.safe(((OAuthCredential)((Object)c)).getClientId());
                String label = Helper.buildMaskedLabel(clientId, "*****", c.getDescription(), c.getId());
                result.add(label, c.getId());
            }
            return result.includeCurrentValue(credentialsId);
        }

        @POST
        public ListBoxModel doFillProxyCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String proxyCredentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.add(proxyCredentialsId);
            }
            return result.withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList())).withMatching(CredentialsMatchers.withId((String)proxyCredentialsId), (IdCredentials[])new StandardCredentials[0]);
        }

        public FormValidation doCheckProxyServer(@QueryParameter String proxyServer) {
            try {
                Pattern patt = Pattern.compile(PROXY_REGEX);
                Matcher matcher = patt.matcher(proxyServer);
                if (!matcher.matches()) {
                    return FormValidation.error((String)"Enter valid server url!");
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckProxyPort(@QueryParameter String proxyPort) {
            block5: {
                try {
                    if (proxyPort != null && !proxyPort.isEmpty() && proxyPort.trim().length() > 0) {
                        int proxyPortInt = Integer.parseInt(proxyPort);
                        if (proxyPortInt < 1 || proxyPortInt > 65535) {
                            return FormValidation.error((String)"Please enter a valid port number!");
                        }
                        break block5;
                    }
                    return FormValidation.error((String)"Please enter a valid port number!");
                }
                catch (RuntimeException e) {
                    return FormValidation.error((String)"Enter valid port number!");
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Enter valid port number!");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckImageIds(@QueryParameter String imageIds) {
            if (StringUtils.isBlank((String)imageIds)) {
                FormValidation.error((String)"Image Ids cannot be empty");
            } else {
                String[] imageIdsString;
                for (String imageId : imageIdsString = imageIds.split(",")) {
                    Pattern pattern3;
                    Matcher matcher3;
                    Pattern pattern2;
                    Matcher matcher2;
                    Pattern pattern = Pattern.compile("^([A-Fa-f0-9]{12}|[A-Fa-f0-9]{64})$");
                    Matcher matcher = pattern.matcher(imageId.trim());
                    if (matcher.find() || (matcher2 = (pattern2 = Pattern.compile("^(?:(?=[^:\\/]{4,253})(?!-)[a-zA-Z0-9-]{1,63}(?<!-)(?:\\.(?!-)[a-zA-Z0-9-]{1,63}(?<!-))*(?::[0-9]{1,5})?/)?((?![:\\/._-])(?:[a-z0-9._-]*)(?<![:\\/._-])(?:/(?![._-])[a-z0-9._-]+(?<![._-]))*)(?::(?![.-])[a-zA-Z0-9_.-]{1,128})?$")).matcher(imageId.trim())).find() || (matcher3 = (pattern3 = Pattern.compile("\\$\\{(.*?)}")).matcher(imageId.trim())).find()) continue;
                    FormValidation.error((String)(imageId.trim() + " is not a valid image ID or name"));
                }
            }
            return FormValidation.ok();
        }
    }
}

