/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.util;

import hudson.model.TaskListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class QuietTaskListenerFactory {
    public static QuietTasklistener build(TaskListener listener) {
        return (QuietTasklistener)Proxy.newProxyInstance(QuietTaskListenerFactory.class.getClassLoader(), new Class[]{QuietTasklistener.class}, (InvocationHandler)new QuietTaskListenerIH(listener));
    }

    public static interface QuietTasklistener
    extends TaskListener {
        public String __getLogOutput();
    }

    protected static class QuietTaskListenerIH
    implements InvocationHandler {
        private final TaskListener underlying;
        private final ByteArrayOutputStream logContent = new ByteArrayOutputStream();
        private final PrintStream out;

        protected QuietTaskListenerIH(TaskListener underlying) {
            this.underlying = underlying;
            PrintStream tmp = null;
            try {
                tmp = new PrintStream((OutputStream)this.logContent, false, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF8 not supported", e);
            }
            this.out = tmp;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if ("getLogger".equals(method.getName())) {
                return this.out;
            }
            if ("__getLogOutput".equals(method.getName())) {
                this.out.flush();
                return this.logContent.toString("UTF-8");
            }
            return method.invoke(o, objects);
        }
    }
}

