/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.util;

import com.openshift.jenkins.plugins.OpenShift;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ClientCommandBuilder
implements Serializable {
    public final String server;
    public final String project;
    public final String verb;
    protected final List verbArgs;
    protected final List userArgs;
    protected final List options;
    protected final String token;
    protected final List verboseOptions;
    public final int logLevel;

    public ClientCommandBuilder(String server, String project, String verb, List verbArgs, List userArgs, List options, List verboseOptions, String token, int logLevel) {
        this.server = server;
        this.project = project;
        this.verb = verb == null ? "help" : verb;
        this.verbArgs = verbArgs;
        this.userArgs = userArgs;
        this.options = options;
        this.token = token;
        this.logLevel = logLevel;
        this.verboseOptions = verboseOptions;
    }

    private static List<String> toStringArray(List l) {
        ArrayList<String> n = new ArrayList<String>();
        if (l == null) {
            return n;
        }
        for (Object o : l) {
            n.add(o.toString());
        }
        return n;
    }

    private boolean hasArg(List<String> args, String ... argsToFind) {
        for (String arg : args) {
            for (String atf : argsToFind) {
                if (!arg.equals(atf) && !arg.startsWith(atf + "=")) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> buildCommand(boolean redacted) {
        ArrayList<String> cmd = new ArrayList<String>();
        String toolName = new OpenShift.DescriptorImpl().getClientToolName();
        cmd.add(toolName);
        cmd.add(this.verb);
        cmd.addAll(ClientCommandBuilder.toStringArray(this.userArgs));
        cmd.addAll(ClientCommandBuilder.toStringArray(this.verbArgs));
        cmd.addAll(ClientCommandBuilder.toStringArray(this.options));
        if (this.server != null) {
            cmd.add("--server=" + this.server);
        }
        if (this.project != null && !this.hasArg(cmd, "-n", "--namespace")) {
            cmd.add("--namespace=" + this.project);
        }
        if (!redacted || this.logLevel > 0) {
            cmd.addAll(ClientCommandBuilder.toStringArray(this.verboseOptions));
            if (!this.hasArg(cmd, "--loglevel")) {
                cmd.add("--loglevel=" + this.logLevel);
            }
        }
        String token = this.token;
        if (redacted && token != null) {
            token = "XXXXX";
        }
        if (token != null && !this.hasArg(cmd, "--token")) {
            cmd.add("--token=" + token);
        }
        return cmd;
    }

    public String asString(boolean redacted) {
        StringBuffer sb = new StringBuffer();
        for (String arg : this.buildCommand(redacted)) {
            sb.append(arg);
            sb.append(" ");
        }
        return sb.toString();
    }
}

