/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.pipeline.OcAction;
import com.openshift.jenkins.plugins.util.ClientCommandBuilder;
import com.openshift.jenkins.plugins.util.QuietTaskListenerFactory;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.durabletask.BourneShellScript;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.WindowsBatchScript;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class OcWatch
extends AbstractStepImpl {
    public static final String FUNCTION_NAME = "_OcWatch";
    private final ClientCommandBuilder cmdBuilder;

    @DataBoundConstructor
    public OcWatch(String server, String project, String verb, List verbArgs, List userArgs, List options, List verboseOptions, String token, int logLevel) {
        this.cmdBuilder = new ClientCommandBuilder(server, project, verb, verbArgs, userArgs, options, verboseOptions, token, logLevel);
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient OcWatch step;
        @StepContextParameter
        private transient FilePath filePath;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient TaskListener listener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void run() {
            block27: {
                this.getContext().saveState();
                this.listener.getLogger().println("Entering watch");
                try {
                    FilePath stderrTmp = this.filePath.createTextTempFile("watchstderr", ".txt", "", false);
                    try {
                        Controller dtc;
                        Integer exitStatus;
                        do {
                            String commandString = this.step.cmdBuilder.asString(false);
                            commandString = commandString + " 2> " + stderrTmp.getRemote() + " 1>&2";
                            Object task = this.launcher.isUnix() ? new BourneShellScript(commandString) : new WindowsBatchScript(commandString);
                            QuietTaskListenerFactory.QuietTasklistener quiet = QuietTaskListenerFactory.build(this.listener);
                            dtc = task.launch(this.envVars, this.filePath, this.launcher, (TaskListener)quiet);
                            OcAction.exitStatusRaceConditionBugWorkaround(dtc, this.filePath, this.launcher);
                            exitStatus = -1;
                            try {
                                long reCheckSleep = 250L;
                                boolean firstPass = true;
                                long outputSize = 0L;
                                do {
                                    byte[] newOutput;
                                    try (InputStream is = stderrTmp.readFromOffset(outputSize);){
                                        newOutput = IOUtils.toByteArray((InputStream)is);
                                    }
                                    outputSize += (long)newOutput.length;
                                    if (newOutput.length > 0 || firstPass) {
                                        firstPass = false;
                                        reCheckSleep = Math.max(250L, reCheckSleep / 2L);
                                        this.listener.getLogger().println("Running watch closure body");
                                        Object o = this.getContext().newBodyInvoker().start().get();
                                        if (!(o instanceof Boolean)) {
                                            this.getContext().onFailure((Throwable)new ClassCastException("watch body return value " + o + " is not boolean"));
                                        }
                                        if (!((Boolean)o).booleanValue()) continue;
                                        this.listener.getLogger().println("watch closure returned true; terminating watch");
                                        dtc.stop(this.filePath, this.launcher);
                                        break block27;
                                    }
                                    reCheckSleep = Math.min(10000, (int)((float)reCheckSleep * 1.2f));
                                    this.listener.getLogger().println("Checking watch output again in " + reCheckSleep + "ms");
                                    Thread.sleep(reCheckSleep);
                                } while ((exitStatus = dtc.exitStatus(this.filePath, this.launcher)) == null);
                            }
                            finally {
                                dtc.cleanup(this.filePath);
                            }
                        } while (exitStatus == 0);
                        throw new AbortException("watch terminated with an error: " + dtc.exitStatus(this.filePath, this.launcher));
                    }
                    finally {
                        stderrTmp.delete();
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    this.getContext().onFailure((Throwable)e);
                }
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return OcWatch.FUNCTION_NAME;
        }

        public String getDisplayName() {
            return "Internal utility function for OpenShift DSL";
        }

        public boolean isAdvanced() {
            return true;
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }
    }
}

