/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline;

import com.openshift.jenkins.plugins.util.ClientCommandBuilder;
import com.openshift.jenkins.plugins.util.QuietTaskListenerFactory;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.durabletask.BourneShellScript;
import org.jenkinsci.plugins.durabletask.Controller;
import org.jenkinsci.plugins.durabletask.WindowsBatchScript;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class OcAction
extends AbstractStepImpl {
    public static final String FUNCTION_NAME = "_OcAction";
    private final ClientCommandBuilder cmdBuilder;
    private final boolean verbose;
    protected final String streamStdOutToConsolePrefix;
    private final HashMap<String, String> reference;

    @DataBoundConstructor
    public OcAction(String server, String project, String verb, List verbArgs, List userArgs, List options, List verboseOptions, String token, String streamStdOutToConsolePrefix, HashMap<String, String> reference, int logLevel) {
        this.cmdBuilder = new ClientCommandBuilder(server, project, verb, verbArgs, userArgs, options, verboseOptions, token, logLevel);
        this.verbose = logLevel > 0;
        this.streamStdOutToConsolePrefix = streamStdOutToConsolePrefix;
        this.reference = reference == null ? new HashMap() : reference;
    }

    public static void exitStatusRaceConditionBugWorkaround(Controller dtc, FilePath filePath, Launcher launcher) throws InterruptedException, IOException {
        for (int tries = 30; tries > 0; --tries) {
            try {
                dtc.exitStatus(filePath, launcher);
                return;
            }
            catch (IOException ioe) {
                if (tries == 1) {
                    throw ioe;
                }
                Thread.sleep(1000L);
                continue;
            }
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<OcActionResult> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient OcAction step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient Run<?, ?> runObj;
        @StepContextParameter
        private transient FilePath filePath;
        @StepContextParameter
        private transient Executor executor;
        @StepContextParameter
        private transient Computer computer;
        private boolean firstPrint = true;

        private void printToConsole(String s) {
            String prefix = "[" + this.step.streamStdOutToConsolePrefix + "] ";
            if (this.firstPrint) {
                this.listener.getLogger().print(prefix);
                this.firstPrint = false;
            }
            this.listener.getLogger().print(s.replace("\n", "\n" + prefix));
            this.listener.getLogger().flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected OcActionResult run() throws Exception {
            String commandString = this.step.cmdBuilder.asString(false);
            String redactedCommandString = this.step.cmdBuilder.asString(true);
            FilePath stdoutTmp = this.filePath.createTextTempFile("ocstdout", ".txt", "", false);
            FilePath stderrTmp = this.filePath.createTextTempFile("ocstderr", ".txt", "", false);
            commandString = commandString + " >> " + stdoutTmp.getRemote() + " 2>> " + stderrTmp.getRemote();
            try {
                byte[] newOutput;
                Serializable serializable;
                InputStream is;
                Integer exitStatus;
                Object task = this.launcher.isUnix() ? new BourneShellScript(commandString) : new WindowsBatchScript(commandString);
                QuietTaskListenerFactory.QuietTasklistener quiet = QuietTaskListenerFactory.build(this.listener);
                Controller dtc = task.launch(this.envVars, this.filePath, this.launcher, (TaskListener)quiet);
                ByteArrayOutputStream stdErr = new ByteArrayOutputStream();
                ByteArrayOutputStream stdOut = new ByteArrayOutputStream();
                OcAction.exitStatusRaceConditionBugWorkaround(dtc, this.filePath, this.launcher);
                long reCheckSleep = 250L;
                while ((exitStatus = dtc.exitStatus(this.filePath, this.launcher)) == null) {
                    Thread.sleep(reCheckSleep);
                    is = stdoutTmp.readFromOffset((long)stdOut.size());
                    serializable = null;
                    try {
                        newOutput = IOUtils.toByteArray((InputStream)is);
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (serializable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    serializable.addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    stdOut.write(newOutput);
                    if (newOutput.length > 0 && this.step.streamStdOutToConsolePrefix != null) {
                        this.printToConsole(new String(newOutput, StandardCharsets.UTF_8));
                        reCheckSleep = 1000L;
                        continue;
                    }
                    if (reCheckSleep >= 10000L) continue;
                    reCheckSleep = (long)((float)reCheckSleep * 1.2f);
                }
                is = stdoutTmp.readFromOffset((long)stdOut.size());
                serializable = null;
                try {
                    newOutput = IOUtils.toByteArray((InputStream)is);
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (serializable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                serializable.addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
                stdOut.write(newOutput);
                if (this.step.streamStdOutToConsolePrefix != null) {
                    this.printToConsole(new String(newOutput, StandardCharsets.UTF_8));
                    this.listener.getLogger().println();
                }
                is = stderrTmp.read();
                serializable = null;
                try {
                    stdErr.write(IOUtils.toByteArray((InputStream)is));
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (serializable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                serializable.addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
                OcActionResult result = new OcActionResult();
                result.verb = ((OcAction)this.step).cmdBuilder.verb;
                result.cmd = redactedCommandString;
                result.status = exitStatus;
                result.out = stdOut.toString("UTF-8").trim();
                result.err = stdErr.toString("UTF-8").trim();
                result.reference = this.step.reference;
                if (this.step.verbose) {
                    this.listener.getLogger().println("Verbose sub-step output:");
                    this.listener.getLogger().println("\tCommand> " + result.cmd);
                    this.listener.getLogger().println("\tStatus> " + result.status);
                    this.listener.getLogger().println("\tStdOut>" + result.out);
                    this.listener.getLogger().println("\tStdErr> " + result.err);
                    this.listener.getLogger().println("\tReference> " + result.reference);
                }
                dtc.cleanup(this.filePath);
                serializable = result;
                return serializable;
            }
            finally {
                stdoutTmp.delete();
                stderrTmp.delete();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return OcAction.FUNCTION_NAME;
        }

        public String getDisplayName() {
            return "Internal utility function for OpenShift DSL";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class OcActionResult
    implements Serializable {
        @Whitelisted
        public String verb;
        @Whitelisted
        public String cmd;
        @Whitelisted
        public String out;
        @Whitelisted
        public String err;
        @Whitelisted
        public int status;
        @Whitelisted
        public HashMap<String, String> reference = new HashMap();

        public HashMap toMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("verb", this.verb);
            m.put("cmd", this.cmd);
            m.put("out", this.out);
            m.put("err", this.err);
            m.put("reference", this.reference);
            m.put("status", this.status);
            return m;
        }

        @Whitelisted
        public String toString() {
            return this.toMap().toString();
        }

        public boolean isFailed() {
            return this.status != 0;
        }

        public void failIf(String failMessage) throws AbortException {
            if (this.isFailed()) {
                throw new AbortException(failMessage + "; action failed: " + this.toString());
            }
        }
    }
}

