/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.freestyle.model;

import com.google.common.base.Strings;
import com.openshift.jenkins.plugins.freestyle.model.Label;
import com.openshift.jenkins.plugins.freestyle.model.ResourceName;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class ResourceSelector
extends AbstractDescribableImpl<ResourceSelector>
implements Serializable {
    private static final String SELECT_BY_NAMES = "SELECT_BY_NAMES";
    private static final String SELECT_BY_KIND = "SELECT_BY_KIND";
    private String kind;
    private List<Label> labels;
    private List<ResourceName> names;

    public boolean isSelectionType(String type) {
        if (SELECT_BY_KIND.equals(type)) {
            return !Strings.isNullOrEmpty((String)this.kind);
        }
        return true;
    }

    @DataBoundConstructor
    public ResourceSelector() {
    }

    @DataBoundSetter
    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getKind() {
        return this.kind;
    }

    @DataBoundSetter
    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    @DataBoundSetter
    public void setNames(List<ResourceName> names) {
        this.names = names;
    }

    public List<ResourceName> getNames() {
        return this.names;
    }

    public List<String> asSelectionArgs() {
        ArrayList<String> args;
        block3: {
            block2: {
                args = new ArrayList<String>();
                if (this.names == null) break block2;
                for (ResourceName res : this.names) {
                    args.add(res.getName());
                }
                break block3;
            }
            args.add(this.kind);
            if (this.labels == null) break block3;
            for (Label e : this.labels) {
                args.add("-l " + e.getName() + "=" + e.getValue());
            }
        }
        return args;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ResourceSelector> {
        public String getDisplayName() {
            return "Selection";
        }

        public ResourceSelector newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ResourceSelector s = (ResourceSelector)super.newInstance(req, formData);
            String selectionType = formData.getString("selectionType");
            System.out.println("parms2: " + selectionType);
            if (ResourceSelector.SELECT_BY_KIND.equals(selectionType)) {
                s.names = null;
            }
            if (ResourceSelector.SELECT_BY_NAMES.equals(selectionType)) {
                s.kind = null;
                s.labels = null;
            }
            return s;
        }
    }
}

