/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deployhub;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.AbstractItem;
import hudson.model.Hudson;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.io.File;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class LastDeployTime
extends ListViewColumn {
    private boolean displayName;
    private boolean trim;
    private int displayLength;
    private int columnWidth;
    private boolean forceWidth;

    @DataBoundConstructor
    public LastDeployTime(boolean displayName, boolean trim, int displayLength, int columnWidth, boolean forceWidth) {
        this.displayName = displayName;
        this.trim = trim;
        this.displayLength = displayLength;
        this.columnWidth = columnWidth;
        this.forceWidth = forceWidth;
    }

    public LastDeployTime() {
        this(false, false, 1, 80, false);
    }

    public boolean isDisplayName() {
        return this.displayName;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public int getDisplayLength() {
        return this.displayLength;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public boolean isForceWidth() {
        return this.forceWidth;
    }

    public String getToolTip(AbstractItem job) {
        return this.formatDescription(job, false);
    }

    public String getDescription(AbstractItem job) {
        return this.formatDescription(job, this.isTrim());
    }

    private String formatDescription(AbstractItem job, boolean trimIt) {
        if (job == null) {
            return null;
        }
        String rootDir = job.getRootDir().getAbsolutePath();
        XmlFile t = new XmlFile(Hudson.XSTREAM, new File(rootDir, "DeployHub.xml"));
        if (t != null && t.exists()) {
            try {
                JSONObject keyvals = (JSONObject)t.read();
                if (keyvals.containsKey((Object)"DeploymentID")) {
                    return keyvals.get("DeploymentID").toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "N/A";
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return true;
        }

        public String getDisplayName() {
            return "Last Deployment";
        }

        public String getHelpFile() {
            return "/plugins/DeployHub/help-description-column.html";
        }
    }
}

